/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.util.LongSummaryStatistics;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.NotSerializableException;
import org.infinispan.commons.util.Util;
import org.infinispan.marshall.exts.SecurityActions;

public class LongSummaryStatisticsExternalizer
extends AbstractExternalizer<LongSummaryStatistics> {
    static final Field countField = SecurityActions.getField(LongSummaryStatistics.class, "count");
    static final Field sumField = SecurityActions.getField(LongSummaryStatistics.class, "sum");
    static final Field minField = SecurityActions.getField(LongSummaryStatistics.class, "min");
    static final Field maxField = SecurityActions.getField(LongSummaryStatistics.class, "max");
    static final boolean canSerialize = countField != null && sumField != null && minField != null && maxField != null;

    public Set<Class<? extends LongSummaryStatistics>> getTypeClasses() {
        return Util.asSet((Object[])new Class[]{LongSummaryStatistics.class});
    }

    private void verifySerialization() {
        if (!canSerialize) {
            throw new NotSerializableException("LongSummaryStatistics is not serializable, fields not available!");
        }
    }

    public void writeObject(ObjectOutput output, LongSummaryStatistics object) throws IOException {
        this.verifySerialization();
        try {
            output.writeLong(countField.getLong(object));
            output.writeLong(sumField.getLong(object));
            output.writeLong(minField.getLong(object));
            output.writeLong(maxField.getLong(object));
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
    }

    public LongSummaryStatistics readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        this.verifySerialization();
        LongSummaryStatistics summaryStatistics = new LongSummaryStatistics();
        try {
            countField.setLong(summaryStatistics, input.readLong());
            sumField.setLong(summaryStatistics, input.readLong());
            minField.setLong(summaryStatistics, input.readLong());
            maxField.setLong(summaryStatistics, input.readLong());
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
        return summaryStatistics;
    }

    public Integer getId() {
        return 22;
    }
}

