/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.cluster;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryExpiredEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.event.impl.EventImpl;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.GlobalTransaction;

public class ClusterEvent<K, V>
implements CacheEntryCreatedEvent<K, V>,
CacheEntryRemovedEvent<K, V>,
CacheEntryModifiedEvent<K, V>,
CacheEntryExpiredEvent<K, V> {
    transient Cache<K, V> cache;
    private final K key;
    private final V value;
    private final V oldValue;
    private final Metadata metadata;
    private final Event.Type type;
    private final GlobalTransaction transaction;
    private final Address origin;
    private final boolean commandRetried;

    public static <K, V> ClusterEvent<K, V> fromEvent(CacheEntryEvent<K, V> event) {
        boolean commandRetried;
        if (event instanceof ClusterEvent) {
            return (ClusterEvent)event;
        }
        V oldValue = null;
        Event.Type eventType = event.getType();
        switch (eventType) {
            case CACHE_ENTRY_REMOVED: {
                oldValue = ((CacheEntryRemovedEvent)event).getOldValue();
                commandRetried = ((CacheEntryRemovedEvent)event).isCommandRetried();
                break;
            }
            case CACHE_ENTRY_CREATED: {
                commandRetried = ((CacheEntryCreatedEvent)event).isCommandRetried();
                break;
            }
            case CACHE_ENTRY_MODIFIED: {
                commandRetried = ((CacheEntryModifiedEvent)event).isCommandRetried();
                break;
            }
            case CACHE_ENTRY_EXPIRED: {
                commandRetried = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cluster Event can only be created from a CacheEntryRemoved, CacheEntryCreated or CacheEntryModified event!");
            }
        }
        GlobalTransaction transaction = event.getGlobalTransaction();
        Metadata metadata = null;
        if (event instanceof EventImpl) {
            metadata = ((EventImpl)event).getMetadata();
        }
        ClusterEvent<K, Object> clusterEvent = new ClusterEvent<K, Object>(event.getKey(), event.getValue(), oldValue, metadata, eventType, event.getCache().getCacheManager().getAddress(), transaction, commandRetried);
        clusterEvent.cache = event.getCache();
        return clusterEvent;
    }

    ClusterEvent(K key, V value, V oldValue, Metadata metadata, Event.Type type, Address origin, GlobalTransaction transaction, boolean commandRetried) {
        this.key = key;
        this.value = value;
        this.oldValue = oldValue;
        this.metadata = metadata;
        this.type = type;
        this.origin = origin;
        this.transaction = transaction;
        this.commandRetried = commandRetried;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean isCommandRetried() {
        return this.commandRetried;
    }

    @Override
    public V getOldValue() {
        return this.oldValue;
    }

    @Override
    public boolean isCreated() {
        return this.type == Event.Type.CACHE_ENTRY_CREATED;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public GlobalTransaction getGlobalTransaction() {
        return this.transaction;
    }

    @Override
    public boolean isOriginLocal() {
        if (this.cache != null) {
            return this.cache.getCacheManager().getAddress().equals(this.origin);
        }
        return false;
    }

    @Override
    public Event.Type getType() {
        return this.type;
    }

    @Override
    public boolean isPre() {
        return false;
    }

    @Override
    public Cache<K, V> getCache() {
        return this.cache;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterEvent that = (ClusterEvent)o;
        if (this.commandRetried != that.commandRetried) {
            return false;
        }
        if (this.cache != null ? !this.cache.equals(that.cache) : that.cache != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.oldValue != null ? !this.oldValue.equals(that.oldValue) : that.oldValue != null) {
            return false;
        }
        if (this.origin != null ? !this.origin.equals(that.origin) : that.origin != null) {
            return false;
        }
        if (this.transaction != null ? !this.transaction.equals(that.transaction) : that.transaction != null) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.cache != null ? this.cache.hashCode() : 0;
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.oldValue != null ? this.oldValue.hashCode() : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.transaction != null ? this.transaction.hashCode() : 0);
        result = 31 * result + (this.origin != null ? this.origin.hashCode() : 0);
        result = 31 * result + (this.commandRetried ? 1 : 0);
        return result;
    }

    public String toString() {
        return "ClusterEvent {type=" + (Object)((Object)this.type) + ", cache=" + this.cache + ", key=" + this.key + ", value=" + this.value + ", oldValue=" + this.oldValue + ", transaction=" + this.transaction + ", retryCommand=" + this.commandRetried + ", origin=" + this.origin + '}';
    }

    public static class Externalizer
    extends AbstractExternalizer<ClusterEvent> {
        public Set<Class<? extends ClusterEvent>> getTypeClasses() {
            return Collections.singleton(ClusterEvent.class);
        }

        public void writeObject(ObjectOutput output, ClusterEvent object) throws IOException {
            output.writeObject(object.key);
            output.writeObject(object.value);
            output.writeObject(object.oldValue);
            output.writeObject(object.metadata);
            output.writeObject((Object)object.type);
            output.writeObject(object.origin);
            output.writeObject(object.transaction);
            output.writeBoolean(object.commandRetried);
        }

        public ClusterEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new ClusterEvent<Object, Object>(input.readObject(), input.readObject(), input.readObject(), (Metadata)input.readObject(), (Event.Type)((Object)input.readObject()), (Address)input.readObject(), (GlobalTransaction)input.readObject(), input.readBoolean());
        }

        public Integer getId() {
            return 125;
        }
    }
}

