/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.termop.primitive;

import java.util.List;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.stream.impl.intops.IntermediateOperation;
import org.infinispan.stream.impl.termop.AbstractForEachOperation;

public class ForEachFlatMapObjLongOperation<K>
extends AbstractForEachOperation<K, Long, LongStream> {
    private final ObjLongConsumer<Cache<K, ?>> consumer;
    private transient Cache<K, ?> cache;

    public ForEachFlatMapObjLongOperation(Iterable<IntermediateOperation> intermediateOperations, Supplier<Stream<CacheEntry>> supplier, int batchSize, ObjLongConsumer<Cache<K, ?>> consumer) {
        super(intermediateOperations, supplier, batchSize);
        this.consumer = consumer;
    }

    @Override
    protected void handleList(List<Long> list) {
        list.forEach(d -> this.consumer.accept(this.cache, (long)d));
    }

    @Override
    protected void handleStreamForEach(LongStream stream, List<Long> list) {
        stream.forEach(list::add);
    }

    public ObjLongConsumer<Cache<K, ?>> getConsumer() {
        return this.consumer;
    }

    @Override
    public void handleInjection(ComponentRegistry registry) {
        super.handleInjection(registry);
        this.cache = registry.getComponent(Cache.class);
    }
}

