/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport;

import org.infinispan.commons.util.Experimental;
import org.infinispan.remoting.RpcException;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.ResponseCollectors;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Experimental
public abstract class ValidSingleResponseCollector<T>
implements ResponseCollector<T> {
    protected static final Log log = LogFactory.getLog(ValidSingleResponseCollector.class);

    @Override
    public final T addResponse(Address sender, Response response) {
        if (response instanceof ValidResponse) {
            return this.withValidResponse(sender, (ValidResponse)response);
        }
        if (response instanceof ExceptionResponse) {
            return this.withException(sender, ((ExceptionResponse)response).getException());
        }
        if (response instanceof CacheNotFoundResponse) {
            return this.targetNotFound(sender);
        }
        return this.withException(sender, (Exception)((Object)new RpcException("Unknown response type: " + response)));
    }

    @Override
    public final T finish() {
        return null;
    }

    protected T withException(Address sender, Exception exception) {
        throw ResponseCollectors.wrapRemoteException(sender, exception);
    }

    protected abstract T withValidResponse(Address var1, ValidResponse var2);

    protected abstract T targetNotFound(Address var1);
}

