/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollectors;
import org.infinispan.remoting.transport.ValidResponseCollector;
import org.infinispan.util.concurrent.CompletableFutures;

public class SyncMapResponseCollector
extends ValidResponseCollector<Map<Address, Response>> {
    private final HashMap<Address, Response> map;
    private final boolean ignoreLeavers;
    private Exception exception;

    public SyncMapResponseCollector(boolean ignoreLeavers, int expectedSize) {
        this.map = new HashMap(CollectionFactory.computeCapacity((int)expectedSize));
        this.ignoreLeavers = ignoreLeavers;
    }

    @Override
    protected Map<Address, Response> addTargetNotFound(Address sender) {
        if (this.ignoreLeavers) {
            this.map.put(sender, CacheNotFoundResponse.INSTANCE);
            return null;
        }
        throw ResponseCollectors.remoteNodeSuspected(sender);
    }

    @Override
    protected Map<Address, Response> addException(Address sender, Exception exception) {
        CacheException e = ResponseCollectors.wrapRemoteException(sender, exception);
        if (this.exception == null) {
            this.exception = e;
        } else {
            this.exception.addSuppressed(e);
        }
        return null;
    }

    @Override
    protected Map<Address, Response> addValidResponse(Address sender, ValidResponse response) {
        this.map.put(sender, response);
        return null;
    }

    @Override
    public Map<Address, Response> finish() {
        if (this.exception != null) {
            throw CompletableFutures.asCompletionException(this.exception);
        }
        return this.map;
    }
}

