/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.transaction.xa.GlobalTransaction;

public class TransactionInfo {
    private final GlobalTransaction globalTransaction;
    private final WriteCommand[] modifications;
    private final Set<Object> lockedKeys;
    private final int topologyId;

    public TransactionInfo(GlobalTransaction globalTransaction, int topologyId, WriteCommand[] modifications, Set<Object> lockedKeys) {
        this.globalTransaction = globalTransaction;
        this.topologyId = topologyId;
        this.modifications = modifications;
        this.lockedKeys = lockedKeys;
    }

    public GlobalTransaction getGlobalTransaction() {
        return this.globalTransaction;
    }

    public WriteCommand[] getModifications() {
        return this.modifications;
    }

    public Set<Object> getLockedKeys() {
        return this.lockedKeys;
    }

    public int getTopologyId() {
        return this.topologyId;
    }

    public String toString() {
        return "TransactionInfo{globalTransaction=" + this.globalTransaction + ", topologyId=" + this.topologyId + ", modifications=" + Arrays.toString(this.modifications) + ", lockedKeys=" + this.lockedKeys + '}';
    }

    public static class Externalizer
    extends AbstractExternalizer<TransactionInfo> {
        public Integer getId() {
            return 46;
        }

        public Set<Class<? extends TransactionInfo>> getTypeClasses() {
            return Collections.singleton(TransactionInfo.class);
        }

        public void writeObject(ObjectOutput output, TransactionInfo object) throws IOException {
            output.writeObject(object.globalTransaction);
            output.writeInt(object.topologyId);
            MarshallUtil.marshallArray((Object[])object.modifications, (ObjectOutput)output);
            MarshallUtil.marshallCollection((Collection)object.lockedKeys, (ObjectOutput)output);
        }

        public TransactionInfo readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            GlobalTransaction globalTransaction = (GlobalTransaction)input.readObject();
            int topologyId = input.readInt();
            WriteCommand[] modifications = (WriteCommand[])MarshallUtil.unmarshallArray((ObjectInput)input, WriteCommand[]::new);
            Set lockedKeys = (Set)MarshallUtil.unmarshallCollection((ObjectInput)input, HashSet::new);
            return new TransactionInfo(globalTransaction, topologyId, modifications, lockedKeys);
        }
    }
}

