/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.function.BiFunction;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.MetadataAwareCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.BackupWriteRpcCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.Metadatas;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.UserRaisedFunctionalException;

public class ComputeCommand
extends AbstractDataWriteCommand
implements MetadataAwareCommand {
    public static final int COMMAND_ID = 68;
    private BiFunction remappingBiFunction;
    private Metadata metadata;
    private CacheNotifier<Object, Object> notifier;
    private boolean computeIfPresent;
    private boolean successful;

    public ComputeCommand() {
    }

    public ComputeCommand(Object key, BiFunction remappingBiFunction, boolean computeIfPresent, long flagsBitSet, CommandInvocationId commandInvocationId, Metadata metadata, CacheNotifier notifier, ComponentRegistry componentRegistry) {
        super(key, flagsBitSet, commandInvocationId);
        this.remappingBiFunction = remappingBiFunction;
        this.computeIfPresent = computeIfPresent;
        this.metadata = metadata;
        this.notifier = notifier;
        componentRegistry.wireDependencies(this.remappingBiFunction);
    }

    public boolean isComputeIfPresent() {
        return this.computeIfPresent;
    }

    public void setComputeIfPresent(boolean computeIfPresent) {
        this.computeIfPresent = computeIfPresent;
    }

    public void init(CacheNotifier notifier, ComponentRegistry componentRegistry) {
        this.notifier = notifier;
        componentRegistry.wireDependencies(this.remappingBiFunction);
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public boolean isConditional() {
        return this.isComputeIfPresent();
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return ValueMatcher.MATCH_ALWAYS;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
    }

    @Override
    public void fail() {
        this.successful = false;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        Object newValue;
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(this.key);
        if (e == null) {
            throw new IllegalStateException("Not wrapped");
        }
        Object oldValue = e.getValue();
        if (this.computeIfPresent && oldValue == null) {
            return oldValue;
        }
        try {
            newValue = this.remappingBiFunction.apply(this.key, oldValue);
        }
        catch (RuntimeException ex) {
            throw new UserRaisedFunctionalException(ex);
        }
        this.successful = true;
        if (oldValue == null && newValue == null) {
            return null;
        }
        if (oldValue != null) {
            if (newValue != null) {
                this.notifier.notifyCacheEntryModified(this.key, newValue, this.metadata, oldValue, e.getMetadata(), true, ctx, this);
                e.setChanged(true);
                e.setValue(newValue);
                Metadatas.updateMetadata(e, this.metadata);
            } else {
                this.notifier.notifyCacheEntryRemoved(this.key, oldValue, e.getMetadata(), true, ctx, this);
                e.setRemoved(true);
                e.setValid(false);
                e.setChanged(true);
                e.setValue(null);
            }
        } else {
            this.notifier.notifyCacheEntryCreated(this.key, newValue, this.metadata, true, ctx, this);
            e.setValue(newValue);
            e.setChanged(true);
            Metadatas.updateMetadata(e, this.metadata);
            if (e.isRemoved()) {
                e.setCreated(true);
                e.setExpired(false);
                e.setRemoved(false);
                e.setValid(true);
            }
        }
        return newValue;
    }

    @Override
    public byte getCommandId() {
        return 68;
    }

    public BiFunction getRemappingBiFunction() {
        return this.remappingBiFunction;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeBoolean(this.computeIfPresent);
        output.writeObject(this.remappingBiFunction);
        output.writeObject(this.metadata);
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.computeIfPresent = input.readBoolean();
        this.remappingBiFunction = (BiFunction)input.readObject();
        this.metadata = (Metadata)input.readObject();
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.setFlagsBitSet(input.readLong());
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitComputeCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.PRIMARY;
    }

    @Override
    public void initBackupWriteRpcCommand(BackupWriteRpcCommand command) {
        command.setCompute(this.commandInvocationId, this.key, this.remappingBiFunction, this.computeIfPresent, this.metadata, this.getFlagsBitSet(), this.getTopologyId());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComputeCommand that = (ComputeCommand)o;
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.computeIfPresent, that.computeIfPresent)) {
            return false;
        }
        return Objects.equals(this.remappingBiFunction, this.remappingBiFunction);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.computeIfPresent, this.remappingBiFunction, this.metadata);
    }

    @Override
    public String toString() {
        return "ComputeCommand{key=" + Util.toStr((Object)this.key) + ", isComputeIfPresent=" + Util.toStr((Object)this.computeIfPresent) + ", remappingBiFunction=" + Util.toStr((Object)this.remappingBiFunction) + ", metadata=" + this.metadata + ", flags=" + this.printFlags() + ", successful=" + this.isSuccessful() + ", valueMatcher=" + (Object)((Object)this.getValueMatcher()) + ", topologyId=" + this.getTopologyId() + '}';
    }

    @Override
    public final boolean isReturnValueExpected() {
        return true;
    }
}

