/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import org.infinispan.container.offheap.OffHeapMemory;

class OffHeapLruNode {
    private static final OffHeapMemory MEMORY = OffHeapMemory.INSTANCE;
    private static final int ADDRESS_SIZE = 8;
    private static final int HASHCODE_SIZE = 4;
    private static final int HASH_ENTRY_OFFSET = 0;
    private static final int PREVIOUS_NODE_OFFSET = 8;
    private static final int NEXT_NODE_OFFSET = 16;
    private static final int HASHCODE_OFFSET = 24;
    private static final int SIZE = 28;

    private OffHeapLruNode() {
    }

    static int getSize() {
        return 28;
    }

    static long getEntry(long lruNodeAddress) {
        return MEMORY.getLong(lruNodeAddress, 0L);
    }

    static void setEntry(long lruNodeAddress, long entryAddress) {
        MEMORY.putLong(lruNodeAddress, 0L, entryAddress);
    }

    static long getNext(long lruNodeAddress) {
        return MEMORY.getLong(lruNodeAddress, 16L);
    }

    static void setNext(long lruNodeAddress, long nextAddress) {
        MEMORY.putLong(lruNodeAddress, 16L, nextAddress);
    }

    static long getPrevious(long lruNodeAddress) {
        return MEMORY.getLong(lruNodeAddress, 8L);
    }

    static void setPrevious(long lruNodeAddress, long previousAddress) {
        MEMORY.putLong(lruNodeAddress, 8L, previousAddress);
    }

    static int getHashCode(long lruNodeAddress) {
        return MEMORY.getInt(lruNodeAddress, 24L);
    }

    static void setHashCode(long lruNodeAddress, int hashCode) {
        MEMORY.putInt(lruNodeAddress, 24L, hashCode);
    }

    static String debugString(long address) {
        return String.format("0x%016x <-- 0x%016x (entry 0x%016x, hash 0x%08x) --> 0x%016x", OffHeapLruNode.getPrevious(address), address, OffHeapLruNode.getEntry(address), OffHeapLruNode.getHashCode(address), OffHeapLruNode.getNext(address));
    }
}

