/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.manager;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.infinispan.commons.util.ByRef;
import org.infinispan.container.DataContainer;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.InequalVersionComparisonResult;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.metadata.Metadata;
import org.infinispan.persistence.manager.OrderedUpdatesManager;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.util.concurrent.CompletableFutures;

public class OrderedUpdatesManagerImpl
implements OrderedUpdatesManager {
    private DataContainer<Object, Object> dataContainer;
    private DistributionManager distributionManager;
    private PersistenceManager persistenceManager;
    private ConcurrentHashMap<Object, CompletableFuture<?>> locks = new ConcurrentHashMap();

    @Inject
    public void inject(DataContainer dataContainer, DistributionManager distributionManager, PersistenceManager persistenceManager) {
        this.dataContainer = dataContainer;
        this.distributionManager = distributionManager;
        this.persistenceManager = persistenceManager;
    }

    @Override
    public CompletableFuture<?> waitFuture(Object key) {
        return this.locks.get(key);
    }

    private void lock(Object key, ByRef<CompletableFuture<?>> lockedFuture, ByRef<CompletableFuture<?>> waitFuture) {
        CompletableFuture myFuture = new CompletableFuture();
        CompletableFuture prevFuture = this.locks.putIfAbsent(key, myFuture);
        if (prevFuture == null) {
            lockedFuture.set(myFuture);
        } else {
            waitFuture.set(prevFuture);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> checkLockAndStore(Object key, EntryVersion version, Function<CompletableFuture<?>, CompletableFuture<?>> enableTimeout, Consumer<Object> store) {
        ByRef lockedFuture = new ByRef(null);
        ByRef waitFuture = new ByRef(null);
        this.dataContainer.compute(key, (k, oldEntry, factory) -> {
            EntryVersion oldVersion;
            if (oldEntry == null) {
                return null;
            }
            Metadata oldMetadata = oldEntry.getMetadata();
            if (oldMetadata == null || (oldVersion = oldMetadata.version()) == null) {
                this.lock(k, lockedFuture, waitFuture);
            } else {
                InequalVersionComparisonResult result = oldVersion.compareTo(version);
                switch (result) {
                    case AFTER: {
                        break;
                    }
                    case EQUAL: {
                        this.lock(k, lockedFuture, waitFuture);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("DC version: " + oldVersion + ", cmd version " + version);
                    }
                }
            }
            return oldEntry;
        });
        CompletableFuture wf = (CompletableFuture)waitFuture.get();
        if (wf != null) {
            return enableTimeout.apply(wf).thenCompose(nil -> this.checkLockAndStore(key, version, enableTimeout, store));
        }
        CompletableFuture lf = (CompletableFuture)lockedFuture.get();
        if (lf != null) {
            try {
                store.accept(key);
            }
            finally {
                if (!this.locks.remove(key, lf)) {
                    throw new IllegalStateException("No one but me should be able to replace the future");
                }
                lf.complete(null);
            }
        }
        return null;
    }

    @Override
    public CompletableFuture<?> invalidate(Object[] keys) {
        Object key;
        ArrayList futures = null;
        for (int i = 0; i < keys.length && (key = keys[i]) != null; ++i) {
            CompletableFuture<?> future = this.checkLockAndRemove(key);
            if (future == null || future.isDone()) continue;
            if (futures == null) {
                futures = new ArrayList();
            }
            futures.add(future);
        }
        if (futures == null) {
            return CompletableFutures.completedNull();
        }
        if (futures.size() == 1) {
            return (CompletableFuture)futures.get(0);
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<?> checkLockAndRemove(Object key) {
        ByRef lockedFuture = new ByRef(null);
        ByRef waitFuture = new ByRef(null);
        this.dataContainer.compute(key, (k, oldEntry, factory) -> {
            if (oldEntry == null) {
                this.lock(k, lockedFuture, waitFuture);
            }
            return oldEntry;
        });
        CompletableFuture wf = (CompletableFuture)waitFuture.get();
        if (wf != null) {
            return wf.thenCompose(nil -> this.checkLockAndRemove(key));
        }
        CompletableFuture lf = (CompletableFuture)lockedFuture.get();
        if (lf != null) {
            try {
                DistributionInfo info = this.distributionManager.getCacheTopology().getDistribution(key);
                PersistenceManager.AccessMode mode = info.isPrimary() ? PersistenceManager.AccessMode.BOTH : PersistenceManager.AccessMode.PRIVATE;
                this.persistenceManager.deleteFromAllStores(key, mode);
            }
            finally {
                if (!this.locks.remove(key, lf)) {
                    throw new IllegalStateException("No one but me should be able to replace the future");
                }
                lf.complete(null);
            }
        }
        return null;
    }
}

