/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import org.infinispan.commands.AbstractTopologyAffectedCommand;
import org.infinispan.commands.LocalCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.Params;

public class ReadOnlyManyCommand<K, V, R>
extends AbstractTopologyAffectedCommand
implements LocalCommand {
    public static final int COMMAND_ID = 63;
    protected Collection<? extends K> keys;
    protected Function<EntryView.ReadEntryView<K, V>, R> f;
    protected Params params;
    protected DataConversion keyDataConversion;
    protected DataConversion valueDataConversion;

    public ReadOnlyManyCommand(Collection<? extends K> keys, Function<EntryView.ReadEntryView<K, V>, R> f, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion, ComponentRegistry componentRegistry) {
        this.keys = keys;
        this.f = f;
        this.params = params;
        this.keyDataConversion = keyDataConversion;
        this.valueDataConversion = valueDataConversion;
        this.setFlagsBitSet(params.toFlagsBitSet());
        this.init(componentRegistry);
    }

    public ReadOnlyManyCommand() {
    }

    public ReadOnlyManyCommand(ReadOnlyManyCommand c) {
        this.keys = c.keys;
        this.f = c.f;
        this.params = c.params;
        this.setFlagsBitSet(c.getFlagsBitSet());
        this.keyDataConversion = c.keyDataConversion;
        this.valueDataConversion = c.valueDataConversion;
    }

    public void init(ComponentRegistry componentRegistry) {
        componentRegistry.wireDependencies(this.keyDataConversion);
        componentRegistry.wireDependencies(this.valueDataConversion);
    }

    public Collection<? extends K> getKeys() {
        return this.keys;
    }

    public void setKeys(Collection<? extends K> keys) {
        this.keys = keys;
    }

    public final ReadOnlyManyCommand<K, V, R> withKeys(Collection<? extends K> keys) {
        this.setKeys(keys);
        return this;
    }

    @Override
    public byte getCommandId() {
        return 63;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallCollection(this.keys, (ObjectOutput)output);
        output.writeObject(this.f);
        Params.writeObject(output, this.params);
        output.writeObject(this.keyDataConversion);
        output.writeObject(this.valueDataConversion);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.keys = MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
        this.f = (Function)input.readObject();
        this.params = Params.readObject(input);
        this.setFlagsBitSet(this.params.toFlagsBitSet());
        this.keyDataConversion = (DataConversion)input.readObject();
        this.valueDataConversion = (DataConversion)input.readObject();
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        ArrayList<R> retvals = new ArrayList<R>(this.keys.size());
        for (K k : this.keys) {
            CacheEntry<K, V> me = this.lookupCacheEntry(ctx, k);
            R ret = this.f.apply(me.isNull() ? EntryViews.noValue(k, this.keyDataConversion) : EntryViews.readOnly(me, this.keyDataConversion, this.valueDataConversion));
            retvals.add(EntryViews.snapshot(ret));
        }
        return retvals.stream();
    }

    protected CacheEntry<K, V> lookupCacheEntry(InvocationContext ctx, Object key) {
        return ctx.lookupEntry(key);
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReadOnlyManyCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.OWNER;
    }

    public DataConversion getKeyDataConversion() {
        return this.keyDataConversion;
    }

    public DataConversion getValueDataConversion() {
        return this.valueDataConversion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReadOnlyManyCommand{");
        sb.append(", keys=").append(this.keys);
        sb.append(", f=").append(this.f.getClass().getName());
        sb.append(", keyDataConversion=").append(this.keyDataConversion);
        sb.append(", valueDataConversion=").append(this.valueDataConversion);
        sb.append('}');
        return sb.toString();
    }
}

