/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.infinispan.commands.AbstractTopologyAffectedCommand;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.MetadataAwareCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.Metadatas;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.concurrent.locks.RemoteLockCommand;

public class PutMapCommand
extends AbstractTopologyAffectedCommand
implements WriteCommand,
MetadataAwareCommand,
RemoteLockCommand {
    public static final byte COMMAND_ID = 9;
    private Map<Object, Object> map;
    private CacheNotifier<Object, Object> notifier;
    private Metadata metadata;
    private boolean isForwarded = false;
    private CommandInvocationId commandInvocationId;

    @Override
    public CommandInvocationId getCommandInvocationId() {
        return this.commandInvocationId;
    }

    public PutMapCommand() {
    }

    public PutMapCommand(Map<?, ?> map, CacheNotifier notifier, Metadata metadata, long flagsBitSet, CommandInvocationId commandInvocationId) {
        this.map = map;
        this.notifier = notifier;
        this.metadata = metadata;
        this.commandInvocationId = commandInvocationId;
        this.setFlagsBitSet(flagsBitSet);
    }

    public PutMapCommand(PutMapCommand command) {
        this(command, true);
    }

    public PutMapCommand(PutMapCommand command, boolean generateNewId) {
        this.map = command.map;
        this.notifier = command.notifier;
        this.metadata = command.metadata;
        this.isForwarded = command.isForwarded;
        this.commandInvocationId = generateNewId ? CommandInvocationId.generateIdFrom(command.commandInvocationId) : command.commandInvocationId;
        this.setFlagsBitSet(command.getFlagsBitSet());
    }

    public void init(CacheNotifier<Object, Object> notifier) {
        this.notifier = notifier;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitPutMapCommand(ctx, this);
    }

    @Override
    public Collection<?> getKeysToLock() {
        return this.isForwarded ? Collections.emptyList() : Collections.unmodifiableCollection(this.map.keySet());
    }

    @Override
    public Object getKeyLockOwner() {
        return this.commandInvocationId;
    }

    @Override
    public boolean hasZeroLockAcquisition() {
        return this.hasAnyFlag(FlagBitSets.ZERO_LOCK_ACQUISITION_TIMEOUT);
    }

    @Override
    public boolean hasSkipLocking() {
        return this.hasAnyFlag(FlagBitSets.SKIP_LOCKING);
    }

    private MVCCEntry<Object, Object> lookupMvccEntry(InvocationContext ctx, Object key) {
        return (MVCCEntry)ctx.lookupEntry(key);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        HashMap previousValues = this.hasAnyFlag(FlagBitSets.IGNORE_RETURN_VALUES) ? null : new HashMap(this.map.size());
        for (Map.Entry<Object, Object> e : this.map.entrySet()) {
            Object key = e.getKey();
            MVCCEntry<Object, Object> contextEntry = this.lookupMvccEntry(ctx, key);
            if (contextEntry == null) continue;
            Object newValue = e.getValue();
            Object previousValue = contextEntry.getValue();
            Metadata previousMetadata = contextEntry.getMetadata();
            if (previousValues != null) {
                previousValues.put(key, previousValue);
            }
            if (contextEntry.isCreated()) {
                this.notifier.notifyCacheEntryCreated(key, newValue, this.metadata, true, ctx, this);
            } else {
                this.notifier.notifyCacheEntryModified(key, newValue, this.metadata, previousValue, previousMetadata, true, ctx, this);
            }
            contextEntry.setValue(newValue);
            Metadatas.updateMetadata(contextEntry, this.metadata);
            contextEntry.setChanged(true);
        }
        return previousValues;
    }

    public Map<Object, Object> getMap() {
        return this.map;
    }

    public void setMap(Map<Object, Object> map) {
        this.map = map;
    }

    public final PutMapCommand withMap(Map<Object, Object> map) {
        this.setMap(map);
        return this;
    }

    @Override
    public byte getCommandId() {
        return 9;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallMap(this.map, (ObjectOutput)output);
        output.writeObject(this.metadata);
        output.writeBoolean(this.isForwarded);
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
        CommandInvocationId.writeTo(output, this.commandInvocationId);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.map = MarshallUtil.unmarshallMap((ObjectInput)input, LinkedHashMap::new);
        this.metadata = (Metadata)input.readObject();
        this.isForwarded = input.readBoolean();
        this.setFlagsBitSet(input.readLong());
        this.commandInvocationId = CommandInvocationId.readFrom(input);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutMapCommand that = (PutMapCommand)o;
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return this.map != null ? this.map.equals(that.map) : that.map == null;
    }

    public int hashCode() {
        int result = this.map != null ? this.map.hashCode() : 0;
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PutMapCommand{map={");
        if (!this.map.isEmpty()) {
            Iterator<Map.Entry<Object, Object>> it = this.map.entrySet().iterator();
            int i = 0;
            while (true) {
                Map.Entry<Object, Object> e = it.next();
                sb.append(Util.toStr((Object)e.getKey())).append('=').append(Util.toStr((Object)e.getValue()));
                if (!it.hasNext()) break;
                if (i > 100) {
                    sb.append(" ...");
                    break;
                }
                sb.append(", ");
                ++i;
            }
        }
        sb.append("}, flags=").append(this.printFlags()).append(", metadata=").append(this.metadata).append(", isForwarded=").append(this.isForwarded).append("}");
        return sb.toString();
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return ValueMatcher.MATCH_ALWAYS;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
    }

    @Override
    public Collection<?> getAffectedKeys() {
        return this.map.keySet();
    }

    @Override
    public void fail() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isReturnValueExpected() {
        return !this.hasAnyFlag(FlagBitSets.IGNORE_RETURN_VALUES);
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return this.hasAnyFlag(FlagBitSets.IGNORE_RETURN_VALUES) ? VisitableCommand.LoadType.DONT_LOAD : VisitableCommand.LoadType.PRIMARY;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public boolean isForwarded() {
        return this.isForwarded;
    }

    public void setForwarded(boolean forwarded) {
        this.isForwarded = forwarded;
    }
}

