/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.cache.TransactionConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.container.offheap.OffHeapDataContainer;
import org.infinispan.container.offheap.UnpooledOffHeapMemoryAllocator;
import org.infinispan.eviction.EvictionType;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.logging.Log;

public class MemoryConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<MemoryConfiguration> {
    private static final Log log = (Log)LogFactory.getLog(MemoryConfigurationBuilder.class, Log.class);
    private AttributeSet attributes = MemoryConfiguration.attributeDefinitionSet();

    MemoryConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public MemoryConfigurationBuilder storageType(StorageType storageType) {
        this.attributes.attribute(MemoryConfiguration.STORAGE_TYPE).set((Object)storageType);
        return this;
    }

    public StorageType storageType() {
        return (StorageType)((Object)this.attributes.attribute(MemoryConfiguration.STORAGE_TYPE).get());
    }

    public MemoryConfigurationBuilder size(long size) {
        this.attributes.attribute(MemoryConfiguration.SIZE).set((Object)size);
        return this;
    }

    public long size() {
        return (Long)this.attributes.attribute(MemoryConfiguration.SIZE).get();
    }

    public MemoryConfigurationBuilder evictionType(EvictionType type) {
        this.attributes.attribute(MemoryConfiguration.EVICTION_TYPE).set((Object)type);
        return this;
    }

    public EvictionType evictionType() {
        return (EvictionType)((Object)this.attributes.attribute(MemoryConfiguration.EVICTION_TYPE).get());
    }

    public MemoryConfigurationBuilder addressCount(int addressCount) {
        this.attributes.attribute(MemoryConfiguration.ADDRESS_COUNT).set((Object)addressCount);
        return this;
    }

    public int addressCount() {
        return (Integer)this.attributes.attribute(MemoryConfiguration.ADDRESS_COUNT).get();
    }

    public void validate() {
        StorageType type = (StorageType)((Object)this.attributes.attribute(MemoryConfiguration.STORAGE_TYPE).get());
        if (type != StorageType.OBJECT && this.getBuilder().compatibility().isEnabled()) {
            throw log.compatibilityModeOnlyCompatibleWithObjectStorage(type);
        }
        long size = (Long)this.attributes.attribute(MemoryConfiguration.SIZE).get();
        if (size > 0L) {
            EvictionType evictionType = (EvictionType)((Object)this.attributes.attribute(MemoryConfiguration.EVICTION_TYPE).get());
            if (evictionType.isExceptionBased()) {
                TransactionConfigurationBuilder transactionConfiguration = this.getBuilder().transaction();
                TransactionMode transactionMode = transactionConfiguration.transactionMode();
                if (transactionMode == null || !transactionMode.isTransactional() || transactionConfiguration.useSynchronization() || transactionConfiguration.use1PcForAutoCommitTransactions()) {
                    throw new UnsupportedOperationException();
                }
            } else if (evictionType.isMemoryBased()) {
                switch (type) {
                    case OBJECT: {
                        throw log.offHeapMemoryEvictionNotSupportedWithObject();
                    }
                    case OFF_HEAP: {
                        int addressCount = (Integer)this.attributes.attribute(MemoryConfiguration.ADDRESS_COUNT).get();
                        long actualAddressCount = OffHeapDataContainer.getActualAddressCount(addressCount << 3);
                        actualAddressCount = UnpooledOffHeapMemoryAllocator.estimateSizeOverhead(actualAddressCount);
                        if (size >= actualAddressCount) break;
                        throw log.offHeapMemoryEvictionSizeNotLargeEnoughForAddresses(size, actualAddressCount, addressCount);
                    }
                }
            }
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    public MemoryConfiguration create() {
        return new MemoryConfiguration(this.attributes.protect());
    }

    public MemoryConfigurationBuilder read(MemoryConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "DataContainerConfigurationBuilder [attributes=" + this.attributes + "]";
    }
}

