/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.commons.util.EntrySizeCalculator;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.KeyValueMetadataSizeCalculator;
import org.infinispan.container.entries.CacheEntrySizeCalculator;
import org.infinispan.container.entries.PrimitiveEntrySizeCalculator;
import org.infinispan.container.offheap.OffHeapEntryFactory;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.marshall.core.WrappedByteArraySizeCalculator;

@DefaultFactoryFor(classes={KeyValueMetadataSizeCalculator.class})
public class SizeCalculatorFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public <T> T construct(Class<T> componentType) {
        MemoryConfiguration memory = this.configuration.memory();
        if (memory.evictionType().isMemoryBased()) {
            StorageType type = memory.storageType();
            switch (type) {
                case BINARY: {
                    return componentType.cast(CacheEntrySingleton.INSTANCE);
                }
                case OFF_HEAP: {
                    return componentType.cast(this.componentRegistry.getComponent(OffHeapEntryFactory.class));
                }
            }
            throw new UnsupportedOperationException();
        }
        return componentType.cast((k, v, m) -> 1L);
    }

    static class CacheEntrySingleton {
        static final CacheEntrySizeCalculator INSTANCE = new CacheEntrySizeCalculator(new WrappedByteArraySizeCalculator((EntrySizeCalculator<?, ?>)new PrimitiveEntrySizeCalculator()));

        CacheEntrySingleton() {
        }
    }
}

