/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories.components;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.PostStart;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.components.ManageableComponentMetadata;

public class ComponentMetadata
implements Serializable {
    private static final InjectFieldMetadata[] EMPTY_INJECT_FIELDS = new InjectFieldMetadata[0];
    public static final InjectMetadata[] EMPTY_INJECT_METHODS = new InjectMetadata[0];
    public static final PrioritizedMethodMetadata[] EMPTY_PRIORITIZED_METHODS = new PrioritizedMethodMetadata[0];
    private String name;
    private transient Map<String, String> dependencies;
    private InjectFieldMetadata[] injectFields;
    private InjectMetadata[] injectMetadata;
    private PrioritizedMethodMetadata[] startMethods;
    private PrioritizedMethodMetadata[] postStartMethods;
    private PrioritizedMethodMetadata[] stopMethods;
    private boolean globalScope = false;
    private boolean survivesRestarts = false;
    private transient Class<?> clazz;

    ComponentMetadata() {
        this.globalScope = false;
        this.survivesRestarts = true;
    }

    public ComponentMetadata(Class<?> component, List<Field> injectFields, List<Method> injectMethods, List<Method> startMethods, List<Method> postStartMethods, List<Method> stopMethods, boolean global, boolean survivesRestarts) {
        int deps;
        Annotation s;
        int i;
        this.clazz = component;
        this.name = component.getName();
        this.globalScope = global;
        this.survivesRestarts = survivesRestarts;
        if (startMethods != null && !startMethods.isEmpty()) {
            this.startMethods = new PrioritizedMethodMetadata[startMethods.size()];
            i = 0;
            for (Method m : startMethods) {
                s = m.getAnnotation(Start.class);
                this.startMethods[i++] = new PrioritizedMethodMetadata(m.getName(), s.priority());
            }
        }
        if (postStartMethods != null && !postStartMethods.isEmpty()) {
            this.postStartMethods = new PrioritizedMethodMetadata[postStartMethods.size()];
            i = 0;
            for (Method m : postStartMethods) {
                s = m.getAnnotation(PostStart.class);
                this.postStartMethods[i++] = new PrioritizedMethodMetadata(m.getName(), s.priority());
            }
        }
        if (stopMethods != null && !stopMethods.isEmpty()) {
            this.stopMethods = new PrioritizedMethodMetadata[stopMethods.size()];
            i = 0;
            for (Method m : stopMethods) {
                s = m.getAnnotation(Stop.class);
                this.stopMethods[i++] = new PrioritizedMethodMetadata(m.getName(), s.priority());
            }
        }
        if ((deps = (injectFields == null ? 0 : injectFields.size()) + (injectMethods == null ? 0 : injectMethods.size())) > 0) {
            this.dependencies = new HashMap<String, String>(deps * 2);
        }
        if (injectFields != null && !injectFields.isEmpty()) {
            this.injectFields = new InjectFieldMetadata[injectFields.size()];
            int j = 0;
            for (Field f : injectFields) {
                ComponentName[] cn = (ComponentName[])f.getAnnotationsByType(ComponentName.class);
                String componentType = f.getType().getName();
                String componentName = null;
                if (cn.length > 1) {
                    throw new IllegalStateException("Only one name expected");
                }
                if (cn.length == 1) {
                    componentName = cn[0].value();
                }
                if (componentName == null) {
                    this.dependencies.put(componentType, componentType);
                } else {
                    this.dependencies.put(componentName, componentType);
                }
                this.injectFields[j++] = new InjectFieldMetadata(f.getDeclaringClass().getName(), f.getName(), componentType, componentName);
            }
        }
        if (injectMethods != null && !injectMethods.isEmpty()) {
            this.injectMetadata = new InjectMetadata[injectMethods.size()];
            int j = 0;
            for (Method m : injectMethods) {
                InjectMetadata injectMetadata = new InjectMetadata(m.getName());
                Class<?>[] parameterTypes = m.getParameterTypes();
                String[] params = new String[parameterTypes.length];
                String[] paramNames = new String[parameterTypes.length];
                Annotation[][] annotations = m.getParameterAnnotations();
                for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
                    String parameterType;
                    String componentName = this.findComponentName(annotations, i2);
                    params[i2] = parameterType = parameterTypes[i2].getName();
                    if (componentName == null) {
                        this.dependencies.put(parameterType, parameterType);
                        continue;
                    }
                    paramNames[i2] = componentName;
                    this.dependencies.put(componentName, parameterType);
                }
                injectMetadata.parameters = params;
                injectMetadata.parameterNames = paramNames;
                this.injectMetadata[j++] = injectMetadata;
            }
        }
    }

    private String findComponentName(Annotation[][] annotations, int position) {
        Annotation[] paramAnnotations;
        if (annotations != null && annotations.length > position && (paramAnnotations = annotations[position]) != null) {
            for (Annotation a : paramAnnotations) {
                if (!(a instanceof ComponentName)) continue;
                return ((ComponentName)a).value();
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getDependencies() {
        return this.dependencies;
    }

    public InjectFieldMetadata[] getInjectFields() {
        return this.injectFields == null ? EMPTY_INJECT_FIELDS : this.injectFields;
    }

    public InjectMetadata[] getInjectMethods() {
        if (this.injectMetadata == null) {
            return EMPTY_INJECT_METHODS;
        }
        return this.injectMetadata;
    }

    public PrioritizedMethodMetadata[] getStartMethods() {
        if (this.startMethods == null) {
            return EMPTY_PRIORITIZED_METHODS;
        }
        return this.startMethods;
    }

    public PrioritizedMethodMetadata[] getPostStartMethods() {
        if (this.postStartMethods == null) {
            return EMPTY_PRIORITIZED_METHODS;
        }
        return this.postStartMethods;
    }

    public PrioritizedMethodMetadata[] getStopMethods() {
        if (this.stopMethods == null) {
            return EMPTY_PRIORITIZED_METHODS;
        }
        return this.stopMethods;
    }

    public boolean isGlobalScope() {
        return this.globalScope;
    }

    public boolean isSurvivesRestarts() {
        return this.survivesRestarts;
    }

    public boolean isManageable() {
        return false;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public ManageableComponentMetadata toManageableComponentMetadata() {
        throw new UnsupportedOperationException("This component is not manageable!");
    }

    public String toString() {
        return "ComponentMetadata{name='" + this.name + '\'' + ", dependencies=" + this.dependencies + ", injectMetadata=" + Arrays.toString(this.injectMetadata) + ", startMethods=" + Arrays.toString(this.startMethods) + ", postStartMethods=" + Arrays.toString(this.postStartMethods) + ", stopMethods=" + Arrays.toString(this.stopMethods) + ", globalScope=" + this.globalScope + ", survivesRestarts=" + this.survivesRestarts + '}';
    }

    public class InjectFieldMetadata
    implements Serializable {
        private static final long serialVersionUID = 7523698423843422884L;
        private final String fieldClassName;
        private final String fieldName;
        private final String componentName;
        private final String componentType;
        private transient Field field;
        private transient Class<?> componentClass;

        public InjectFieldMetadata(String fieldClassName, String fieldName, String componentType, String componentName) {
            this.fieldClassName = fieldClassName;
            this.fieldName = fieldName;
            this.componentName = componentName;
            this.componentType = componentType;
        }

        public Field getField() {
            return this.field;
        }

        public void setField(Field field) {
            this.field = field;
        }

        public String getFieldClassName() {
            return this.fieldClassName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Class<?> getComponentClass() {
            return this.componentClass;
        }

        public void setComponentClass(Class<?> componentClass) {
            this.componentClass = componentClass;
        }

        public String getComponentType() {
            return this.componentType;
        }

        public String getComponentName() {
            return this.componentName;
        }
    }

    public static class InjectMetadata
    implements Serializable {
        private static final long serialVersionUID = 4848856551345751894L;
        String methodName;
        transient Method method;
        String[] parameters;
        transient Class<?>[] parameterClasses;
        String[] parameterNames;

        private InjectMetadata(String methodName) {
            this.methodName = methodName;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String[] getParameters() {
            return this.parameters;
        }

        public String getParameterName(int subscript) {
            String name = this.parameterNames == null ? null : this.parameterNames[subscript];
            return name == null ? this.parameters[subscript] : name;
        }

        public boolean isParameterNameSet(int subscript) {
            return this.parameterNames != null && this.parameterNames[subscript] != null;
        }

        public synchronized Method getMethod() {
            return this.method;
        }

        public synchronized void setMethod(Method method) {
            this.method = method;
        }

        public synchronized Class<?>[] getParameterClasses() {
            return this.parameterClasses;
        }

        public synchronized void setParameterClasses(Class<?>[] parameterClasses) {
            this.parameterClasses = parameterClasses;
        }

        public String toString() {
            return this.methodName + "(" + String.join((CharSequence)", ", this.parameters) + ")";
        }
    }

    public static class PrioritizedMethodMetadata
    implements Serializable {
        String methodName;
        transient Method method;
        int priority;

        public PrioritizedMethodMetadata(String methodName, int priority) {
            this.methodName = methodName;
            this.priority = priority;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Method getMethod() {
            return this.method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }

        public int getPriority() {
            return this.priority;
        }

        public String toString() {
            return this.method.getName() + "(priority=" + this.priority + ")";
        }
    }
}

