/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.offheap.OffHeapMemoryAllocator;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.impl.JmxStatsCommandInterceptor;
import org.infinispan.jmx.annotations.DisplayType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.jmx.annotations.Units;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.StripedCounters;

@MBean(objectName="Statistics", description="General statistics such as timings, hit/miss ratio, etc.")
public class CacheMgmtInterceptor
extends JmxStatsCommandInterceptor {
    @Inject
    private AdvancedCache cache;
    @Inject
    private DataContainer dataContainer;
    @Inject
    private TimeService timeService;
    @Inject
    private OffHeapMemoryAllocator allocator;
    private final AtomicLong startNanoseconds = new AtomicLong(0L);
    private volatile AtomicLong resetNanoseconds = new AtomicLong(0L);
    private StripedCounters<StripeB> counters = new StripedCounters<StripeB>(() -> new StripeC());

    @Start
    public void start() {
        this.startNanoseconds.set(this.timeService.time());
        this.resetNanoseconds.set(this.startNanoseconds.get());
    }

    @Override
    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        if (!this.getStatisticsEnabled(command)) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> this.counters.increment(StripeB.evictionsFieldUpdater, this.counters.stripeForCurrentThread()));
    }

    @Override
    public final Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.visitDataReadCommand(ctx, command);
    }

    @Override
    public final Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.visitDataReadCommand(ctx, command);
    }

    private Object visitDataReadCommand(InvocationContext ctx, AbstractDataCommand command) throws Throwable {
        boolean statisticsEnabled = this.getStatisticsEnabled(command);
        if (!statisticsEnabled || !ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        long start = this.timeService.time();
        return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> {
            StripeB stripe = this.counters.stripeForCurrentThread();
            long intervalNanoseconds = this.timeService.timeDuration(start, TimeUnit.NANOSECONDS);
            if (rv == null) {
                this.counters.add(StripeB.missTimesFieldUpdater, stripe, intervalNanoseconds);
                this.counters.increment(StripeB.missesFieldUpdater, stripe);
            } else {
                this.counters.add(StripeB.hitTimesFieldUpdater, stripe, intervalNanoseconds);
                this.counters.increment(StripeB.hitsFieldUpdater, stripe);
            }
        });
    }

    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        boolean statisticsEnabled = this.getStatisticsEnabled(command);
        if (!statisticsEnabled || !ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        long start = this.timeService.time();
        return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> {
            long intervalNanoseconds = this.timeService.timeDuration(start, TimeUnit.NANOSECONDS);
            int requests = ((GetAllCommand)rCommand).getKeys().size();
            int hitCount = 0;
            for (Map.Entry entry : ((Map)rv).entrySet()) {
                if (entry.getValue() == null) continue;
                ++hitCount;
            }
            int missCount = requests - hitCount;
            StripeB stripe = this.counters.stripeForCurrentThread();
            if (hitCount > 0) {
                this.counters.add(StripeB.hitsFieldUpdater, stripe, hitCount);
                this.counters.add(StripeB.hitTimesFieldUpdater, stripe, intervalNanoseconds * (long)hitCount / (long)requests);
            }
            if (missCount > 0) {
                this.counters.add(StripeB.missesFieldUpdater, stripe, missCount);
                this.counters.add(StripeB.missTimesFieldUpdater, stripe, intervalNanoseconds * (long)missCount / (long)requests);
            }
        });
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        boolean statisticsEnabled = this.getStatisticsEnabled(command);
        if (!statisticsEnabled || !ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        long start = this.timeService.time();
        return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> {
            long intervalNanoseconds = this.timeService.timeDuration(start, TimeUnit.NANOSECONDS);
            Map<Object, Object> data = ((PutMapCommand)rCommand).getMap();
            if (data != null && !data.isEmpty()) {
                StripeB stripe = this.counters.stripeForCurrentThread();
                this.counters.add(StripeB.storeTimesFieldUpdater, stripe, intervalNanoseconds);
                this.counters.add(StripeB.storesFieldUpdater, stripe, data.size());
            }
        });
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.updateStoreStatistics(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.updateStoreStatistics(ctx, command);
    }

    @Override
    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) throws Throwable {
        boolean statisticsEnabled = this.getStatisticsEnabled(command);
        if (!statisticsEnabled || !ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        long start = this.timeService.time();
        return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> {
            if (rv == null && command.isSuccessful()) {
                this.increaseRemoveMisses();
            } else if (command.isSuccessful()) {
                long intervalMilliseconds = this.timeService.timeDuration(start, TimeUnit.MILLISECONDS);
                StripeB stripe = this.counters.stripeForCurrentThread();
                this.counters.add(StripeB.storeTimesFieldUpdater, stripe, intervalMilliseconds);
                this.counters.increment(StripeB.storesFieldUpdater, stripe);
            }
        });
    }

    @Override
    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) throws Throwable {
        return this.updateStoreStatistics(ctx, command);
    }

    private Object updateStoreStatistics(InvocationContext ctx, WriteCommand command) throws Throwable {
        boolean statisticsEnabled = this.getStatisticsEnabled(command);
        if (!statisticsEnabled || !ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        long start = this.timeService.time();
        return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> {
            if (command.isSuccessful()) {
                long intervalNanoseconds = this.timeService.timeDuration(start, TimeUnit.NANOSECONDS);
                StripeB stripe = this.counters.stripeForCurrentThread();
                this.counters.add(StripeB.storeTimesFieldUpdater, stripe, intervalNanoseconds);
                this.counters.increment(StripeB.storesFieldUpdater, stripe);
            }
        });
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        boolean statisticsEnabled = this.getStatisticsEnabled(command);
        if (!statisticsEnabled || !ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        long start = this.timeService.time();
        return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> {
            RemoveCommand removeCommand = (RemoveCommand)rCommand;
            if (removeCommand.isConditional()) {
                if (removeCommand.isSuccessful()) {
                    this.increaseRemoveHits(start);
                } else {
                    this.increaseRemoveMisses();
                }
            } else if (rv == null) {
                this.increaseRemoveMisses();
            } else {
                this.increaseRemoveHits(start);
            }
        });
    }

    private void increaseRemoveHits(long start) {
        long intervalNanoseconds = this.timeService.timeDuration(start, TimeUnit.NANOSECONDS);
        StripeB stripe = this.counters.stripeForCurrentThread();
        this.counters.add(StripeB.removeTimesFieldUpdater, stripe, intervalNanoseconds);
        this.counters.increment(StripeB.removeHitsFieldUpdater, stripe);
    }

    private void increaseRemoveMisses() {
        this.counters.increment(StripeB.removeMissesFieldUpdater, this.counters.stripeForCurrentThread());
    }

    @ManagedAttribute(description="Number of cache attribute hits", displayName="Number of cache hits", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getHits() {
        return this.counters.get(StripeB.hitsFieldUpdater);
    }

    @ManagedAttribute(description="Number of cache attribute misses", displayName="Number of cache misses", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getMisses() {
        return this.counters.get(StripeB.missesFieldUpdater);
    }

    @ManagedAttribute(description="Number of cache removal hits", displayName="Number of cache removal hits", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getRemoveHits() {
        return this.counters.get(StripeB.removeHitsFieldUpdater);
    }

    @ManagedAttribute(description="Number of cache removals where keys were not found", displayName="Number of cache removal misses", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getRemoveMisses() {
        return this.counters.get(StripeB.removeMissesFieldUpdater);
    }

    @ManagedAttribute(description="number of cache attribute put operations", displayName="Number of cache puts", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getStores() {
        return this.counters.get(StripeB.storesFieldUpdater);
    }

    @ManagedAttribute(description="Number of cache eviction operations", displayName="Number of cache evictions", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getEvictions() {
        return this.counters.get(StripeB.evictionsFieldUpdater);
    }

    @ManagedAttribute(description="Percentage hit/(hit+miss) ratio for the cache", displayName="Hit ratio", units=Units.PERCENTAGE, displayType=DisplayType.SUMMARY)
    public double getHitRatio() {
        long hitsL = this.counters.get(StripeB.hitsFieldUpdater);
        double total = hitsL + this.counters.get(StripeB.missesFieldUpdater);
        if (total <= 0.0) {
            return 0.0;
        }
        return (double)hitsL / total;
    }

    @ManagedAttribute(description="read/writes ratio for the cache", displayName="Read/write ratio", units=Units.PERCENTAGE, displayType=DisplayType.SUMMARY)
    public double getReadWriteRatio() {
        long sum = this.counters.get(StripeB.storesFieldUpdater);
        if (sum == 0L) {
            return 0.0;
        }
        return (double)(this.counters.get(StripeB.hitsFieldUpdater) + this.counters.get(StripeB.missesFieldUpdater)) / (double)sum;
    }

    @ManagedAttribute(description="Average number of nanoseconds for a read operation on the cache", displayName="Average read time", units=Units.NANOSECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageReadTime() {
        long total = this.counters.get(StripeB.hitsFieldUpdater) + this.counters.get(StripeB.missesFieldUpdater);
        if (total == 0L) {
            return 0L;
        }
        return (this.counters.get(StripeB.hitTimesFieldUpdater) + this.counters.get(StripeB.missTimesFieldUpdater)) / total;
    }

    @ManagedAttribute(description="Average number of nanoseconds for a write operation in the cache", displayName="Average write time", units=Units.NANOSECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageWriteTime() {
        long sum = this.counters.get(StripeB.storesFieldUpdater);
        if (sum == 0L) {
            return 0L;
        }
        return this.counters.get(StripeB.storeTimesFieldUpdater) / sum;
    }

    @ManagedAttribute(description="Average number of nanoseconds for a remove operation in the cache", displayName="Average remove time", units=Units.NANOSECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageRemoveTime() {
        long removes = this.getRemoveHits();
        if (removes == 0L) {
            return 0L;
        }
        return this.counters.get(StripeB.removeTimesFieldUpdater) / removes;
    }

    @ManagedAttribute(description="Number of entries in the cache including passivated entries", displayName="Number of current cache entries", displayType=DisplayType.SUMMARY)
    public int getNumberOfEntries() {
        return this.cache.withFlags(Flag.CACHE_MODE_LOCAL).size();
    }

    @ManagedAttribute(description="Number of entries currently in-memory excluding expired entries", displayName="Number of in-memory cache entries", displayType=DisplayType.SUMMARY)
    public int getNumberOfEntriesInMemory() {
        return this.dataContainer.size();
    }

    @ManagedAttribute(description="Amount of memory in bytes allocated in off-heap", displayName="Off-Heap Memory Used", displayType=DisplayType.SUMMARY)
    public long getOffHeapMemoryUsed() {
        return this.allocator.getAllocatedAmount();
    }

    @ManagedAttribute(description="Amount of nodes required to guarantee data consistency", displayName="Required Minimum Nodes", displayType=DisplayType.SUMMARY)
    public int getRequiredMinimumNumberOfNodes() {
        return CacheMgmtInterceptor.calculateRequiredMinimumNumberOfNodes(this.cache);
    }

    public static int calculateRequiredMinimumNumberOfNodes(AdvancedCache<?, ?> cache) {
        int evictionRestrictedNodes;
        Configuration config = cache.getCacheConfiguration();
        ClusteringConfiguration clusteringConfiguration = config.clustering();
        CacheMode mode = clusteringConfiguration.cacheMode();
        if (mode.isReplicated() || !mode.isClustered()) {
            return 1;
        }
        LocalizedCacheTopology cacheTopology = cache.getDistributionManager().getCacheTopology();
        if (mode.isInvalidation()) {
            return cacheTopology.getMembers().size();
        }
        int numMembers = cacheTopology.getMembers().size();
        int numOwners = mode.isScattered() ? 2 : clusteringConfiguration.hash().numOwners();
        int minNodes = numMembers - numOwners + 1;
        long maxSize = config.memory().size();
        if (maxSize > 0L) {
            DataContainer<?, ?> dataContainer = cache.getDataContainer();
            long totalData = dataContainer.evictionSize() * (long)numOwners;
            long capacity = dataContainer.capacity();
            evictionRestrictedNodes = (int)(totalData / capacity) + (totalData % capacity != 0L ? 1 : 0);
        } else {
            evictionRestrictedNodes = 1;
        }
        return Math.max(evictionRestrictedNodes, minNodes);
    }

    @ManagedAttribute(description="Number of seconds since cache started", displayName="Seconds since cache started", units=Units.SECONDS, measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getTimeSinceStart() {
        return this.timeService.timeDuration(this.startNanoseconds.get(), TimeUnit.SECONDS);
    }

    @ManagedAttribute(description="Number of seconds since cache started", displayName="Seconds since cache started", units=Units.SECONDS, measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    @Deprecated
    public long getElapsedTime() {
        return this.getTimeSinceStart();
    }

    @ManagedAttribute(description="Number of seconds since the cache statistics were last reset", displayName="Seconds since cache statistics were reset", units=Units.SECONDS, displayType=DisplayType.SUMMARY)
    public long getTimeSinceReset() {
        return this.timeService.timeDuration(this.resetNanoseconds.get(), TimeUnit.SECONDS);
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset Statistics (Statistics)")
    public void resetStatistics() {
        this.counters.reset(StripeB.hitsFieldUpdater);
        this.counters.reset(StripeB.missesFieldUpdater);
        this.counters.reset(StripeB.storesFieldUpdater);
        this.counters.reset(StripeB.evictionsFieldUpdater);
        this.counters.reset(StripeB.hitTimesFieldUpdater);
        this.counters.reset(StripeB.missTimesFieldUpdater);
        this.counters.reset(StripeB.storeTimesFieldUpdater);
        this.counters.reset(StripeB.removeHitsFieldUpdater);
        this.counters.reset(StripeB.removeTimesFieldUpdater);
        this.counters.reset(StripeB.removeMissesFieldUpdater);
        this.resetNanoseconds.set(this.timeService.time());
    }

    private boolean getStatisticsEnabled(FlagAffectedCommand cmd) {
        return super.getStatisticsEnabled() && !cmd.hasAnyFlag(FlagBitSets.SKIP_STATISTICS);
    }

    public void addEvictions(long numEvictions) {
        this.counters.add(StripeB.evictionsFieldUpdater, this.counters.stripeForCurrentThread(), numEvictions);
    }

    private static class StripeC
    extends StripeB {
        private long slack1;
        private long slack2;
        private long slack3;
        private long slack4;
        private long slack5;
        private long slack6;
        private long slack7;
        private long slack8;

        private StripeC() {
        }
    }

    private static class StripeB
    extends StripeA {
        static final AtomicLongFieldUpdater<StripeB> hitTimesFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "hitTimes");
        static final AtomicLongFieldUpdater<StripeB> missTimesFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "missTimes");
        static final AtomicLongFieldUpdater<StripeB> storeTimesFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "storeTimes");
        static final AtomicLongFieldUpdater<StripeB> removeHitsFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "removeHits");
        static final AtomicLongFieldUpdater<StripeB> removeMissesFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "removeMisses");
        static final AtomicLongFieldUpdater<StripeB> storesFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "stores");
        static final AtomicLongFieldUpdater<StripeB> evictionsFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "evictions");
        static final AtomicLongFieldUpdater<StripeB> missesFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "misses");
        static final AtomicLongFieldUpdater<StripeB> hitsFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "hits");
        static final AtomicLongFieldUpdater<StripeB> removeTimesFieldUpdater = AtomicLongFieldUpdater.newUpdater(StripeB.class, "removeTimes");
        private volatile long hits = 0L;
        private volatile long hitTimes = 0L;
        private volatile long misses = 0L;
        private volatile long missTimes = 0L;
        private volatile long stores = 0L;
        private volatile long storeTimes = 0L;
        private volatile long evictions = 0L;
        private volatile long removeHits = 0L;
        private volatile long removeMisses = 0L;
        private volatile long removeTimes = 0L;

        private StripeB() {
        }
    }

    private static class StripeA {
        private long slack1;
        private long slack2;
        private long slack3;
        private long slack4;
        private long slack5;
        private long slack6;
        private long slack7;
        private long slack8;

        private StripeA() {
        }
    }
}

