/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.locking.AbstractLockingInterceptor;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.util.concurrent.locks.PendingLockManager;
import org.infinispan.util.logging.Log;

public abstract class AbstractTxLockingInterceptor
extends AbstractLockingInterceptor {
    protected final boolean trace = this.getLog().isTraceEnabled();
    @Inject
    protected RpcManager rpcManager;
    @Inject
    private PartitionHandlingManager partitionHandlingManager;
    @Inject
    private PendingLockManager pendingLockManager;

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        return this.invokeNextAndFinally(ctx, command, this.unlockAllReturnHandler);
    }

    @Override
    protected Object handleReadManyCommand(InvocationContext ctx, FlagAffectedCommand command, Collection<?> keys) throws Throwable {
        if (ctx.isInTxScope()) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextAndFinally(ctx, command, this.unlockAllReturnHandler);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> {
            if (t instanceof OutdatedTopologyException) {
                throw t;
            }
            this.releaseLockOnTxCompletion((TxInvocationContext)rCtx);
        });
    }

    protected final boolean lockOrRegisterBackupLock(TxInvocationContext<?> ctx, Object key, long lockTimeout) throws InterruptedException {
        switch (this.cdl.getCacheTopology().getDistribution(key).writeOwnership()) {
            case PRIMARY: {
                if (this.trace) {
                    this.getLog().tracef("Acquiring locks on %s.", Util.toStr((Object)key));
                }
                this.checkPendingAndLockKey(ctx, key, lockTimeout);
                return true;
            }
            case BACKUP: {
                if (this.trace) {
                    this.getLog().tracef("Acquiring backup locks on %s.", key);
                }
                ((AbstractCacheTransaction)ctx.getCacheTransaction()).addBackupLockForKey(key);
                return false;
            }
        }
        return false;
    }

    protected final Collection<Object> lockAllOrRegisterBackupLock(TxInvocationContext<?> ctx, Collection<?> keys, long lockTimeout) throws InterruptedException {
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        Log log = this.getLog();
        ArrayList<Object> keysToLock = new ArrayList<Object>(keys.size());
        LocalizedCacheTopology cacheTopology = this.cdl.getCacheTopology();
        for (Object key : keys) {
            switch (cacheTopology.getDistribution(key).writeOwnership()) {
                case PRIMARY: {
                    if (this.trace) {
                        log.tracef("Acquiring locks on %s.", Util.toStr(key));
                    }
                    keysToLock.add(key);
                    break;
                }
                case BACKUP: {
                    if (this.trace) {
                        log.tracef("Acquiring backup locks on %s.", Util.toStr(key));
                    }
                    ((AbstractCacheTransaction)ctx.getCacheTransaction()).addBackupLockForKey(key);
                    break;
                }
            }
        }
        if (keysToLock.isEmpty()) {
            return Collections.emptyList();
        }
        this.checkPendingAndLockAllKeys(ctx, keysToLock, lockTimeout);
        return keysToLock;
    }

    private void checkPendingAndLockKey(InvocationContext ctx, Object key, long lockTimeout) throws InterruptedException {
        long remaining = this.pendingLockManager.awaitPendingTransactionsForKey((TxInvocationContext)ctx, key, lockTimeout, TimeUnit.MILLISECONDS);
        this.lockAndRecord(ctx, key, remaining);
    }

    private void checkPendingAndLockAllKeys(InvocationContext ctx, Collection<Object> keys, long lockTimeout) throws InterruptedException {
        long remaining = this.pendingLockManager.awaitPendingTransactionsForAllKeys((TxInvocationContext)ctx, keys, lockTimeout, TimeUnit.MILLISECONDS);
        this.lockAllAndRecord(ctx, keys, remaining);
    }

    protected void releaseLockOnTxCompletion(TxInvocationContext ctx) {
        boolean shouldReleaseLocks;
        boolean bl = shouldReleaseLocks = ctx.isOriginLocal() && !this.partitionHandlingManager.isTransactionPartiallyCommitted(ctx.getGlobalTransaction());
        if (shouldReleaseLocks) {
            this.lockManager.unlockAll(ctx);
        }
    }
}

