/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.Collection;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.InvocationSuccessFunction;
import org.infinispan.interceptors.locking.AbstractTxLockingInterceptor;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PessimisticLockingInterceptor
extends AbstractTxLockingInterceptor {
    private static final Log log = LogFactory.getLog(PessimisticLockingInterceptor.class);
    public static final boolean trace = log.isTraceEnabled();
    private final InvocationSuccessFunction localLockCommandWork = (rCtx, rCommand, rv) -> this.localLockCommandWork(rCtx, (LockControlCommand)rCommand);
    @Inject
    private CommandsFactory cf;
    @Inject
    private StateTransferManager stateTransferManager;

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected final Object visitDataReadCommand(InvocationContext ctx, DataCommand command) throws Throwable {
        if (!this.readNeedsLock(ctx, command)) {
            return this.invokeNext(ctx, command);
        }
        if (!this.readNeedsLock(ctx, command)) {
            return this.invokeNext(ctx, command);
        }
        Object key = command.getKey();
        if (!this.needRemoteLocks(ctx, key, (FlagAffectedCommand)command)) {
            this.acquireLocalLock(ctx, command);
            return this.invokeNext(ctx, command);
        }
        TxInvocationContext txContext = (TxInvocationContext)ctx;
        LockControlCommand lcc = this.cf.buildLockControlCommand(key, command.getFlagsBitSet(), txContext.getGlobalTransaction());
        lcc.setTopologyId(command.getTopologyId());
        return this.invokeNextThenApply(ctx, lcc, (rCtx, rCommand, rv) -> {
            this.acquireLocalLock(rCtx, command);
            return this.invokeNext(rCtx, command);
        });
    }

    private boolean readNeedsLock(InvocationContext ctx, FlagAffectedCommand command) {
        return ctx.isInTxScope() && command.hasAnyFlag(FlagBitSets.FORCE_WRITE_LOCK) && !this.hasSkipLocking(command);
    }

    private void acquireLocalLock(InvocationContext ctx, DataCommand command) throws InterruptedException {
        if (trace) {
            log.tracef("acquireLocalLock", new Object[0]);
        }
        TxInvocationContext txContext = (TxInvocationContext)ctx;
        Object key = command.getKey();
        this.lockOrRegisterBackupLock(txContext, key, this.getLockTimeoutMillis(command));
        txContext.addAffectedKey(key);
    }

    @Override
    protected Object handleReadManyCommand(InvocationContext ctx, FlagAffectedCommand command, Collection<?> keys) throws Throwable {
        Object maybeStage;
        if (!this.readNeedsLock(ctx, command)) {
            maybeStage = this.invokeNext(ctx, command);
        } else if (!this.needRemoteLocks(ctx, keys, command)) {
            this.acquireLocalLocks(ctx, command, keys);
            maybeStage = this.invokeNext(ctx, command);
        } else {
            TxInvocationContext txContext = (TxInvocationContext)ctx;
            LockControlCommand lcc = this.cf.buildLockControlCommand(keys, command.getFlagsBitSet(), txContext.getGlobalTransaction());
            maybeStage = this.invokeNextThenApply(ctx, lcc, (rCtx, rLockCommand, rv) -> {
                this.acquireLocalLocks(rCtx, command, keys);
                return this.invokeNext(rCtx, command);
            });
        }
        return maybeStage;
    }

    private void acquireLocalLocks(InvocationContext ctx, FlagAffectedCommand command, Collection<?> keys) throws InterruptedException {
        this.lockAllOrRegisterBackupLock((TxInvocationContext)ctx, keys, this.getLockTimeoutMillis(command));
        ((TxInvocationContext)ctx).addAllAffectedKeys(keys);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!command.isOnePhaseCommit()) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextThenAccept(ctx, command, (rCtx, rCommand, rv) -> this.releaseLockOnTxCompletion((TxInvocationContext)rCtx));
    }

    @Override
    protected <K> Object handleWriteManyCommand(InvocationContext ctx, WriteCommand command, Collection<K> keys, boolean forwarded) throws Throwable {
        Object maybeStage;
        if (this.hasSkipLocking(command)) {
            maybeStage = this.invokeNext(ctx, command);
        } else if (!this.needRemoteLocks(ctx, keys, (FlagAffectedCommand)command)) {
            this.acquireLocalLocks(ctx, command, keys);
            maybeStage = this.invokeNext(ctx, command);
        } else {
            TxInvocationContext txContext = (TxInvocationContext)ctx;
            LockControlCommand lcc = this.cf.buildLockControlCommand(keys, command.getFlagsBitSet(), txContext.getGlobalTransaction());
            lcc.setTopologyId(command.getTopologyId());
            maybeStage = this.invokeNextThenApply(ctx, lcc, (rCtx, rCommand, rv) -> {
                this.acquireLocalLocks(rCtx, command, keys);
                return this.invokeNext(rCtx, command);
            });
        }
        return maybeStage;
    }

    @Override
    protected Object visitDataWriteCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        Object maybeStage;
        Object key = command.getKey();
        if (this.hasSkipLocking(command)) {
            if (ctx.isInTxScope()) {
                ((TxInvocationContext)ctx).addAffectedKey(key);
            }
            maybeStage = this.invokeNext(ctx, command);
        } else if (!this.needRemoteLocks(ctx, key, (FlagAffectedCommand)command)) {
            this.acquireLocalLock(ctx, command);
            maybeStage = this.invokeNext(ctx, command);
        } else {
            TxInvocationContext txContext = (TxInvocationContext)ctx;
            LockControlCommand lcc = this.cf.buildLockControlCommand(key, command.getFlagsBitSet(), txContext.getGlobalTransaction());
            lcc.setTopologyId(command.getTopologyId());
            return this.invokeNextThenApply(ctx, lcc, (rCtx, rCommand, rv) -> {
                this.acquireLocalLock(rCtx, command);
                return this.invokeNext(rCtx, command);
            });
        }
        return maybeStage;
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        if (!ctx.isInTxScope()) {
            throw new IllegalStateException("Locks should only be acquired within the scope of a transaction!");
        }
        boolean skipLocking = this.hasSkipLocking(command);
        if (skipLocking) {
            return false;
        }
        if (ctx.isOriginLocal()) {
            boolean needBackupLocks;
            boolean isSingleKeyAndLocal = !command.multipleKeys() && this.cdl.getCacheTopology().getDistribution(command.getSingleKey()).isPrimary();
            boolean bl = needBackupLocks = !isSingleKeyAndLocal || this.isStateTransferInProgress();
            if (needBackupLocks && !command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL)) {
                LocalTransaction localTx = (LocalTransaction)ctx.getCacheTransaction();
                if (localTx.getAffectedKeys().containsAll(command.getKeys())) {
                    if (trace) {
                        log.tracef("Already own locks on keys: %s, skipping remote call", command.getKeys());
                    }
                    return true;
                }
            } else {
                if (trace) {
                    log.tracef("Single key %s and local, skipping remote call", command.getSingleKey());
                }
                return this.localLockCommandWork(ctx, command);
            }
        }
        return this.invokeNextThenApply(ctx, command, this.localLockCommandWork);
    }

    private boolean localLockCommandWork(InvocationContext ctx, LockControlCommand command) throws InterruptedException {
        TxInvocationContext txInvocationContext = (TxInvocationContext)ctx;
        if (ctx.isOriginLocal()) {
            txInvocationContext.addAllAffectedKeys(command.getKeys());
        }
        if (command.isUnlock()) {
            if (ctx.isOriginLocal()) {
                throw new AssertionError((Object)"There's no advancedCache.unlock so this must have originated remotely.");
            }
            return false;
        }
        this.lockAllOrRegisterBackupLock(txInvocationContext, command.getKeys(), this.getLockTimeoutMillis(command));
        return true;
    }

    private boolean needRemoteLocks(InvocationContext ctx, Collection<?> keys, FlagAffectedCommand command) throws Throwable {
        boolean needBackupLocks = ctx.isOriginLocal() && (!this.isLockOwner(keys) || this.isStateTransferInProgress());
        boolean needRemoteLock = false;
        if (needBackupLocks && !command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL)) {
            TxInvocationContext txContext = (TxInvocationContext)ctx;
            LocalTransaction localTransaction = (LocalTransaction)txContext.getCacheTransaction();
            boolean bl = needRemoteLock = !localTransaction.getAffectedKeys().containsAll(keys);
            if (!needRemoteLock && trace) {
                log.tracef("We already have lock for keys %s, skip remote lock acquisition", keys);
            }
        }
        return needRemoteLock;
    }

    private boolean needRemoteLocks(InvocationContext ctx, Object key, FlagAffectedCommand command) throws Throwable {
        boolean needBackupLocks = ctx.isOriginLocal() && (!this.isLockOwner(key) || this.isStateTransferInProgress());
        boolean needRemoteLock = false;
        if (needBackupLocks && !command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL)) {
            TxInvocationContext txContext = (TxInvocationContext)ctx;
            LocalTransaction localTransaction = (LocalTransaction)txContext.getCacheTransaction();
            boolean bl = needRemoteLock = !localTransaction.getAffectedKeys().contains(key);
            if (!needRemoteLock && trace) {
                log.tracef("We already have lock for key %s, skip remote lock acquisition", key);
            }
        } else if (trace) {
            log.tracef("Don't need backup locks %s", needBackupLocks);
        }
        return needRemoteLock;
    }

    private boolean isLockOwner(Collection<?> keys) {
        for (Object key : keys) {
            if (this.isLockOwner(key)) continue;
            return false;
        }
        return true;
    }

    private boolean isStateTransferInProgress() {
        return this.stateTransferManager != null && this.stateTransferManager.isStateTransferInProgress();
    }
}

