/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.AvailabilityStrategy;
import org.infinispan.partitionhandling.impl.AvailabilityStrategyContext;
import org.infinispan.partitionhandling.impl.LostDataCheck;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheStatusResponse;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.PersistentUUIDManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.util.logging.events.EventLogCategory;
import org.infinispan.util.logging.events.EventLogManager;
import org.infinispan.util.logging.events.Messages;

public class PreferAvailabilityStrategy
implements AvailabilityStrategy {
    public static final Comparator<CacheStatusResponse> RESPONSE_COMPARATOR = (s1, s2) -> {
        int compareAddress;
        if (s2 == null) {
            return -1;
        }
        CacheTopology t1 = s1.getCacheTopology();
        CacheTopology t2 = s2.getCacheTopology();
        int topologyId = Integer.compare(t1.getTopologyId(), t2.getTopologyId());
        if (topologyId != 0) {
            return topologyId;
        }
        int rebalanceId = Integer.compare(t1.getRebalanceId(), t2.getRebalanceId());
        if (rebalanceId != 0) {
            return topologyId;
        }
        List<Address> m1 = t1.getMembers();
        List<Address> m2 = t2.getMembers();
        if (m1.size() == m2.size() && (compareAddress = m1.get(0).compareTo(m2.get(0))) == 0) {
            return Integer.compare(t1.hashCode(), t2.hashCode());
        }
        return m1.size() > m2.size() ? -1 : 1;
    };
    private static final Log log = LogFactory.getLog(PreferAvailabilityStrategy.class);
    private final EventLogManager eventLogManager;
    private final PersistentUUIDManager persistentUUIDManager;
    private final LostDataCheck lostDataCheck;

    public PreferAvailabilityStrategy(EventLogManager eventLogManager, PersistentUUIDManager persistentUUIDManager, LostDataCheck lostDataCheck) {
        this.eventLogManager = eventLogManager;
        this.persistentUUIDManager = persistentUUIDManager;
        this.lostDataCheck = lostDataCheck;
    }

    @Override
    public void onJoin(AvailabilityStrategyContext context, Address joiner) {
        context.queueRebalance(context.getExpectedMembers());
    }

    @Override
    public void onGracefulLeave(AvailabilityStrategyContext context, Address leaver) {
        CacheTopology currentTopology = context.getCurrentTopology();
        ArrayList<Address> newMembers = new ArrayList<Address>(currentTopology.getMembers());
        newMembers.remove(leaver);
        if (newMembers.isEmpty()) {
            log.debugf("The last node of cache %s left", context.getCacheName());
            context.updateCurrentTopology(newMembers);
            return;
        }
        if (context.getStableTopology() != null && this.lostDataCheck.test(context.getStableTopology().getCurrentCH(), newMembers)) {
            this.eventLogManager.getEventLogger().context(context.getCacheName()).warn(EventLogCategory.CLUSTER, Messages.MESSAGES.lostDataBecauseOfGracefulLeaver(leaver));
        }
        context.updateCurrentTopology(newMembers);
        context.queueRebalance(newMembers);
    }

    @Override
    public void onClusterViewChange(AvailabilityStrategyContext context, List<Address> clusterMembers) {
        CacheTopology currentTopology = context.getCurrentTopology();
        ArrayList<Address> newMembers = new ArrayList<Address>(currentTopology.getMembers());
        if (!newMembers.retainAll(clusterMembers)) {
            log.tracef("Cache %s did not lose any members, skipping rebalance", context.getCacheName());
            return;
        }
        this.checkForLostData(context, newMembers);
        context.updateCurrentTopology(newMembers);
        context.queueRebalance(newMembers);
    }

    protected void checkForLostData(AvailabilityStrategyContext context, List<Address> newMembers) {
        CacheTopology stableTopology = context.getStableTopology();
        List<Address> stableMembers = stableTopology.getMembers();
        ArrayList<Address> lostMembers = new ArrayList<Address>(stableMembers);
        lostMembers.removeAll(newMembers);
        if (this.lostDataCheck.test(stableTopology.getCurrentCH(), newMembers)) {
            this.eventLogManager.getEventLogger().context(context.getCacheName()).fatal(EventLogCategory.CLUSTER, Messages.MESSAGES.lostDataBecauseOfAbruptLeavers(lostMembers));
        } else if ((double)lostMembers.size() >= Math.ceil((double)stableMembers.size() / 2.0)) {
            this.eventLogManager.getEventLogger().context(context.getCacheName()).warn(EventLogCategory.CLUSTER, Messages.MESSAGES.minorityPartition(newMembers, lostMembers, stableMembers));
        }
    }

    @Override
    public void onPartitionMerge(AvailabilityStrategyContext context, Map<Address, CacheStatusResponse> statusResponseMap) {
        List statusResponses = statusResponseMap.values().stream().sorted(RESPONSE_COMPARATOR).collect(Collectors.toList());
        List<Address> newMembers = context.getExpectedMembers();
        CacheTopology maxStableTopology = null;
        ArrayList<Address> maxStableActualMembers = null;
        for (CacheStatusResponse response : statusResponses) {
            CacheTopology stableTopology = response.getStableTopology();
            if (stableTopology == null) continue;
            ArrayList<Address> actualMembers = new ArrayList<Address>(stableTopology.getMembers());
            actualMembers.retainAll(newMembers);
            if (maxStableTopology != null && maxStableActualMembers.size() >= actualMembers.size()) continue;
            maxStableTopology = stableTopology;
            maxStableActualMembers = actualMembers;
        }
        CacheTopology maxTopology = null;
        ArrayList<Address> maxActualMembers = null;
        for (CacheStatusResponse response : statusResponses) {
            CacheTopology topology;
            CacheTopology stableTopology = response.getStableTopology();
            if (!Objects.equals(stableTopology, maxStableTopology) || (topology = response.getCacheTopology()) == null) continue;
            ArrayList<Address> actualMembers = new ArrayList<Address>(topology.getMembers());
            if (maxTopology != null && maxActualMembers.size() >= actualMembers.size()) continue;
            maxTopology = topology;
            maxActualMembers = actualMembers;
        }
        if (maxTopology == null) {
            log.debugf("No current topology, recovered only joiners for cache %s", context.getCacheName());
        }
        int maxTopologyId = 0;
        int maxRebalanceId = 0;
        for (CacheStatusResponse response : statusResponses) {
            CacheTopology topology = response.getCacheTopology();
            if (topology == null) continue;
            if (maxTopologyId < topology.getTopologyId()) {
                maxTopologyId = topology.getTopologyId();
            }
            if (maxRebalanceId >= topology.getRebalanceId()) continue;
            maxRebalanceId = topology.getRebalanceId();
        }
        CacheTopology mergedTopology = null;
        boolean resolveConflicts = false;
        if (maxTopology != null) {
            HashSet<Address> possibleOwners = new HashSet<Address>();
            HashSet<ConsistentHash> distinctHashes = new HashSet<ConsistentHash>();
            for (CacheStatusResponse response : statusResponses) {
                ConsistentHash hash;
                CacheTopology cacheTopology = response.getCacheTopology();
                if (cacheTopology == null || (hash = cacheTopology.getCurrentCH()) == null || hash.getMembers().isEmpty()) continue;
                possibleOwners.addAll(hash.getMembers());
                distinctHashes.add(hash);
            }
            boolean bl = resolveConflicts = context.resolveConflictsOnMerge() && !possibleOwners.isEmpty() && possibleOwners.size() > 1 && !maxTopology.getMembers().containsAll(possibleOwners);
            if (resolveConflicts) {
                ArrayList<Address> members = new ArrayList<Address>(possibleOwners);
                ConsistentHash conflictHash = context.calculateConflictHash(distinctHashes);
                mergedTopology = new CacheTopology(maxTopologyId + 1, maxRebalanceId + 1, maxTopology.getCurrentCH(), conflictHash, conflictHash, CacheTopology.Phase.CONFLICT_RESOLUTION, members, this.persistentUUIDManager.mapAddresses(members));
            } else {
                mergedTopology = new CacheTopology(maxTopologyId + 1, maxRebalanceId + 1, maxTopology.getCurrentCH(), null, CacheTopology.Phase.NO_REBALANCE, maxTopology.getActualMembers(), this.persistentUUIDManager.mapAddresses(maxTopology.getActualMembers()));
            }
        }
        context.updateTopologiesAfterMerge(mergedTopology, maxStableTopology, null, resolveConflicts);
        List<Address> survivingMembers = new ArrayList<Address>(newMembers);
        if (mergedTopology != null && survivingMembers.retainAll(mergedTopology.getMembers())) {
            this.checkForLostData(context, survivingMembers);
        }
        if (survivingMembers.isEmpty()) {
            survivingMembers = newMembers;
        }
        context.updateCurrentTopology(survivingMembers);
        context.queueRebalance(newMembers);
    }

    @Override
    public void onRebalanceEnd(AvailabilityStrategyContext context) {
    }

    @Override
    public void onManualAvailabilityChange(AvailabilityStrategyContext context, AvailabilityMode newAvailabilityMode) {
    }
}

