/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.CacheStream;
import org.infinispan.cache.impl.AbstractDelegatingAdvancedCache;
import org.infinispan.cache.impl.CacheImpl;
import org.infinispan.cache.impl.EncoderEntryMapper;
import org.infinispan.cache.impl.EncoderKeyMapper;
import org.infinispan.cache.impl.EncoderValueMapper;
import org.infinispan.commands.read.AbstractCloseableIteratorCollection;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.dataconversion.IdentityWrapper;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableIteratorMapper;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.CloseableSpliteratorMapper;
import org.infinispan.compat.BiFunctionMapper;
import org.infinispan.compat.FunctionMapper;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ForwardingCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.ListenerHolder;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.util.AbstractDelegatingCacheStream;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class EncoderCache<K, V>
extends AbstractDelegatingAdvancedCache<K, V> {
    private static Log log = LogFactory.getLog(EncoderCache.class);
    @Inject
    private InternalEntryFactory entryFactory;
    @Inject
    private ComponentRegistry componentRegistry;
    private final DataConversion keyDataConversion;
    private final DataConversion valueDataConversion;
    private final Function<V, V> decodedValueForRead = this::valueFromStorage;

    public EncoderCache(AdvancedCache<K, V> cache, final DataConversion keyDataConversion, final DataConversion valueDataConversion) {
        super(cache, new AbstractDelegatingAdvancedCache.AdvancedCacheWrapper<K, V>(){

            @Override
            public AdvancedCache<K, V> wrap(AdvancedCache<K, V> cache) {
                throw new UnsupportedOperationException();
            }

            @Override
            public AdvancedCache<K, V> wrap(AdvancedCache<K, V> self, AdvancedCache<K, V> newDelegate) {
                EncoderCache newCache = new EncoderCache(newDelegate, keyDataConversion, valueDataConversion);
                ((EncoderCache)self).initState(newCache, (EncoderCache)self);
                return newCache;
            }
        });
        this.keyDataConversion = keyDataConversion;
        this.valueDataConversion = valueDataConversion;
    }

    private Set<?> encodeKeysForWrite(Set<?> keys) {
        if (this.needsEncoding(keys)) {
            return keys.stream().map(this::keyToStorage).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return keys;
    }

    private boolean needsEncoding(Collection<?> keys) {
        return keys.stream().anyMatch(k -> !k.equals(this.keyToStorage(k)));
    }

    private Collection<? extends K> encodeKeysForWrite(Collection<? extends K> keys) {
        if (this.needsEncoding(keys)) {
            return keys.stream().map(this::keyToStorage).collect(Collectors.toCollection(ArrayList::new));
        }
        return keys;
    }

    public K keyToStorage(Object key) {
        return (K)this.keyDataConversion.toStorage(key);
    }

    public V valueToStorage(Object value) {
        return (V)this.valueDataConversion.toStorage(value);
    }

    public K keyFromStorage(Object key) {
        return (K)this.keyDataConversion.fromStorage(key);
    }

    public V valueFromStorage(Object value) {
        return (V)this.valueDataConversion.fromStorage(value);
    }

    @Inject
    public void wireRealCache() {
        this.componentRegistry.wireDependencies(this.keyDataConversion);
        this.componentRegistry.wireDependencies(this.valueDataConversion);
        this.componentRegistry.wireDependencies(this.cache);
    }

    private Map<K, V> encodeMapForWrite(Map<? extends K, ? extends V> map) {
        HashMap newMap = new HashMap(map.size());
        map.forEach((k, v) -> newMap.put(this.keyToStorage(k), this.valueToStorage(v)));
        return newMap;
    }

    private Map<K, V> decodeMapForRead(Map<? extends K, ? extends V> map) {
        LinkedHashMap newMap = new LinkedHashMap(map.size());
        map.forEach((k, v) -> newMap.put(this.keyFromStorage(k), this.valueFromStorage(v)));
        return newMap;
    }

    private CacheEntry<K, V> convertEntry(K newKey, V newValue, CacheEntry<K, V> entry) {
        if (entry instanceof InternalCacheEntry) {
            return this.entryFactory.create(newKey, newValue, (InternalCacheEntry)entry);
        }
        return this.entryFactory.create(newKey, newValue, entry.getMetadata().version(), entry.getCreated(), entry.getLifespan(), entry.getLastUsed(), entry.getMaxIdle());
    }

    private BiFunction<? super K, ? super V, ? extends V> convertFunction(BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (k, v) -> this.valueToStorage(remappingFunction.apply((K)this.keyFromStorage(k), (V)this.valueFromStorage(v)));
    }

    private Map<K, CacheEntry<K, V>> decodeEntryMapForRead(Map<K, CacheEntry<K, V>> map) {
        HashMap entryMap = new HashMap(map.size());
        map.values().forEach((? super T v) -> {
            Object originalKey = v.getKey();
            K unwrappedKey = this.keyFromStorage(originalKey);
            Object originalValue = v.getValue();
            V unwrappedValue = this.valueFromStorage(originalValue);
            CacheEntry<K, V> entryToPut = unwrappedKey != originalKey || unwrappedValue != originalValue ? this.convertEntry(unwrappedKey, unwrappedValue, (CacheEntry<K, V>)v) : v;
            entryMap.put(unwrappedKey, entryToPut);
        });
        return entryMap;
    }

    @Override
    public void putForExternalRead(K key, V value) {
        super.putForExternalRead(this.keyToStorage(key), this.valueToStorage(value));
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit unit) {
        super.putForExternalRead(this.keyToStorage(key), this.valueToStorage(value), lifespan, unit);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        super.putForExternalRead(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public void evict(K key) {
        super.evict(this.keyToStorage(key));
    }

    @Override
    public V put(K key, V value, long lifespan, TimeUnit unit) {
        V ret = super.put(this.keyToStorage(key), this.valueToStorage(value), lifespan, unit);
        return this.valueFromStorage(ret);
    }

    @Override
    public DataConversion getKeyDataConversion() {
        return this.keyDataConversion;
    }

    @Override
    public DataConversion getValueDataConversion() {
        return this.valueDataConversion;
    }

    @Override
    protected void set(K key, V value) {
        super.set(this.keyToStorage(key), this.valueToStorage(value));
    }

    @Override
    public V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        V v = super.putIfAbsent(this.keyToStorage(key), this.valueToStorage(value), lifespan, unit);
        return this.valueFromStorage(v);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        super.putAll(this.encodeMapForWrite(map), lifespan, unit);
    }

    @Override
    public V replace(K key, V value, long lifespan, TimeUnit unit) {
        V ret = super.replace(this.keyToStorage(key), this.valueToStorage(value), lifespan, unit);
        return this.valueFromStorage(ret);
    }

    @Override
    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        return super.replace(this.keyToStorage(key), this.valueToStorage(oldValue), this.valueToStorage(value), lifespan, unit);
    }

    @Override
    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        V ret = super.put(this.keyToStorage(key), this.valueToStorage(value), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return this.valueFromStorage(ret);
    }

    @Override
    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        V ret = super.putIfAbsent(this.keyToStorage(key), this.valueToStorage(value), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return this.valueFromStorage(ret);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        super.putAll(this.encodeMapForWrite(map), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        V ret = super.replace(this.keyToStorage(key), this.valueToStorage(value), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        return this.valueFromStorage(ret);
    }

    @Override
    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return super.replace(this.keyToStorage(key), this.valueToStorage(oldValue), this.valueToStorage(value), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        super.replaceAll(this.convertFunction(function));
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value) {
        return super.putAsync(this.keyToStorage(key), this.valueToStorage(value)).thenApply(this.decodedValueForRead);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit unit) {
        return super.putAsync(this.keyToStorage(key), this.valueToStorage(value), lifespan, unit).thenApply(this.decodedValueForRead);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return super.putAsync(this.keyToStorage(key), this.valueToStorage(value), lifespan, lifespanUnit, maxIdle, maxIdleUnit).thenApply(this.decodedValueForRead);
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        return super.putAllAsync(this.encodeMapForWrite(data));
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit unit) {
        return super.putAllAsync(this.encodeMapForWrite(data), lifespan, unit);
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return super.putAllAsync(this.encodeMapForWrite(data), lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> map, Metadata metadata) {
        return super.putAllAsync(this.encodeMapForWrite(map), metadata);
    }

    @Override
    public CompletableFuture<V> putIfAbsentAsync(K key, V value) {
        return super.putIfAbsentAsync(this.keyToStorage(key), this.valueToStorage(value)).thenApply(this.decodedValueForRead);
    }

    @Override
    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit unit) {
        return super.putIfAbsentAsync(this.keyToStorage(key), this.valueToStorage(value), lifespan, unit).thenApply(this.decodedValueForRead);
    }

    @Override
    public boolean lock(K ... keys) {
        Object[] encoded = Arrays.stream(keys).map(this::keyToStorage).toArray();
        return super.lock(encoded);
    }

    @Override
    public boolean lock(Collection<? extends K> keys) {
        return super.lock(this.encodeKeysForWrite(keys));
    }

    @Override
    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return super.putIfAbsentAsync(this.keyToStorage(key), this.valueToStorage(value), lifespan, lifespanUnit, maxIdle, maxIdleUnit).thenApply(this.decodedValueForRead);
    }

    @Override
    public CompletableFuture<V> putIfAbsentAsync(K key, V value, Metadata metadata) {
        return super.putIfAbsentAsync(this.keyToStorage(key), this.valueToStorage(value), metadata).thenApply(this.decodedValueForRead);
    }

    @Override
    public CompletableFuture<V> removeAsync(Object key) {
        return super.removeAsync(this.keyToStorage(key)).thenApply(this.decodedValueForRead);
    }

    @Override
    public CompletableFuture<Boolean> removeAsync(Object key, Object value) {
        return super.removeAsync(this.keyToStorage(key), this.valueToStorage(value));
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value) {
        return super.replaceAsync(this.keyToStorage(key), this.valueToStorage(value)).thenApply(this.decodedValueForRead);
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit unit) {
        return super.replaceAsync(this.keyToStorage(key), this.valueToStorage(value), lifespan, unit).thenApply(this.decodedValueForRead);
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value, Metadata metadata) {
        return super.replaceAsync(this.keyToStorage(key), this.valueToStorage(value), metadata).thenApply(this.decodedValueForRead);
    }

    @Override
    public Map<K, V> getAll(Set<?> keys) {
        Map ret = super.getAll(this.encodeKeysForWrite(keys));
        return this.decodeMapForRead(ret);
    }

    @Override
    public CompletableFuture<Map<K, V>> getAllAsync(Set<?> keys) {
        return super.getAllAsync(this.encodeKeysForWrite(keys)).thenApply(this::decodeMapForRead);
    }

    @Override
    public CacheEntry<K, V> getCacheEntry(Object key) {
        K keyToStorage = this.keyToStorage(key);
        CacheEntry returned = super.getCacheEntry(keyToStorage);
        return this.unwrapCacheEntry(key, keyToStorage, returned);
    }

    @Override
    public CompletableFuture<CacheEntry<K, V>> getCacheEntryAsync(Object key) {
        K keyToStorage = this.keyToStorage(key);
        return super.getCacheEntryAsync(keyToStorage).thenApply(returned -> this.unwrapCacheEntry(key, keyToStorage, (CacheEntry<K, V>)returned));
    }

    private CacheEntry<K, V> unwrapCacheEntry(Object key, K keyToStorage, CacheEntry<K, V> returned) {
        if (returned != null) {
            V originalValue = returned.getValue();
            V valueFromStorage = this.valueFromStorage(originalValue);
            if (keyToStorage != key || valueFromStorage != originalValue) {
                return this.convertEntry(key, valueFromStorage, returned);
            }
        }
        return returned;
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return super.replaceAsync(this.keyToStorage(key), this.valueToStorage(value), lifespan, lifespanUnit, maxIdle, maxIdleUnit).thenApply(this.decodedValueForRead);
    }

    @Override
    public Map<K, CacheEntry<K, V>> getAllCacheEntries(Set<?> keys) {
        Map returned = super.getAllCacheEntries(this.encodeKeysForWrite(keys));
        return this.decodeEntryMapForRead(returned);
    }

    @Override
    public Map<K, V> getGroup(String groupName) {
        Map ret = super.getGroup(groupName);
        return this.decodeMapForRead(ret);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return super.replaceAsync(this.keyToStorage(key), this.valueToStorage(oldValue), this.valueToStorage(newValue));
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        return super.replaceAsync(this.keyToStorage(key), this.valueToStorage(oldValue), this.valueToStorage(newValue), lifespan, unit);
    }

    @Override
    public V put(K key, V value, Metadata metadata) {
        V ret = super.put(this.keyToStorage(key), this.valueToStorage(value), metadata);
        return this.valueFromStorage(ret);
    }

    @Override
    public V replace(K key, V value, Metadata metadata) {
        V ret = super.replace(this.keyToStorage(key), this.valueToStorage(value), metadata);
        return this.valueFromStorage(ret);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return super.replaceAsync(this.keyToStorage(key), this.valueToStorage(oldValue), this.valueToStorage(newValue), lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public boolean replace(K key, V oldValue, V value, Metadata metadata) {
        return super.replace(this.keyToStorage(key), this.valueToStorage(oldValue), this.valueToStorage(value), metadata);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, Metadata metadata) {
        return super.replaceAsync(this.keyToStorage(key), this.valueToStorage(oldValue), this.valueToStorage(newValue), metadata);
    }

    @Override
    public V putIfAbsent(K key, V value, Metadata metadata) {
        V ret = super.putIfAbsent(this.keyToStorage(key), this.valueToStorage(value), metadata);
        return this.valueFromStorage(ret);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, Metadata metadata) {
        return super.putAsync(this.keyToStorage(key), this.valueToStorage(value), metadata).thenApply(this.decodedValueForRead);
    }

    @Override
    public void putForExternalRead(K key, V value, Metadata metadata) {
        super.putForExternalRead(this.keyToStorage(key), this.valueToStorage(value), metadata);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, Metadata metadata) {
        super.putAll(this.encodeMapForWrite(map), metadata);
    }

    @Override
    public CacheSet<CacheEntry<K, V>> cacheEntrySet() {
        return new EncoderEntrySet(this, super.cacheEntrySet());
    }

    @Override
    public void removeExpired(K key, V value, Long lifespan) {
        super.removeExpired(this.keyToStorage(key), this.valueToStorage(value), lifespan);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        V ret = super.putIfAbsent(this.keyToStorage(key), this.valueToStorage(value));
        return this.valueFromStorage(ret);
    }

    private void lookupEncoderWrapper() {
        ComponentStatus status = this.cache.getAdvancedCache().getComponentRegistry().getStatus();
        if (!status.equals((Object)ComponentStatus.STOPPING) && !status.equals((Object)ComponentStatus.TERMINATED)) {
            this.componentRegistry.wireDependencies(this.keyDataConversion);
            this.componentRegistry.wireDependencies(this.valueDataConversion);
        }
    }

    private void initState(EncoderCache<K, V> encoderCache, EncoderCache<K, V> template) {
        encoderCache.entryFactory = template.entryFactory;
        encoderCache.componentRegistry = template.componentRegistry;
    }

    @Override
    public AdvancedCache<K, V> withEncoding(Class<? extends Encoder> keyEncoderClass, Class<? extends Encoder> valueEncoderClass) {
        this.checkSubclass(keyEncoderClass, Encoder.class);
        this.checkSubclass(valueEncoderClass, Encoder.class);
        if (this.allIdentity(keyEncoderClass, valueEncoderClass, this.keyDataConversion.getWrapperClass(), this.valueDataConversion.getWrapperClass())) {
            return this.cache;
        }
        DataConversion newKeyDataConversion = this.keyDataConversion.withEncoding(keyEncoderClass);
        DataConversion newValueDataConversion = this.valueDataConversion.withEncoding(valueEncoderClass);
        EncoderCache<K, V> encoderCache = new EncoderCache<K, V>(this.cache, newKeyDataConversion, newValueDataConversion);
        this.initState(encoderCache, this);
        super.lookupEncoderWrapper();
        return encoderCache;
    }

    @Override
    public AdvancedCache<K, V> withEncoding(Class<? extends Encoder> encoderClass) {
        this.checkSubclass(encoderClass, Encoder.class);
        if (this.allIdentity(encoderClass, encoderClass, this.keyDataConversion.getWrapperClass(), this.valueDataConversion.getWrapperClass())) {
            return this.cache;
        }
        DataConversion newKeyDataConversion = this.keyDataConversion.withEncoding(encoderClass);
        DataConversion newValueDataConversion = this.valueDataConversion.withEncoding(encoderClass);
        EncoderCache<K, V> encoderCache = new EncoderCache<K, V>(this.cache, newKeyDataConversion, newValueDataConversion);
        this.initState(encoderCache, this);
        super.lookupEncoderWrapper();
        return encoderCache;
    }

    @Override
    public AdvancedCache<K, V> withKeyEncoding(Class<? extends Encoder> encoderClass) {
        this.checkSubclass(encoderClass, Encoder.class);
        if (this.allIdentity(encoderClass, this.valueDataConversion.getEncoderClass(), this.keyDataConversion.getWrapperClass(), this.valueDataConversion.getWrapperClass())) {
            return this.cache;
        }
        DataConversion newKeyDataConversion = this.keyDataConversion.withEncoding(encoderClass);
        EncoderCache<K, V> encoderCache = new EncoderCache<K, V>(this.cache, newKeyDataConversion, this.valueDataConversion);
        this.initState(encoderCache, this);
        super.lookupEncoderWrapper();
        return encoderCache;
    }

    private void checkSubclass(Class<?> configured, Class<?> required) {
        if (!required.isAssignableFrom(configured)) {
            throw log.invalidEncodingClass(configured, required);
        }
    }

    private boolean allIdentity(Class<? extends Encoder> keyEncoderClass, Class<? extends Encoder> valueEncoderClass, Class<? extends Wrapper> keyWrapperClass, Class<? extends Wrapper> valueWrapperClass) {
        return keyEncoderClass == IdentityEncoder.class && valueEncoderClass == IdentityEncoder.class && keyWrapperClass == IdentityWrapper.class && valueWrapperClass == IdentityWrapper.class;
    }

    @Override
    public AdvancedCache<K, V> withWrapping(Class<? extends Wrapper> keyWrapperClass, Class<? extends Wrapper> valueWrapperClass) {
        this.checkSubclass(keyWrapperClass, Wrapper.class);
        this.checkSubclass(valueWrapperClass, Wrapper.class);
        if (this.allIdentity(this.keyDataConversion.getEncoderClass(), this.valueDataConversion.getEncoderClass(), keyWrapperClass, valueWrapperClass)) {
            return this.cache;
        }
        DataConversion newKeyDataConversion = this.keyDataConversion.withWrapping(keyWrapperClass);
        DataConversion newValueDataConversion = this.valueDataConversion.withWrapping(valueWrapperClass);
        EncoderCache<K, V> encoderCache = new EncoderCache<K, V>(this.cache, newKeyDataConversion, newValueDataConversion);
        this.initState(encoderCache, this);
        super.lookupEncoderWrapper();
        return encoderCache;
    }

    @Override
    public AdvancedCache<K, V> withWrapping(Class<? extends Wrapper> wrapper) {
        return this.withWrapping(wrapper, wrapper);
    }

    @Override
    public AdvancedCache<K, V> withMediaType(String keyMediaType, String valueMediaType) {
        MediaType kType = MediaType.fromString((String)keyMediaType);
        MediaType vType = MediaType.fromString((String)valueMediaType);
        DataConversion newKeyDataConversion = this.keyDataConversion.withRequestMediaType(kType);
        DataConversion newValueDataConversion = this.valueDataConversion.withRequestMediaType(vType);
        EncoderCache<K, V> encoderCache = new EncoderCache<K, V>(this.cache, newKeyDataConversion, newValueDataConversion);
        this.initState(encoderCache, this);
        super.lookupEncoderWrapper();
        return encoderCache;
    }

    @Override
    public boolean remove(Object key, Object value) {
        return super.remove(this.keyToStorage(key), this.valueToStorage(value));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return super.replace(this.keyToStorage(key), this.valueToStorage(oldValue), this.valueToStorage(newValue));
    }

    @Override
    public V replace(K key, V value) {
        V ret = super.replace(this.keyToStorage(key), this.valueToStorage(value));
        return this.valueFromStorage(ret);
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(this.keyToStorage(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(this.valueToStorage(value));
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Object returned = super.compute(this.keyToStorage(key), new BiFunctionMapper(remappingFunction, this.keyDataConversion, this.valueDataConversion));
        return this.valueFromStorage(returned);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Object returned = super.computeIfPresent(this.keyToStorage(key), new BiFunctionMapper(remappingFunction, this.keyDataConversion, this.valueDataConversion));
        return this.valueFromStorage(returned);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        Object ret = super.computeIfAbsent(this.keyToStorage(key), new FunctionMapper(mappingFunction, this.keyDataConversion, this.valueDataConversion));
        return this.valueFromStorage(ret);
    }

    @Override
    public V get(Object key) {
        Object v = super.get(this.keyToStorage(key));
        return this.valueFromStorage(v);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        V returned = super.getOrDefault(this.keyToStorage(key), defaultValue);
        if (returned == defaultValue) {
            return returned;
        }
        return this.valueFromStorage(returned);
    }

    @Override
    public V put(K key, V value) {
        V ret = super.put(this.keyToStorage(key), this.valueToStorage(value));
        if (ret == null) {
            return null;
        }
        return this.valueFromStorage(ret);
    }

    @Override
    public V remove(Object key) {
        Object ret = super.remove(this.keyToStorage(key));
        return this.valueFromStorage(ret);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        super.putAll(this.encodeMapForWrite(t));
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        V returned = super.merge(this.keyToStorage(key), this.valueToStorage(value), new BiFunctionMapper(remappingFunction, this.keyDataConversion, this.valueDataConversion));
        return this.valueFromStorage(returned);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        super.forEach((k, v) -> {
            K newK = this.keyFromStorage(k);
            V newV = this.valueFromStorage(v);
            action.accept((K)newK, (V)newV);
        });
    }

    @Override
    public CacheSet<K> keySet() {
        return new EncodedKeySet(this, super.keySet());
    }

    @Override
    public CacheSet<Map.Entry<K, V>> entrySet() {
        return this.cast(new EncoderEntrySet(this, this.cast(super.cacheEntrySet())));
    }

    private <E extends Map.Entry<K, V>> CacheSet<E> cast(CacheSet set) {
        return set;
    }

    @Override
    public CacheCollection<V> values() {
        return new EncoderValuesCollection(this, super.values());
    }

    @Override
    public CompletableFuture<V> getAsync(K key) {
        return super.getAsync(this.keyToStorage(key)).thenApply(this.decodedValueForRead);
    }

    @Override
    public void addListener(Object listener) {
        ListenerHolder listenerHolder = new ListenerHolder(listener, this.keyDataConversion, this.valueDataConversion);
        Cache unwrapped = AbstractDelegatingAdvancedCache.unwrapCache(this.cache);
        if (unwrapped instanceof CacheImpl) {
            ((CacheImpl)unwrapped).addListener(listenerHolder);
        } else {
            super.addListener(listener);
        }
    }

    @Override
    public <C> void addListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
        ListenerHolder listenerHolder = new ListenerHolder(listener, this.keyDataConversion, this.valueDataConversion);
        Cache unwrapped = AbstractDelegatingAdvancedCache.unwrapCache(this.cache);
        if (unwrapped instanceof CacheImpl) {
            ((CacheImpl)unwrapped).addListener(listenerHolder, filter, converter);
        } else {
            super.addListener(listener);
        }
    }

    @Override
    public <C> void addFilteredListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        ListenerHolder listenerHolder = new ListenerHolder(listener, this.keyDataConversion, this.valueDataConversion);
        Cache unwrapped = AbstractDelegatingAdvancedCache.unwrapCache(this.cache);
        if (unwrapped instanceof CacheImpl) {
            ((CacheImpl)unwrapped).addFilteredListener(listenerHolder, filter, converter, filterAnnotations);
        } else {
            super.addFilteredListener(listener, filter, converter, filterAnnotations);
        }
    }

    public EncoderCache<K, V> withCache(AdvancedCache<K, V> otherCache) {
        EncoderCache<K, V> cache = new EncoderCache<K, V>(otherCache, this.keyDataConversion, this.valueDataConversion);
        this.initState(cache, this);
        return cache;
    }

    private class EncoderValuesCollection
    extends AbstractCloseableIteratorCollection<V, K, V>
    implements CacheCollection<V> {
        private final CacheCollection<V> actualCollection;
        final EncoderValueMapper valueMapper;

        EncoderValuesCollection(Cache<K, V> cache, CacheCollection<V> actualCollection) {
            super(cache);
            this.valueMapper = new EncoderValueMapper(EncoderCache.this.valueDataConversion);
            this.actualCollection = actualCollection;
        }

        @Override
        public CacheStream<V> stream() {
            return new EncodedCacheStream(this.actualCollection.stream().map((Function)this.valueMapper));
        }

        @Override
        public CacheStream<V> parallelStream() {
            return new EncodedCacheStream(this.actualCollection.parallelStream().map((Function)this.valueMapper));
        }

        @Override
        public CloseableIterator<V> iterator() {
            return new CloseableIteratorMapper(this.actualCollection.iterator(), EncoderCache.this::valueFromStorage);
        }

        @Override
        public CloseableSpliterator<V> spliterator() {
            return new CloseableSpliteratorMapper(this.actualCollection.spliterator(), EncoderCache.this::valueFromStorage);
        }

        @Override
        public boolean contains(Object o) {
            return this.actualCollection.contains(EncoderCache.this.valueToStorage(o));
        }

        @Override
        public boolean remove(Object o) {
            return this.actualCollection.remove(EncoderCache.this.valueToStorage(o));
        }
    }

    private class EntryWrapper<A, B>
    extends ForwardingCacheEntry<A, B> {
        private final CacheEntry<A, B> previousEntry;
        private final CacheEntry<A, B> entry;

        EntryWrapper(CacheEntry<A, B> previousEntry, CacheEntry<A, B> entry) {
            this.previousEntry = previousEntry;
            this.entry = entry;
        }

        @Override
        protected CacheEntry<A, B> delegate() {
            return this.entry;
        }

        @Override
        public B setValue(B value) {
            this.previousEntry.setValue(EncoderCache.this.valueToStorage(value));
            return super.setValue(value);
        }
    }

    private class EncoderEntrySet
    extends AbstractCloseableIteratorCollection<CacheEntry<K, V>, K, V>
    implements CacheSet<CacheEntry<K, V>> {
        private CacheSet<CacheEntry<K, V>> actualCollection;
        private EncoderEntryMapper entryMapper;

        EncoderEntrySet(Cache<K, V> cache, CacheSet<CacheEntry<K, V>> actualCollection) {
            super(cache);
            this.entryMapper = new EncoderEntryMapper(EncoderCache.this.keyDataConversion, EncoderCache.this.valueDataConversion);
            this.actualCollection = actualCollection;
        }

        @Override
        public CacheStream<CacheEntry<K, V>> stream() {
            return new EncodedCacheStream(this.actualCollection.stream().map((Function)this.entryMapper));
        }

        @Override
        public CacheStream<CacheEntry<K, V>> parallelStream() {
            return new EncodedCacheStream(this.actualCollection.parallelStream().map((Function)this.entryMapper));
        }

        @Override
        public CloseableIterator<CacheEntry<K, V>> iterator() {
            return new EncoderIterator(this.actualCollection.iterator(), EncoderCache.this.entryFactory);
        }

        @Override
        public CloseableSpliterator<CacheEntry<K, V>> spliterator() {
            return new CloseableSpliteratorMapper(this.actualCollection.spliterator(), entry -> {
                Object key = entry.getKey();
                Object keyFromStorage = EncoderCache.this.keyFromStorage(key);
                Object value = entry.getValue();
                Object valueFromStorage = EncoderCache.this.valueFromStorage(value);
                if (keyFromStorage != key || valueFromStorage != value) {
                    return EncoderCache.this.convertEntry(keyFromStorage, valueFromStorage, entry);
                }
                return entry;
            });
        }

        @Override
        public boolean contains(Object o) {
            Map.Entry entry = this.toEntry(o);
            if (entry != null) {
                return this.actualCollection.contains(entry);
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            Map.Entry entry = this.toEntry(o);
            if (entry != null) {
                return this.actualCollection.remove(entry);
            }
            return false;
        }

        Map.Entry toEntry(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                Object newKey = EncoderCache.this.keyToStorage(key);
                Object value = entry.getValue();
                Object newValue = EncoderCache.this.valueToStorage(value);
                if (key != newKey || value != newValue) {
                    if (o instanceof CacheEntry) {
                        CacheEntry returned = (CacheEntry)o;
                        return EncoderCache.this.convertEntry(newKey, newValue, returned);
                    }
                    return EncoderCache.this.entryFactory.create(newKey, newValue, (Metadata)null);
                }
                return entry;
            }
            return null;
        }
    }

    private class EncoderIterator<A, B>
    implements CloseableIterator<CacheEntry<A, B>> {
        private final CloseableIterator<CacheEntry<A, B>> iterator;
        private final InternalEntryFactory entryFactory;

        EncoderIterator(CloseableIterator<CacheEntry<A, B>> iterator, InternalEntryFactory entryFactory) {
            this.iterator = iterator;
            this.entryFactory = entryFactory;
        }

        public void close() {
            this.iterator.close();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public CacheEntry<A, B> next() {
            CacheEntry entry = (CacheEntry)this.iterator.next();
            return new EntryWrapper<A, B>(entry, this.convert(entry));
        }

        private CacheEntry<A, B> convert(CacheEntry<A, B> entry) {
            Object newKey = EncoderCache.this.keyFromStorage(entry.getKey());
            Object newValue = EncoderCache.this.valueFromStorage(entry.getValue());
            if (newKey != entry.getKey() || newValue != entry.getValue()) {
                if (entry instanceof InternalCacheEntry) {
                    return this.entryFactory.create(newKey, newValue, (InternalCacheEntry)entry);
                }
                return this.entryFactory.create(newKey, newValue, entry.getMetadata());
            }
            return entry;
        }

        public void remove() {
            this.iterator.remove();
        }
    }

    private class EncodedKeySet
    extends AbstractCloseableIteratorCollection<K, K, V>
    implements CacheSet<K> {
        private final CacheSet<K> actualCollection;
        private final EncoderKeyMapper keyMapper;

        EncodedKeySet(Cache<K, V> cache, CacheSet<K> actualCollection) {
            super(cache);
            this.keyMapper = new EncoderKeyMapper(EncoderCache.this.keyDataConversion);
            this.actualCollection = actualCollection;
        }

        @Override
        public CacheStream<K> stream() {
            return new EncodedCacheStream(this.actualCollection.stream().map((Function)this.keyMapper));
        }

        @Override
        public CacheStream<K> parallelStream() {
            return new EncodedCacheStream(this.actualCollection.parallelStream().map((Function)this.keyMapper));
        }

        @Override
        public CloseableIterator<K> iterator() {
            return new CloseableIteratorMapper(this.actualCollection.iterator(), EncoderCache.this::keyFromStorage);
        }

        @Override
        public CloseableSpliterator<K> spliterator() {
            return new CloseableSpliteratorMapper(this.actualCollection.spliterator(), EncoderCache.this::keyFromStorage);
        }

        @Override
        public boolean contains(Object o) {
            return this.actualCollection.contains(EncoderCache.this.keyToStorage(o));
        }

        @Override
        public boolean remove(Object o) {
            return this.actualCollection.remove(EncoderCache.this.keyToStorage(o));
        }
    }

    private class EncodedCacheStream<R>
    extends AbstractDelegatingCacheStream<R> {
        public EncodedCacheStream(CacheStream<R> stream) {
            super(stream);
        }

        @Override
        public AbstractDelegatingCacheStream<R> filterKeys(Set<?> keys) {
            return super.filterKeys(EncoderCache.this.encodeKeysForWrite(keys));
        }
    }
}

