/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.util.function.RemovableFunction;

public class EncoderEntryMapper<K, V>
implements RemovableFunction<CacheEntry<K, V>, CacheEntry<K, V>> {
    @Inject
    private transient InternalEntryFactory entryFactory;
    private final DataConversion keyDataConversion;
    private final DataConversion valueDataConversion;

    public EncoderEntryMapper(DataConversion keyDataConversion, DataConversion valueDataConversion) {
        this.keyDataConversion = keyDataConversion;
        this.valueDataConversion = valueDataConversion;
    }

    @Inject
    public void injectDependencies(ComponentRegistry registry) {
        registry.wireDependencies(this.keyDataConversion);
        registry.wireDependencies(this.valueDataConversion);
    }

    private Object decode(Object o, Encoder encoder) {
        if (o == null) {
            return null;
        }
        return encoder.fromStorage(o);
    }

    @Override
    public CacheEntry<K, V> apply(CacheEntry<K, V> e) {
        Object newValue;
        boolean keyFilterable = this.keyDataConversion.isStorageFormatFilterable();
        boolean valueFilterable = this.valueDataConversion.isStorageFormatFilterable();
        K key = e.getKey();
        Object unwrapped = this.keyDataConversion.getWrapper().unwrap(key);
        Object newKey = keyFilterable ? unwrapped : this.decode(unwrapped, this.keyDataConversion.getEncoder());
        V value = e.getValue();
        Object unwrappedValue = this.valueDataConversion.getWrapper().unwrap(value);
        Object object = newValue = valueFilterable ? unwrappedValue : this.decode(unwrappedValue, this.valueDataConversion.getEncoder());
        if (key != newKey || value != newValue) {
            return this.entryFactory.create(newKey, newValue, e.getMetadata().version(), e.getCreated(), e.getLifespan(), e.getLastUsed(), e.getMaxIdle());
        }
        return e;
    }

    public static class Externalizer
    implements AdvancedExternalizer<EncoderEntryMapper> {
        public Set<Class<? extends EncoderEntryMapper>> getTypeClasses() {
            return Collections.singleton(EncoderEntryMapper.class);
        }

        public Integer getId() {
            return 124;
        }

        public void writeObject(ObjectOutput output, EncoderEntryMapper object) throws IOException {
            DataConversion.writeTo(output, object.keyDataConversion);
            DataConversion.writeTo(output, object.valueDataConversion);
        }

        public EncoderEntryMapper readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new EncoderEntryMapper(DataConversion.readFrom(input), DataConversion.readFrom(input));
        }
    }
}

