/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.infinispan.commands.functional.Mutation;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.marshall.core.EncoderRegistry;

final class Mutations {
    private Mutations() {
    }

    static <K, V, R> void writeTo(ObjectOutput output, Mutation<K, V, R> mutation) throws IOException {
        BaseMutation bm = (BaseMutation)mutation;
        DataConversion.writeTo(output, bm.keyDataConversion);
        DataConversion.writeTo(output, bm.valueDataConversion);
        byte type = mutation.type();
        output.writeByte(type);
        switch (type) {
            case 0: {
                output.writeObject(((ReadWrite)mutation).f);
                break;
            }
            case 1: {
                ReadWriteWithValue rwwv = (ReadWriteWithValue)mutation;
                output.writeObject(rwwv.value);
                output.writeObject(rwwv.f);
                break;
            }
            case 2: {
                output.writeObject(((Write)mutation).f);
                break;
            }
            case 3: {
                WriteWithValue wwv = (WriteWithValue)mutation;
                output.writeObject(wwv.value);
                output.writeObject(wwv.f);
            }
        }
    }

    static <K, V> Mutation<K, V, ?> readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        DataConversion keyDataConversion = DataConversion.readFrom(input);
        DataConversion valueDataConversion = DataConversion.readFrom(input);
        switch (input.readByte()) {
            case 0: {
                return new ReadWrite(keyDataConversion, valueDataConversion, (Function)input.readObject());
            }
            case 1: {
                return new ReadWriteWithValue(keyDataConversion, valueDataConversion, input.readObject(), (BiFunction)input.readObject());
            }
            case 2: {
                return new Write(keyDataConversion, valueDataConversion, (Consumer)input.readObject());
            }
            case 3: {
                return new WriteWithValue(keyDataConversion, valueDataConversion, input.readObject(), (BiConsumer)input.readObject());
            }
        }
        throw new IllegalStateException("Unknown type of mutation, broken input?");
    }

    static class WriteWithValue<K, V>
    extends BaseMutation<K, V, Void> {
        static final byte TYPE = 3;
        private final Object value;
        private final BiConsumer<V, EntryView.WriteEntryView<V>> f;

        public WriteWithValue(DataConversion keyDataConversion, DataConversion valueDataConversion, Object value, BiConsumer<V, EntryView.WriteEntryView<V>> f) {
            super(keyDataConversion, valueDataConversion);
            this.value = value;
            this.f = f;
        }

        @Override
        public byte type() {
            return 3;
        }

        @Override
        public Void apply(EntryView.ReadWriteEntryView<K, V> view) {
            this.f.accept(this.valueDataConversion.fromStorage(this.value), view);
            return null;
        }
    }

    static class Write<K, V>
    extends BaseMutation<K, V, Void> {
        static final byte TYPE = 2;
        private final Consumer<EntryView.WriteEntryView<V>> f;

        public Write(DataConversion keyDataConversion, DataConversion valueDataConversion, Consumer<EntryView.WriteEntryView<V>> f) {
            super(keyDataConversion, valueDataConversion);
            this.f = f;
        }

        @Override
        public byte type() {
            return 2;
        }

        @Override
        public Void apply(EntryView.ReadWriteEntryView<K, V> view) {
            this.f.accept(view);
            return null;
        }
    }

    static class ReadWriteWithValue<K, V, R>
    extends BaseMutation<K, V, R> {
        static final byte TYPE = 1;
        private final Object value;
        private final BiFunction<V, EntryView.ReadWriteEntryView<K, V>, R> f;

        public ReadWriteWithValue(DataConversion keyDataConversion, DataConversion valueDataConversion, Object value, BiFunction<V, EntryView.ReadWriteEntryView<K, V>, R> f) {
            super(keyDataConversion, valueDataConversion);
            this.value = value;
            this.f = f;
        }

        @Override
        public byte type() {
            return 1;
        }

        @Override
        public R apply(EntryView.ReadWriteEntryView<K, V> view) {
            return this.f.apply(this.valueDataConversion.fromStorage(this.value), view);
        }
    }

    static class ReadWrite<K, V, R>
    extends BaseMutation<K, V, R> {
        static final byte TYPE = 0;
        private final Function<EntryView.ReadWriteEntryView<K, V>, R> f;

        public ReadWrite(DataConversion keyDataConversion, DataConversion valueDataConversion, Function<EntryView.ReadWriteEntryView<K, V>, R> f) {
            super(keyDataConversion, valueDataConversion);
            this.f = f;
        }

        @Override
        public byte type() {
            return 0;
        }

        @Override
        public R apply(EntryView.ReadWriteEntryView<K, V> view) {
            return this.f.apply(view);
        }
    }

    static abstract class BaseMutation<K, V, R>
    implements Mutation<K, V, R> {
        protected final DataConversion keyDataConversion;
        protected final DataConversion valueDataConversion;

        BaseMutation(DataConversion keyDataConversion, DataConversion valueDataConversion) {
            this.keyDataConversion = keyDataConversion;
            this.valueDataConversion = valueDataConversion;
        }

        @Override
        public DataConversion keyDataConversion() {
            return this.keyDataConversion;
        }

        @Override
        public DataConversion valueDataConversion() {
            return this.valueDataConversion;
        }

        @Override
        public void inject(ComponentRegistry registry) {
            GlobalConfiguration globalConfiguration = registry.getGlobalComponentRegistry().getGlobalConfiguration();
            EncoderRegistry encoderRegistry = registry.getComponent(EncoderRegistry.class);
            Configuration configuration = registry.getComponent(Configuration.class);
            this.keyDataConversion.injectDependencies(globalConfiguration, encoderRegistry, configuration);
            this.valueDataConversion.injectDependencies(globalConfiguration, encoderRegistry, configuration);
        }
    }
}

