/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.BiFunction;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteKeyCommand;
import org.infinispan.commands.functional.Mutation;
import org.infinispan.commands.functional.Mutations;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.Param;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.Params;
import org.infinispan.functional.impl.StatsEnvelope;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public final class ReadWriteKeyValueCommand<K, V, R>
extends AbstractWriteKeyCommand<K, V> {
    private static final Log log = LogFactory.getLog(ReadWriteKeyValueCommand.class);
    public static final byte COMMAND_ID = 51;
    private Object value;
    private BiFunction<V, EntryView.ReadWriteEntryView<K, V>, R> f;
    private Object prevValue;
    private Metadata prevMetadata;

    public ReadWriteKeyValueCommand(Object key, Object value, BiFunction<V, EntryView.ReadWriteEntryView<K, V>, R> f, CommandInvocationId id, ValueMatcher valueMatcher, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion, ComponentRegistry componentRegistry) {
        super(key, valueMatcher, id, params, keyDataConversion, valueDataConversion);
        this.value = value;
        this.f = f;
        this.init(componentRegistry);
    }

    public ReadWriteKeyValueCommand() {
    }

    @Override
    public byte getCommandId() {
        return 51;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeObject(this.value);
        output.writeObject(this.f);
        MarshallUtil.marshallEnum((Enum)this.valueMatcher, (ObjectOutput)output);
        Params.writeObject(output, this.params);
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        output.writeObject(this.prevValue);
        output.writeObject(this.prevMetadata);
        DataConversion.writeTo(output, this.keyDataConversion);
        DataConversion.writeTo(output, this.valueDataConversion);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.value = input.readObject();
        this.f = (BiFunction)input.readObject();
        this.valueMatcher = (ValueMatcher)MarshallUtil.unmarshallEnum((ObjectInput)input, ValueMatcher::valueOf);
        this.params = Params.readObject(input);
        this.setFlagsBitSet(input.readLong());
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.prevValue = input.readObject();
        this.prevMetadata = (Metadata)input.readObject();
        this.keyDataConversion = DataConversion.readFrom(input);
        this.valueDataConversion = DataConversion.readFrom(input);
    }

    @Override
    public boolean isConditional() {
        return true;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (this.valueMatcher == ValueMatcher.MATCH_NEVER) {
            this.successful = false;
            return null;
        }
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(this.key);
        if (e == null) {
            return null;
        }
        if (this.prevValue == null && !this.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            this.prevValue = e.getValue();
            this.prevMetadata = e.getMetadata();
        }
        Object oldPrevValue = e.getValue();
        CacheEntry copy = e.clone();
        Object decodedValue = this.valueDataConversion.fromStorage(this.value);
        EntryViews.AccessLoggingReadWriteView view = EntryViews.readWrite((MVCCEntry)copy, this.prevValue, this.prevMetadata, this.keyDataConversion, this.valueDataConversion);
        R ret = EntryViews.snapshot(this.f.apply(decodedValue, view));
        if (this.valueMatcher.matches(oldPrevValue, this.prevValue, copy.getValue())) {
            log.tracef("Execute read-write function on previous value %s and previous metadata %s", this.prevValue, this.prevMetadata);
            e.setValue(copy.getValue());
            e.setMetadata(copy.getMetadata());
            e.setChanged(copy.isChanged());
            e.setRemoved(copy.isRemoved());
        }
        if (!e.isChanged() && !this.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            this.successful = false;
        }
        return Param.StatisticsMode.isSkip(this.params) ? ret : StatsEnvelope.create(ret, e, this.prevValue != null, view.isRead());
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReadWriteKeyValueCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.OWNER;
    }

    @Override
    public String toString() {
        return "ReadWriteKeyValueCommand{" + "key=" + Util.toStr((Object)this.key) + ", value=" + Util.toStr((Object)this.value) + ", f=" + this.f.getClass().getName() + ", prevValue=" + Util.toStr((Object)this.prevValue) + ", prevMetadata=" + Util.toStr((Object)this.prevMetadata) + ", flags=" + this.printFlags() + ", valueMatcher=" + (Object)((Object)this.valueMatcher) + ", successful=" + this.successful + ", keyDataConversion=" + this.keyDataConversion + ", valueDataConversion=" + this.valueDataConversion + "}";
    }

    @Override
    public Mutation toMutation(Object key) {
        return new Mutations.ReadWriteWithValue<K, V, R>(this.keyDataConversion, this.valueDataConversion, this.value, this.f);
    }

    @Override
    public void init(ComponentRegistry componentRegistry) {
        componentRegistry.wireDependencies(this.keyDataConversion);
        componentRegistry.wireDependencies(this.valueDataConversion);
        if (this.f instanceof InjectableComponent) {
            ((InjectableComponent)((Object)this.f)).inject(componentRegistry);
        }
    }

    public void setPrevValueAndMetadata(Object prevValue, Metadata prevMetadata) {
        this.prevMetadata = prevMetadata;
        this.prevValue = prevValue;
    }

    public Object getValue() {
        return this.value;
    }

    public BiFunction<V, EntryView.ReadWriteEntryView<K, V>, R> getBiFunction() {
        return this.f;
    }

    public Object getPrevValue() {
        return this.prevValue;
    }

    public Metadata getPrevMetadata() {
        return this.prevMetadata;
    }
}

