/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteManyCommand;
import org.infinispan.commands.functional.Mutation;
import org.infinispan.commands.functional.Mutations;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.Params;

public final class WriteOnlyManyEntriesCommand<K, V>
extends AbstractWriteManyCommand<K, V> {
    public static final byte COMMAND_ID = 57;
    private Map<?, ?> entries;
    private BiConsumer<V, EntryView.WriteEntryView<V>> f;

    public WriteOnlyManyEntriesCommand(Map<?, ?> entries, BiConsumer<V, EntryView.WriteEntryView<V>> f, Params params, CommandInvocationId commandInvocationId, DataConversion keyDataConversion, DataConversion valueDataConversion, ComponentRegistry componentRegistry) {
        super(commandInvocationId, params, keyDataConversion, valueDataConversion);
        this.entries = entries;
        this.f = f;
        this.init(componentRegistry);
    }

    public WriteOnlyManyEntriesCommand(WriteOnlyManyEntriesCommand<K, V> command) {
        super(command);
        this.entries = command.entries;
        this.f = command.f;
        this.keyDataConversion = command.keyDataConversion;
        this.valueDataConversion = command.valueDataConversion;
    }

    public WriteOnlyManyEntriesCommand() {
    }

    public BiConsumer<V, EntryView.WriteEntryView<V>> getBiConsumer() {
        return this.f;
    }

    public Map<?, ?> getEntries() {
        return this.entries;
    }

    public void setEntries(Map<?, ?> entries) {
        this.entries = entries;
    }

    public final WriteOnlyManyEntriesCommand<K, V> withEntries(Map<?, ?> entries) {
        this.setEntries(entries);
        return this;
    }

    @Override
    public byte getCommandId() {
        return 57;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        MarshallUtil.marshallMap(this.entries, (ObjectOutput)output);
        output.writeObject(this.f);
        output.writeBoolean(this.isForwarded);
        Params.writeObject(output, this.params);
        output.writeInt(this.topologyId);
        output.writeLong(this.flags);
        DataConversion.writeTo(output, this.keyDataConversion);
        DataConversion.writeTo(output, this.valueDataConversion);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.entries = MarshallUtil.unmarshallMap((ObjectInput)input, LinkedHashMap::new);
        this.f = (BiConsumer)input.readObject();
        this.isForwarded = input.readBoolean();
        this.params = Params.readObject(input);
        this.topologyId = input.readInt();
        this.flags = input.readLong();
        this.keyDataConversion = DataConversion.readFrom(input);
        this.valueDataConversion = DataConversion.readFrom(input);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        for (Map.Entry<?, ?> entry : this.entries.entrySet()) {
            CacheEntry cacheEntry = ctx.lookupEntry(entry.getKey());
            if (cacheEntry == null) {
                throw new IllegalStateException();
            }
            Object decodedValue = this.valueDataConversion.fromStorage(entry.getValue());
            this.f.accept(decodedValue, EntryViews.writeOnly(cacheEntry, this.valueDataConversion));
        }
        return null;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public Collection<?> getAffectedKeys() {
        return this.entries.keySet();
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitWriteOnlyManyEntriesCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.DONT_LOAD;
    }

    @Override
    public boolean isWriteOnly() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WriteOnlyManyEntriesCommand{");
        sb.append("entries=").append(this.entries);
        sb.append(", f=").append(this.f.getClass().getName());
        sb.append(", isForwarded=").append(this.isForwarded);
        sb.append(", keyDataConversion=").append(this.keyDataConversion);
        sb.append(", valueDataConversion=").append(this.valueDataConversion);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Collection<?> getKeysToLock() {
        return this.entries.keySet();
    }

    @Override
    public Mutation<K, V, ?> toMutation(Object key) {
        return new Mutations.WriteWithValue(this.keyDataConversion, this.valueDataConversion, this.entries.get(key), this.f);
    }

    @Override
    public void init(ComponentRegistry componentRegistry) {
        componentRegistry.wireDependencies(this.keyDataConversion);
        componentRegistry.wireDependencies(this.valueDataConversion);
        if (this.f instanceof InjectableComponent) {
            ((InjectableComponent)((Object)this.f)).inject(componentRegistry);
        }
    }
}

