/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.NamespaceMappingParser;
import org.infinispan.configuration.parsing.ParserContext;
import org.infinispan.configuration.parsing.Schema;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.configuration.parsing.XMLExtendedStreamReaderImpl;
import org.infinispan.configuration.serializing.ConfigurationHolder;
import org.infinispan.configuration.serializing.Serializer;
import org.infinispan.configuration.serializing.XMLExtendedStreamWriter;
import org.infinispan.configuration.serializing.XMLExtendedStreamWriterImpl;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ParserRegistry
implements NamespaceMappingParser {
    private static final Log log = LogFactory.getLog(ParserRegistry.class);
    private final WeakReference<ClassLoader> cl;
    private final ConcurrentMap<QName, ConfigurationParser> parserMappings = CollectionFactory.makeConcurrentMap();

    public ParserRegistry() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ParserRegistry(ClassLoader classLoader) {
        this(classLoader, false);
    }

    public ParserRegistry(ClassLoader classLoader, boolean defaultOnly) {
        this.cl = new WeakReference<ClassLoader>(classLoader);
        Collection parsers = ServiceFinder.load(ConfigurationParser.class, (ClassLoader[])new ClassLoader[]{(ClassLoader)this.cl.get(), ParserRegistry.class.getClassLoader()});
        for (ConfigurationParser parser : parsers) {
            Namespace[] namespaces = parser.getNamespaces();
            if (namespaces == null) {
                throw log.parserDoesNotDeclareNamespaces(parser.getClass().getName());
            }
            boolean skipParser = defaultOnly;
            if (skipParser) {
                for (Namespace ns : namespaces) {
                    if (!"".equals(ns.uri())) continue;
                    skipParser = false;
                }
            }
            if (skipParser) continue;
            for (Namespace ns : namespaces) {
                QName qName = new QName(ns.uri(), ns.root());
                ConfigurationParser existingParser = this.parserMappings.putIfAbsent(qName, parser);
                if (existingParser == null || parser.getClass().equals(existingParser.getClass())) continue;
                log.parserRootElementAlreadyRegistered(qName, parser.getClass().getName(), existingParser.getClass().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationBuilderHolder parseFile(String filename) throws IOException {
        FileLookup fileLookup = FileLookupFactory.newInstance();
        InputStream is = fileLookup.lookupFile(filename, (ClassLoader)this.cl.get());
        if (is == null) {
            throw new FileNotFoundException(filename);
        }
        try {
            ConfigurationBuilderHolder configurationBuilderHolder = this.parse(is);
            return configurationBuilderHolder;
        }
        finally {
            Util.close((AutoCloseable)is);
        }
    }

    public ConfigurationBuilderHolder parse(String s) {
        return this.parse(new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8)));
    }

    public ConfigurationBuilderHolder parse(InputStream is) {
        try {
            ConfigurationBuilderHolder holder = new ConfigurationBuilderHolder((ClassLoader)this.cl.get());
            this.parse(is, holder);
            holder.validate();
            return holder;
        }
        catch (CacheConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheConfigurationException(e);
        }
    }

    public void parse(InputStream is, ConfigurationBuilderHolder holder) throws XMLStreamException {
        BufferedInputStream input = new BufferedInputStream(is);
        XMLStreamReader subReader = XMLInputFactory.newInstance().createXMLStreamReader(input);
        XMLExtendedStreamReaderImpl reader = new XMLExtendedStreamReaderImpl(this, subReader);
        this.parse(reader, holder);
        subReader.close();
        for (ParserContext parserContext : holder.getParserContexts().values()) {
            parserContext.fireParsingComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        try {
            reader.require(7, null, null);
            reader.nextTag();
            reader.require(1, null, null);
            this.parseElement(reader, holder);
            while (reader.next() != 8) {
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void parseElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        QName name = reader.getName();
        ConfigurationParser parser = (ConfigurationParser)this.parserMappings.get(name);
        if (parser == null) {
            throw log.unsupportedConfiguration(name.getLocalPart(), name.getNamespaceURI());
        }
        Schema oldSchema = reader.getSchema();
        reader.setSchema(Schema.fromNamespaceURI(name.getNamespaceURI()));
        parser.readElement(reader, holder);
        reader.setSchema(oldSchema);
    }

    public void serialize(OutputStream os, GlobalConfiguration globalConfiguration, Map<String, Configuration> configurations) throws XMLStreamException {
        BufferedOutputStream output = new BufferedOutputStream(os);
        XMLStreamWriter subWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(output);
        XMLExtendedStreamWriterImpl writer = new XMLExtendedStreamWriterImpl(subWriter);
        this.serialize(writer, globalConfiguration, configurations);
        subWriter.close();
    }

    public void serialize(XMLExtendedStreamWriter writer, GlobalConfiguration globalConfiguration, Map<String, Configuration> configurations) throws XMLStreamException {
        writer.writeStartDocument();
        writer.writeStartElement("infinispan");
        Serializer serializer = new Serializer();
        serializer.serialize(writer, new ConfigurationHolder(globalConfiguration, configurations));
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    public void serialize(OutputStream os, String name, Configuration configuration) throws XMLStreamException {
        this.serialize(os, null, Collections.singletonMap(name, configuration));
    }

    public String serialize(String name, Configuration configuration) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.serialize((OutputStream)os, name, configuration);
            return os.toString("UTF-8");
        }
        catch (Exception e) {
            throw new CacheConfigurationException(e);
        }
    }
}

