/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheWriter;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.RemovalCause;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.EntrySizeCalculator;
import org.infinispan.commons.util.EvictionListener;
import org.infinispan.commons.util.PeekableMap;
import org.infinispan.commons.util.Util;
import org.infinispan.container.DataContainer;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntrySizeCalculator;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.PrimitiveEntrySizeCalculator;
import org.infinispan.eviction.ActivationManager;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.eviction.EvictionType;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.filter.KeyFilter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.marshall.core.WrappedByteArraySizeCalculator;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.L1Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.util.CoreImmutables;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.WithinThreadExecutor;

@ThreadSafe
public class DefaultDataContainer<K, V>
implements DataContainer<K, V> {
    private static final Log log = LogFactory.getLog(DefaultDataContainer.class);
    private static final boolean trace = log.isTraceEnabled();
    private final ConcurrentMap<K, InternalCacheEntry<K, V>> entries;
    private final Cache<K, InternalCacheEntry<K, V>> evictionCache;
    @Inject
    protected InternalEntryFactory entryFactory;
    @Inject
    private EvictionManager evictionManager;
    @Inject
    private PassivationManager passivator;
    @Inject
    private ActivationManager activator;
    @Inject
    private PersistenceManager pm;
    @Inject
    private TimeService timeService;
    @Inject
    private CacheNotifier cacheNotifier;
    @Inject
    private ExpirationManager<K, V> expirationManager;

    public DefaultDataContainer(int concurrencyLevel) {
        this.entries = CollectionFactory.makeConcurrentParallelMap((int)128, (int)concurrencyLevel);
        this.evictionCache = null;
    }

    private static <K, V> Caffeine<K, V> caffeineBuilder() {
        return Caffeine.newBuilder();
    }

    protected DefaultDataContainer(int concurrencyLevel, long thresholdSize, EvictionType thresholdPolicy) {
        DefaultEvictionListener evictionListener = new DefaultEvictionListener();
        Caffeine<K, V> caffeine = DefaultDataContainer.caffeineBuilder();
        switch (thresholdPolicy) {
            case MEMORY: {
                CacheEntrySizeCalculator calc = new CacheEntrySizeCalculator(new WrappedByteArraySizeCalculator((EntrySizeCalculator<?, ?>)new PrimitiveEntrySizeCalculator()));
                caffeine.weigher((k, v) -> (int)calc.calculateSize(k, v)).maximumWeight(thresholdSize);
                break;
            }
            case COUNT: {
                caffeine.maximumSize(thresholdSize);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Policy not supported: " + (Object)((Object)thresholdPolicy));
            }
        }
        this.evictionCache = this.applyListener(caffeine, evictionListener).build();
        this.entries = this.evictionCache.asMap();
    }

    private Caffeine<K, InternalCacheEntry<K, V>> applyListener(Caffeine<K, InternalCacheEntry<K, V>> caffeine, final DefaultEvictionListener listener) {
        return caffeine.executor((Executor)new WithinThreadExecutor()).removalListener((k, v, c) -> {
            switch (c) {
                case SIZE: {
                    listener.onEntryEviction(Collections.singletonMap(k, v));
                    break;
                }
                case EXPLICIT: {
                    listener.onEntryRemoved(new ImmortalCacheEntry(k, v));
                    break;
                }
                case REPLACED: {
                    listener.onEntryActivated(k);
                }
            }
        }).writer(new CacheWriter<K, InternalCacheEntry<K, V>>(){

            public void write(K key, InternalCacheEntry<K, V> value) {
            }

            public void delete(K key, InternalCacheEntry<K, V> value, RemovalCause cause) {
                if (cause == RemovalCause.SIZE) {
                    listener.onEntryChosenForEviction(new ImmortalCacheEntry(key, value));
                }
            }
        });
    }

    protected DefaultDataContainer(int concurrencyLevel, long thresholdSize, EntrySizeCalculator<? super K, ? super V> sizeCalculator) {
        this(thresholdSize, (EntrySizeCalculator<? super K, InternalCacheEntry<? super K, V>>)new CacheEntrySizeCalculator<K, V>(sizeCalculator));
    }

    protected DefaultDataContainer(long thresholdSize, EntrySizeCalculator<? super K, ? super InternalCacheEntry<K, V>> sizeCalculator) {
        DefaultEvictionListener evictionListener = new DefaultEvictionListener();
        this.evictionCache = this.applyListener(Caffeine.newBuilder().weigher((k, v) -> (int)sizeCalculator.calculateSize(k, v)).maximumWeight(thresholdSize), evictionListener).build();
        this.entries = this.evictionCache.asMap();
    }

    public static <K, V> DefaultDataContainer<K, V> boundedDataContainer(int concurrencyLevel, long maxEntries, EvictionType thresholdPolicy) {
        return new DefaultDataContainer<K, V>(concurrencyLevel, maxEntries, thresholdPolicy);
    }

    public static <K, V> DefaultDataContainer<K, V> boundedDataContainer(int concurrencyLevel, long maxEntries, EntrySizeCalculator<? super K, ? super V> sizeCalculator) {
        return new DefaultDataContainer<K, V>(concurrencyLevel, maxEntries, sizeCalculator);
    }

    public static <K, V> DefaultDataContainer<K, V> unBoundedDataContainer(int concurrencyLevel) {
        return new DefaultDataContainer<K, V>(concurrencyLevel);
    }

    @Override
    public InternalCacheEntry<K, V> peek(Object key) {
        if (this.entries instanceof PeekableMap) {
            return (InternalCacheEntry)((PeekableMap)this.entries).peek(key);
        }
        return (InternalCacheEntry)this.entries.get(key);
    }

    @Override
    public InternalCacheEntry<K, V> get(Object k) {
        InternalCacheEntry e = (InternalCacheEntry)this.entries.get(k);
        if (e != null && e.canExpire()) {
            long currentTimeMillis = this.timeService.wallClockTime();
            if (e.isExpired(currentTimeMillis)) {
                this.expirationManager.handleInMemoryExpiration(e, currentTimeMillis);
                e = null;
            } else {
                e.touch(currentTimeMillis);
            }
        }
        return e;
    }

    @Override
    public void put(K k, V v, Metadata metadata) {
        boolean l1Entry = false;
        if (metadata instanceof L1Metadata) {
            metadata = ((L1Metadata)metadata).metadata();
            l1Entry = true;
        }
        InternalCacheEntry e = (InternalCacheEntry)this.entries.get(k);
        if (trace) {
            log.tracef("Creating new ICE for writing. Existing=%s, metadata=%s, new value=%s", (Object)e, (Object)metadata, (Object)Util.toStr(v));
        }
        InternalCacheEntry<K, V> copy = l1Entry ? this.entryFactory.createL1(k, v, metadata) : (e != null ? this.entryFactory.update(e, v, metadata) : this.entryFactory.create(k, v, metadata));
        if (trace) {
            log.tracef("Store %s in container", copy);
        }
        this.entries.compute(copy.getKey(), (? super K key, ? super V entry) -> {
            this.activator.onUpdate(key, entry == null);
            return copy;
        });
    }

    @Override
    public boolean containsKey(Object k) {
        long currentTimeMillis;
        InternalCacheEntry<K, V> ice = this.peek(k);
        if (ice != null && ice.canExpire() && ice.isExpired(currentTimeMillis = this.timeService.wallClockTime())) {
            this.expirationManager.handleInMemoryExpiration(ice, currentTimeMillis);
            ice = null;
        }
        return ice != null;
    }

    @Override
    public InternalCacheEntry<K, V> remove(Object k) {
        InternalCacheEntry[] reference = new InternalCacheEntry[1];
        this.entries.compute(k, (? super K key, ? super V entry) -> {
            this.activator.onRemove(key, entry == null);
            reference[0] = entry;
            return null;
        });
        InternalCacheEntry e = reference[0];
        if (trace) {
            log.tracef("Removed %s from container", (Object)e);
        }
        return e == null || e.canExpire() && e.isExpired(this.timeService.wallClockTime()) ? null : e;
    }

    private Policy.Eviction<K, InternalCacheEntry<K, V>> eviction() {
        Optional eviction;
        if (this.evictionCache != null && (eviction = this.evictionCache.policy().eviction()).isPresent()) {
            return (Policy.Eviction)eviction.get();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public long capacity() {
        Policy.Eviction<K, InternalCacheEntry<K, V>> evict = this.eviction();
        return evict.getMaximum();
    }

    @Override
    public void resize(long newSize) {
        Policy.Eviction<K, InternalCacheEntry<K, V>> evict = this.eviction();
        evict.setMaximum(newSize);
    }

    @Override
    public int size() {
        int size = 0;
        Iterator<InternalCacheEntry<K, V>> iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            if (++size != Integer.MAX_VALUE) continue;
            return Integer.MAX_VALUE;
        }
        return size;
    }

    @Override
    public int sizeIncludingExpired() {
        return this.entries.size();
    }

    @Override
    public void clear() {
        log.tracef("Clearing data container", new Object[0]);
        this.entries.clear();
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.entries.keySet());
    }

    @Override
    public Collection<V> values() {
        return new Values();
    }

    @Override
    public Set<InternalCacheEntry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public void evict(K key) {
        this.entries.computeIfPresent(key, (o, entry) -> {
            this.passivator.passivate((InternalCacheEntry)entry);
            return null;
        });
    }

    @Override
    public InternalCacheEntry<K, V> compute(K key, DataContainer.ComputeAction<K, V> action) {
        return this.entries.compute(key, (? super K k, ? super V oldEntry) -> {
            InternalCacheEntry newEntry = action.compute((K)k, (InternalCacheEntry<K, V>)oldEntry, this.entryFactory);
            if (newEntry == oldEntry) {
                return oldEntry;
            }
            if (newEntry == null) {
                this.activator.onRemove(k, false);
                return null;
            }
            this.activator.onUpdate(k, oldEntry == null);
            if (trace) {
                log.tracef("Store %s in container", newEntry);
            }
            return newEntry;
        });
    }

    @Override
    public Iterator<InternalCacheEntry<K, V>> iterator() {
        return new EntryIterator(this.entries.values().iterator());
    }

    @Override
    public Spliterator<InternalCacheEntry<K, V>> spliterator() {
        return new EntrySpliterator(this.entries.values().spliterator());
    }

    @Override
    public Iterator<InternalCacheEntry<K, V>> iteratorIncludingExpired() {
        return this.entries.values().iterator();
    }

    @Override
    public Spliterator<InternalCacheEntry<K, V>> spliteratorIncludingExpired() {
        return this.entries.values().spliterator();
    }

    @Override
    public long evictionSize() {
        Policy.Eviction<K, InternalCacheEntry<K, V>> evict = this.eviction();
        return evict.weightedSize().orElse(this.entries.size());
    }

    @Override
    public void executeTask(KeyFilter<? super K> filter, BiConsumer<? super K, InternalCacheEntry<K, V>> action) throws InterruptedException {
        if (filter == null) {
            throw new IllegalArgumentException("No filter specified");
        }
        if (action == null) {
            throw new IllegalArgumentException("No action specified");
        }
        long now = this.timeService.wallClockTime();
        this.entries.forEach((? super K key, ? super V value) -> {
            if (filter.accept(key) && !value.isExpired(now)) {
                action.accept((Object)key, (InternalCacheEntry)value);
            }
        });
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    @Override
    public void executeTask(KeyValueFilter<? super K, ? super V> filter, BiConsumer<? super K, InternalCacheEntry<K, V>> action) throws InterruptedException {
        if (filter == null) {
            throw new IllegalArgumentException("No filter specified");
        }
        if (action == null) {
            throw new IllegalArgumentException("No action specified");
        }
        long now = this.timeService.wallClockTime();
        this.entries.forEach((? super K key, ? super V value) -> {
            if (filter.accept((Object)key, (Object)value.getValue(), value.getMetadata()) && !value.isExpired(now)) {
                action.accept((Object)key, (InternalCacheEntry)value);
            }
        });
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    private static class ValueIterator<K, V>
    implements Iterator<V> {
        Iterator<InternalCacheEntry<K, V>> currentIterator;

        private ValueIterator(Iterator<InternalCacheEntry<K, V>> it) {
            this.currentIterator = it;
        }

        @Override
        public boolean hasNext() {
            return this.currentIterator.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public V next() {
            return this.currentIterator.next().getValue();
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(DefaultDataContainer.this.entries.values().iterator());
        }

        @Override
        public int size() {
            return DefaultDataContainer.this.entries.size();
        }

        @Override
        public Spliterator<V> spliterator() {
            return Spliterators.spliterator(this, 4096);
        }
    }

    private class EntrySet
    extends AbstractSet<InternalCacheEntry<K, V>> {
        private EntrySet() {
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            InternalCacheEntry ice = (InternalCacheEntry)DefaultDataContainer.this.entries.get(e.getKey());
            if (ice == null) {
                return false;
            }
            return ice.getValue().equals(e.getValue());
        }

        @Override
        public Iterator<InternalCacheEntry<K, V>> iterator() {
            return new ImmutableEntryIterator(DefaultDataContainer.this.entries.values().iterator());
        }

        @Override
        public int size() {
            return DefaultDataContainer.this.entries.size();
        }

        @Override
        public String toString() {
            return DefaultDataContainer.this.entries.toString();
        }

        @Override
        public Spliterator<InternalCacheEntry<K, V>> spliterator() {
            return Spliterators.spliterator(this, 4097);
        }
    }

    private class EntrySpliterator
    implements CloseableSpliterator<InternalCacheEntry<K, V>> {
        private final Spliterator<InternalCacheEntry<K, V>> spliterator;
        private final Consumer<? super InternalCacheEntry<K, V>> consumer = ice -> {
            this.current = ice;
        };
        private InternalCacheEntry<K, V> current;

        private EntrySpliterator(Spliterator<InternalCacheEntry<K, V>> spliterator) {
            this.spliterator = spliterator;
        }

        public void close() {
        }

        public boolean tryAdvance(Consumer<? super InternalCacheEntry<K, V>> action) {
            InternalCacheEntry entryToUse = null;
            boolean initializedTime = false;
            long now = 0L;
            while (entryToUse == null && this.spliterator.tryAdvance(this.consumer)) {
                entryToUse = this.current;
                if (!entryToUse.canExpire()) continue;
                if (!initializedTime) {
                    now = DefaultDataContainer.this.timeService.wallClockTime();
                    initializedTime = true;
                }
                if (!entryToUse.isExpired(now)) continue;
                entryToUse = null;
            }
            if (entryToUse != null) {
                action.accept(entryToUse);
                return true;
            }
            return false;
        }

        public void forEachRemaining(Consumer<? super InternalCacheEntry<K, V>> action) {
            boolean initializedTime = false;
            long now = 0L;
            while (this.spliterator.tryAdvance(this.consumer)) {
                InternalCacheEntry currentEntry = this.current;
                if (currentEntry.canExpire()) {
                    if (!initializedTime) {
                        now = DefaultDataContainer.this.timeService.wallClockTime();
                        initializedTime = true;
                    }
                    if (currentEntry.isExpired(now)) continue;
                }
                action.accept(currentEntry);
            }
        }

        public Spliterator<InternalCacheEntry<K, V>> trySplit() {
            Spliterator split = this.spliterator.trySplit();
            if (split != null) {
                return new EntrySpliterator(split);
            }
            return null;
        }

        public long estimateSize() {
            return this.spliterator.estimateSize();
        }

        public int characteristics() {
            return this.spliterator.characteristics() | 1;
        }
    }

    public class EntryIterator
    implements Iterator<InternalCacheEntry<K, V>> {
        private final Iterator<InternalCacheEntry<K, V>> it;
        private InternalCacheEntry<K, V> next;

        EntryIterator(Iterator<InternalCacheEntry<K, V>> it) {
            this.it = it;
        }

        private InternalCacheEntry<K, V> getNext() {
            boolean initializedTime = false;
            long now = 0L;
            while (this.it.hasNext()) {
                InternalCacheEntry entry = this.it.next();
                if (!entry.canExpire()) {
                    if (trace) {
                        log.tracef("Return next entry %s", entry);
                    }
                    return entry;
                }
                if (!initializedTime) {
                    now = DefaultDataContainer.this.timeService.wallClockTime();
                    initializedTime = true;
                }
                if (!entry.isExpired(now)) {
                    if (trace) {
                        log.tracef("Return next entry %s", entry);
                    }
                    return entry;
                }
                if (!trace) continue;
                log.tracef("%s is expired", entry);
            }
            if (trace) {
                log.tracef("Return next null", new Object[0]);
            }
            return null;
        }

        @Override
        public InternalCacheEntry<K, V> next() {
            if (this.next == null) {
                this.next = this.getNext();
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            InternalCacheEntry toReturn = this.next;
            this.next = null;
            return toReturn;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                this.next = this.getNext();
            }
            return this.next != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ImmutableEntryIterator
    extends EntryIterator {
        ImmutableEntryIterator(Iterator<InternalCacheEntry<K, V>> it) {
            super(it);
        }

        @Override
        public InternalCacheEntry<K, V> next() {
            return CoreImmutables.immutableInternalCacheEntry(super.next());
        }
    }

    private final class DefaultEvictionListener
    implements EvictionListener<K, InternalCacheEntry<K, V>> {
        private DefaultEvictionListener() {
        }

        public void onEntryEviction(Map<K, InternalCacheEntry<K, V>> evicted) {
            DefaultDataContainer.this.evictionManager.onEntryEviction(evicted);
        }

        public void onEntryChosenForEviction(Map.Entry<K, InternalCacheEntry<K, V>> entry) {
            DefaultDataContainer.this.passivator.passivate(entry.getValue());
        }

        public void onEntryActivated(Object key) {
            DefaultDataContainer.this.activator.onUpdate(key, true);
        }

        public void onEntryRemoved(Map.Entry<K, InternalCacheEntry<K, V>> entry) {
        }
    }
}

