/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.util.concurrent.atomic.LongAdder;
import java.util.function.LongUnaryOperator;
import org.infinispan.container.offheap.OffHeapEntryFactory;
import org.infinispan.container.offheap.OffHeapMemory;
import org.infinispan.container.offheap.OffHeapMemoryAllocator;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class UnpooledOffHeapMemoryAllocator
implements OffHeapMemoryAllocator {
    private static final Log log = LogFactory.getLog(UnpooledOffHeapMemoryAllocator.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final OffHeapMemory MEMORY = OffHeapMemory.INSTANCE;
    private final LongAdder amountAllocated = new LongAdder();
    private LongUnaryOperator sizeCalculator;

    @Inject
    public void inject(OffHeapEntryFactory offHeapEntryFactory) {
        this.sizeCalculator = offHeapEntryFactory::getSize;
    }

    @Override
    public long allocate(long memoryLength) {
        long estimatedMemoryLength = UnpooledOffHeapMemoryAllocator.estimateSizeOverhead(memoryLength);
        long memoryLocation = MEMORY.allocate(memoryLength);
        this.amountAllocated.add(estimatedMemoryLength);
        if (trace) {
            log.tracef("Allocated off heap memory at 0x%016x with %d bytes. Total size: %d", memoryLocation, estimatedMemoryLength, this.amountAllocated.sum());
        }
        return memoryLocation;
    }

    @Override
    public void deallocate(long memoryAddress) {
        this.innerDeallocate(memoryAddress, this.sizeCalculator.applyAsLong(memoryAddress));
    }

    @Override
    public void deallocate(long memoryAddress, long size) {
        long estimatedMemoryLength = UnpooledOffHeapMemoryAllocator.estimateSizeOverhead(size);
        this.innerDeallocate(memoryAddress, estimatedMemoryLength);
    }

    private void innerDeallocate(long memoryAddress, long estimatedSize) {
        this.amountAllocated.add(-estimatedSize);
        if (trace) {
            log.tracef("Deallocating off heap memory at 0x%016x with %d bytes. Total size: %d", memoryAddress, estimatedSize, this.amountAllocated.sum());
        }
        MEMORY.free(memoryAddress);
    }

    @Override
    public long getAllocatedAmount() {
        return this.amountAllocated.sum();
    }

    public static long estimateSizeOverhead(long size) {
        return size + 8L + 15L & 0xFFFFFFFFFFFFFFF0L;
    }
}

