/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.stream.impl.ClusterStreamManager;
import org.infinispan.stream.impl.ClusterStreamManagerImpl;
import org.infinispan.stream.impl.LocalStreamManager;
import org.infinispan.stream.impl.LocalStreamManagerImpl;
import org.infinispan.stream.impl.PartitionAwareClusterStreamManager;

@DefaultFactoryFor(classes={LocalStreamManager.class, ClusterStreamManager.class})
public class StreamManagerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public <T> T construct(Class<T> componentType) {
        CacheMode cacheMode = this.configuration.clustering().cacheMode();
        if (cacheMode.needsStateTransfer()) {
            if (componentType.equals(LocalStreamManager.class)) {
                return componentType.cast(new LocalStreamManagerImpl());
            }
            if (componentType.equals(ClusterStreamManager.class)) {
                if (this.configuration.clustering().partitionHandling().whenSplit() != PartitionHandling.ALLOW_READ_WRITES) {
                    return componentType.cast(new PartitionAwareClusterStreamManager());
                }
                return componentType.cast(new ClusterStreamManagerImpl());
            }
        }
        return null;
    }
}

