/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commons.util.Experimental;
import org.infinispan.context.InvocationContext;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.Listeners;
import org.infinispan.functional.Param;
import org.infinispan.functional.impl.AbstractFunctionalMap;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.Params;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Experimental
public final class WriteOnlyMapImpl<K, V>
extends AbstractFunctionalMap<K, V>
implements FunctionalMap.WriteOnlyMap<K, V> {
    private static final Log log = LogFactory.getLog(WriteOnlyMapImpl.class);

    private WriteOnlyMapImpl(Params params, FunctionalMapImpl<K, V> functionalMap) {
        super(params, functionalMap);
    }

    public static <K, V> FunctionalMap.WriteOnlyMap<K, V> create(FunctionalMapImpl<K, V> functionalMap) {
        return WriteOnlyMapImpl.create(Params.from(functionalMap.params.params), functionalMap);
    }

    private static <K, V> FunctionalMap.WriteOnlyMap<K, V> create(Params params, FunctionalMapImpl<K, V> functionalMap) {
        return new WriteOnlyMapImpl<K, V>(params, functionalMap);
    }

    @Override
    public CompletableFuture<Void> eval(K key, Consumer<EntryView.WriteEntryView<V>> f) {
        log.tracef("Invoked eval(k=%s, %s)", key, this.params);
        Object keyEncoded = this.keyDataConversion.toStorage(key);
        WriteOnlyKeyCommand cmd = this.fmap.commandsFactory.buildWriteOnlyKeyCommand(keyEncoded, f, this.params, this.keyDataConversion, this.valueDataConversion);
        InvocationContext ctx = this.getInvocationContext(true, 1);
        if (ctx.getLockOwner() == null) {
            ctx.setLockOwner(cmd.getKeyLockOwner());
        }
        return this.invokeAsync(ctx, cmd);
    }

    @Override
    public CompletableFuture<Void> eval(K key, V value, BiConsumer<V, EntryView.WriteEntryView<V>> f) {
        log.tracef("Invoked eval(k=%s, v=%s, %s)", key, value, this.params);
        Object keyEncoded = this.keyDataConversion.toStorage(key);
        Object valueEncoded = this.valueDataConversion.toStorage(value);
        WriteOnlyKeyValueCommand cmd = this.fmap.commandsFactory.buildWriteOnlyKeyValueCommand(keyEncoded, valueEncoded, f, this.params, this.keyDataConversion, this.valueDataConversion);
        InvocationContext ctx = this.getInvocationContext(true, 1);
        if (ctx.getLockOwner() == null) {
            ctx.setLockOwner(cmd.getKeyLockOwner());
        }
        return this.invokeAsync(ctx, cmd);
    }

    @Override
    public CompletableFuture<Void> evalMany(Map<? extends K, ? extends V> entries, BiConsumer<V, EntryView.WriteEntryView<V>> f) {
        log.tracef("Invoked evalMany(entries=%s, %s)", entries, this.params);
        Map<?, ?> encodedEntries = this.encodeEntries(entries);
        WriteOnlyManyEntriesCommand cmd = this.fmap.commandsFactory.buildWriteOnlyManyEntriesCommand(encodedEntries, f, this.params, this.keyDataConversion, this.valueDataConversion);
        InvocationContext ctx = this.getInvocationContext(true, entries.size());
        if (ctx.getLockOwner() == null) {
            ctx.setLockOwner(cmd.getKeyLockOwner());
        }
        return this.invokeAsync(ctx, cmd);
    }

    @Override
    public CompletableFuture<Void> evalMany(Set<? extends K> keys, Consumer<EntryView.WriteEntryView<V>> f) {
        log.tracef("Invoked evalMany(keys=%s, %s)", keys, this.params);
        Set<?> encodedKeys = this.encodeKeys(keys);
        WriteOnlyManyCommand cmd = this.fmap.commandsFactory.buildWriteOnlyManyCommand(encodedKeys, f, this.params, this.keyDataConversion, this.valueDataConversion);
        InvocationContext ctx = this.getInvocationContext(true, keys.size());
        if (ctx.getLockOwner() == null) {
            ctx.setLockOwner(cmd.getKeyLockOwner());
        }
        return this.invokeAsync(ctx, cmd);
    }

    @Override
    public CompletableFuture<Void> evalAll(Consumer<EntryView.WriteEntryView<V>> f) {
        log.tracef("Invoked evalAll(%s)", this.params);
        HashSet keys = new HashSet(this.fmap.cache.keySet());
        Set<?> encodedKeys = this.encodeKeys(keys);
        WriteOnlyManyCommand cmd = this.fmap.commandsFactory.buildWriteOnlyManyCommand(encodedKeys, f, this.params, this.keyDataConversion, this.valueDataConversion);
        InvocationContext ctx = this.getInvocationContext(true, encodedKeys.size());
        if (ctx.getLockOwner() == null) {
            ctx.setLockOwner(cmd.getKeyLockOwner());
        }
        return this.invokeAsync(ctx, cmd);
    }

    @Override
    public CompletableFuture<Void> truncate() {
        log.tracef("Invoked truncate(%s)", this.params);
        return this.fmap.cache.clearAsync();
    }

    @Override
    public FunctionalMap.WriteOnlyMap<K, V> withParams(Param<?> ... ps) {
        if (ps == null || ps.length == 0) {
            return this;
        }
        if (this.params.containsAll(ps)) {
            return this;
        }
        return WriteOnlyMapImpl.create(this.params.addAll(ps), this.fmap);
    }

    @Override
    public Listeners.WriteListeners<K, V> listeners() {
        return this.fmap.notifier;
    }
}

