/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Supplier;

public class StripedCounters<T> {
    private static final int STRIPE_COUNT = (int)(Long.highestOneBit(Runtime.getRuntime().availableProcessors()) << 1);
    private static final int STRIPE_MASK = STRIPE_COUNT - 1;
    private T[] stripes = new Object[STRIPE_COUNT];

    public StripedCounters(Supplier<T> stripeSupplier) {
        for (int i = 0; i < this.stripes.length; ++i) {
            this.stripes[i] = stripeSupplier.get();
        }
    }

    public void increment(AtomicLongFieldUpdater<T> updater, T stripe) {
        updater.getAndIncrement(stripe);
    }

    public void add(AtomicLongFieldUpdater<T> updater, T stripe, long delta) {
        updater.getAndAdd(stripe, delta);
    }

    public long get(AtomicLongFieldUpdater<T> updater) {
        long sum = 0L;
        for (T stripe : this.stripes) {
            sum += updater.get(stripe);
        }
        return sum;
    }

    public void reset(AtomicLongFieldUpdater<T> updater) {
        for (T stripe : this.stripes) {
            updater.set(stripe, 0L);
        }
    }

    public T stripeForCurrentThread() {
        return this.stripes[this.threadIndex()];
    }

    private int threadIndex() {
        long id = Thread.currentThread().getId();
        id ^= id >>> 7 ^ id >>> 4;
        return (int)(id & (long)STRIPE_MASK);
    }
}

