/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories.components;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.GuardedBy;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.factories.components.ComponentMetadata;
import org.infinispan.factories.components.ModuleMetadataFileFinder;
import org.infinispan.factories.components.SecurityActions;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ComponentMetadataRepo {
    private static final Log log = LogFactory.getLog(ComponentMetadataRepo.class);
    final Map<String, ComponentMetadata> componentMetadataMap = new HashMap<String, ComponentMetadata>(128);
    final Map<String, String> factories = new HashMap<String, String>(16);
    private final ComponentMetadata dependencyFreeComponent = new ComponentMetadata();

    public synchronized void readMetadata(URL metadataFile) throws IOException, ClassNotFoundException {
        Map fact;
        Map comp;
        try (InputStream inputStream = metadataFile.openStream();
             BufferedInputStream bis = new BufferedInputStream(inputStream);
             ObjectInputStream ois = new ObjectInputStream(bis);){
            comp = (Map)ois.readObject();
            fact = (Map)ois.readObject();
        }
        this.componentMetadataMap.putAll(comp);
        this.factories.putAll(fact);
        if (log.isTraceEnabled()) {
            log.tracef("Loaded metadata from '%s': %d components, %d factories", metadataFile, comp.size(), fact.size());
        }
    }

    @Deprecated
    public ComponentMetadata findComponentMetadata(Class<?> componentType) {
        ComponentMetadata md = null;
        while (md == null) {
            String componentName = componentType.getName();
            md = this.findComponentMetadata(componentName);
            if (md != null) continue;
            if (!componentType.equals(Object.class) && !componentType.isInterface()) {
                componentType = componentType.getSuperclass();
                continue;
            }
            md = this.dependencyFreeComponent;
        }
        return md;
    }

    @Deprecated
    public ComponentMetadata findComponentMetadata(String componentName) {
        return this.componentMetadataMap.get(componentName);
    }

    public ComponentMetadata getComponentMetadata(Class<?> componentClass) {
        ComponentMetadata md = this.componentMetadataMap.get(componentClass.getName());
        if (md == null) {
            if (componentClass.getSuperclass() != null) {
                return this.getComponentMetadata(componentClass.getSuperclass());
            }
            return null;
        }
        this.initMetadata(componentClass, md);
        return md;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetadata(Class<?> componentClass, ComponentMetadata md) {
        if (md.clazz == null) {
            ComponentMetadataRepo componentMetadataRepo = this;
            synchronized (componentMetadataRepo) {
                if (md.clazz == null) {
                    this.initInjectionFields(md, componentClass, componentClass.getClassLoader());
                    this.initInjectionMethods(md, componentClass, componentClass.getClassLoader());
                    this.initLifecycleMethods(md.getStartMethods(), componentClass);
                    this.initLifecycleMethods(md.getPostStartMethods(), componentClass);
                    this.initLifecycleMethods(md.getStopMethods(), componentClass);
                    md.clazz = componentClass;
                }
            }
        }
        if (md.clazz != componentClass) {
            throw new IllegalStateException("Component metadata has the wrong type: " + md.clazz + ", expected: " + componentClass);
        }
    }

    public String findFactoryForComponent(Class<?> componentType) {
        return this.factories.get(componentType.getName());
    }

    public String findFactoryForComponent(String componentName) {
        return this.factories.get(componentName);
    }

    public void initialize(Iterable<ModuleMetadataFileFinder> moduleMetadataFiles, ClassLoader cl) {
        FileLookup fileLookup = FileLookupFactory.newInstance();
        try {
            this.readMetadata(fileLookup.lookupFileLocation("infinispan-core-component-metadata.dat", cl));
        }
        catch (Exception e) {
            throw new CacheException("Unable to load component metadata!", (Throwable)e);
        }
        for (ModuleMetadataFileFinder finder : moduleMetadataFiles) {
            try {
                this.readMetadata(fileLookup.lookupFileLocation(finder.getMetadataFilename(), cl));
            }
            catch (Exception e) {
                throw new CacheException("Unable to load component metadata in file " + finder.getMetadataFilename(), (Throwable)e);
            }
        }
    }

    @Deprecated
    public void injectFactoryForComponent(Class<?> componentType, Class<?> factoryType) {
        this.factories.put(componentType.getName(), factoryType.getName());
    }

    public boolean hasFactory(String name) {
        return this.factories.containsKey(name);
    }

    @GuardedBy(value="this")
    private void initInjectionMethods(ComponentMetadata metadata, Class<?> componentClass, ClassLoader classLoader) {
        ComponentMetadata.InjectMethodMetadata[] injectionMethods = metadata.getInjectMethods();
        if (injectionMethods != null && injectionMethods.length > 0) {
            for (ComponentMetadata.InjectMethodMetadata methodMetadata : injectionMethods) {
                try {
                    String[] parameters = methodMetadata.getParameters();
                    Class[] parameterClasses = new Class[parameters.length];
                    for (int i = 0; i < parameters.length; ++i) {
                        String parameter = parameters[i];
                        parameterClasses[i] = methodMetadata.getParameterLazy(i) ? ComponentRef.class : ReflectionUtil.getClassForName((String)parameter, (ClassLoader)classLoader);
                    }
                    methodMetadata.setParameterClasses(parameterClasses);
                    Method method = SecurityActions.getMethod(componentClass, methodMetadata, parameterClasses);
                    methodMetadata.setMethod(method);
                }
                catch (ClassNotFoundException e) {
                    throw new CacheConfigurationException((Exception)e);
                }
            }
        }
    }

    @GuardedBy(value="this")
    private void initInjectionFields(ComponentMetadata metadata, Class<?> componentClass, ClassLoader classLoader) {
        ComponentMetadata.InjectFieldMetadata[] injectionFields = metadata.getInjectFields();
        if (injectionFields != null && injectionFields.length > 0) {
            for (ComponentMetadata.InjectFieldMetadata fieldMetadata : injectionFields) {
                Class<?> declarationClass = componentClass;
                while (!declarationClass.getName().equals(fieldMetadata.getFieldClassName())) {
                    declarationClass = declarationClass.getSuperclass();
                }
                Field field = SecurityActions.getField(fieldMetadata, declarationClass);
                fieldMetadata.setField(field);
                fieldMetadata.setComponentClass(Util.loadClass((String)fieldMetadata.getComponentType(), (ClassLoader)classLoader));
            }
        }
    }

    @GuardedBy(value="this")
    private void initLifecycleMethods(ComponentMetadata.PrioritizedMethodMetadata[] prioritizedMethods, Class<?> componentClass) {
        for (ComponentMetadata.PrioritizedMethodMetadata prioritizedMethod : prioritizedMethods) {
            Method method = SecurityActions.getMethod(componentClass, prioritizedMethod);
            prioritizedMethod.setMethod(method);
        }
        if (prioritizedMethods.length > 1) {
            Arrays.sort(prioritizedMethods, (a, b) -> a.getPriority() - b.getPriority());
        }
    }
}

