/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.Security;
import org.infinispan.security.actions.AddCacheDependencyAction;
import org.infinispan.security.actions.GetCacheManagerConfigurationAction;
import org.infinispan.security.actions.GetGlobalComponentRegistryAction;

final class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return Security.doPrivileged(action);
    }

    static GlobalComponentRegistry getGlobalComponentRegistry(EmbeddedCacheManager cacheManager) {
        return SecurityActions.doPrivileged(new GetGlobalComponentRegistryAction(cacheManager));
    }

    static GlobalConfiguration getCacheManagerConfiguration(EmbeddedCacheManager cacheManager) {
        return SecurityActions.doPrivileged(new GetCacheManagerConfigurationAction(cacheManager));
    }

    static void addCacheDependency(EmbeddedCacheManager cacheManager, String dependantCacheName, String protobufMetadataCacheName) {
        SecurityActions.doPrivileged(new AddCacheDependencyAction(cacheManager, dependantCacheName, protobufMetadataCacheName));
    }
}

