/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.stream.impl.EndIterator;
import org.infinispan.stream.impl.IteratorResponse;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class IteratorResponses
implements IteratorResponse {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final Iterator<Object> iterator;
    private final Spliterator<Object> spliterator;

    IteratorResponses(Iterator<Object> iterator, Spliterator<Object> spliterator) {
        this.iterator = iterator;
        this.spliterator = spliterator;
    }

    public Iterator<Object> getIterator() {
        return this.iterator;
    }

    public Spliterator<Object> getSpliterator() {
        return this.spliterator;
    }

    @Override
    public boolean isComplete() {
        return false;
    }

    public static class IteratorResponsesExternalizer
    extends AbstractExternalizer<IteratorResponses> {
        public Integer getId() {
            return 111;
        }

        public Set<Class<? extends IteratorResponses>> getTypeClasses() {
            return Collections.singleton(RemoteResponse.class);
        }

        public void writeObject(ObjectOutput output, IteratorResponses object) throws IOException {
            long i;
            RemoteResponse resp = (RemoteResponse)object;
            if (resp.batchSize > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("We don't yet support greater than int entries returned");
            }
            output.writeInt((int)resp.batchSize);
            Iterator<Object> iter = resp.getIterator();
            for (i = 0L; i < resp.batchSize && iter.hasNext(); ++i) {
                output.writeObject(iter.next());
            }
            output.writeObject(EndIterator.getInstance());
            boolean completed = !iter.hasNext();
            log.tracef("Sending %s entries to requestor and was complete? %s", String.valueOf(i), completed);
            output.writeBoolean(completed);
            if (completed) {
                output.writeObject(resp.getSuspectedSegments());
            }
        }

        public IteratorResponses readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Spliterator<Object> spliterator;
            int batchSize = input.readInt();
            Object object = input.readObject();
            if (object != EndIterator.getInstance()) {
                Object[] results = new Object[batchSize];
                results[0] = object;
                int offset = 1;
                while ((object = input.readObject()) != EndIterator.getInstance()) {
                    results[offset++] = object;
                }
                spliterator = Spliterators.spliterator(results, 0, offset, 257);
            } else {
                spliterator = Spliterators.emptySpliterator();
            }
            boolean complete = input.readBoolean();
            if (complete) {
                return new LastResponse(spliterator, (IntSet)input.readObject());
            }
            return new BatchResponse(spliterator);
        }
    }

    private static class LastResponse
    extends IteratorResponses {
        private final IntSet suspectedSegments;

        LastResponse(Spliterator<Object> spliterator, IntSet suspectedSegments) {
            super(null, spliterator);
            this.suspectedSegments = suspectedSegments;
        }

        @Override
        public boolean isComplete() {
            return true;
        }

        @Override
        public IntSet getSuspectedSegments() {
            return this.suspectedSegments;
        }

        public String toString() {
            return "LastResponse {suspectedSegments=" + this.suspectedSegments + "}";
        }
    }

    private static class BatchResponse
    extends IteratorResponses {
        BatchResponse(Spliterator<Object> spliterator) {
            super(null, spliterator);
        }

        @Override
        public IntSet getSuspectedSegments() {
            return IntSets.immutableEmptySet();
        }

        public String toString() {
            return "BatchResponse - more values required";
        }
    }

    static class RemoteResponse
    extends IteratorResponses {
        private final IntSet suspectedSegments;
        private final long batchSize;

        RemoteResponse(Iterator<Object> iterator, IntSet suspectedSegments, long batchSize) {
            super(iterator, null);
            this.suspectedSegments = suspectedSegments;
            this.batchSize = batchSize;
        }

        @Override
        public IntSet getSuspectedSegments() {
            return this.suspectedSegments;
        }
    }
}

