/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.ec2demo.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.infinispan.Cache;
import org.infinispan.ec2demo.CacheBuilder;
import org.infinispan.ec2demo.Influenza_N_P_CR_Element;
import org.infinispan.ec2demo.Nucleotide_Protein_Element;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CacheSearchServlet
extends HttpServlet {
    private Log myLogger = LogFactory.getLog(CacheSearchServlet.class);
    private static final long serialVersionUID = 1L;
    private Cache<String, Influenza_N_P_CR_Element> influenzaCache;
    private Cache<String, Nucleotide_Protein_Element> proteinCache;
    private Cache<String, Nucleotide_Protein_Element> nucleiodCache;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        CacheBuilder cacheBuilder = (CacheBuilder)this.getServletContext().getAttribute("cacheBuilder");
        this.influenzaCache = cacheBuilder.getCacheManager().getCache("InfluenzaCache");
        this.proteinCache = cacheBuilder.getCacheManager().getCache("ProteinCache");
        this.nucleiodCache = cacheBuilder.getCacheManager().getCache("NucleotideCache");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/jsp/displayVirusDetails.jsp");
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        CacheBuilder cacheBuilder = (CacheBuilder)this.getServletContext().getAttribute("cacheBuilder");
        String searchGBAN = request.getParameter("vGBAN");
        request.setAttribute("total", (Object)searchGBAN);
        Influenza_N_P_CR_Element myRec = (Influenza_N_P_CR_Element)this.influenzaCache.get((Object)searchGBAN);
        if (myRec != null) {
            this.myLogger.trace((Object)("Searching nucleiodCache for " + myRec.getGanNucleoid()));
            Nucleotide_Protein_Element nucldet = (Nucleotide_Protein_Element)this.nucleiodCache.get((Object)myRec.getGanNucleoid());
            request.setAttribute("Nucleotide", (Object)nucldet);
            Map<String, String> myProt = myRec.getProtein_Data();
            HashMap<String, String> myMap = new HashMap<String, String>();
            for (String x : myProt.keySet()) {
                this.myLogger.trace((Object)("Searching proteinCache for " + x));
                Nucleotide_Protein_Element myProtdet = (Nucleotide_Protein_Element)this.proteinCache.get((Object)x);
                String protein_CR = myProt.get(x);
                myMap.put(myProtdet.getGenbankAccessionNumber(), protein_CR);
            }
            request.setAttribute("PMap", myMap);
        }
        List myList = cacheBuilder.getCacheManager().getMembers();
        ArrayList<String> k = new ArrayList<String>();
        for (Address ad : myList) {
            k.add(ad.toString());
        }
        request.setAttribute("CMap", k);
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/jsp/VirusDetails.jsp");
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }
}

