/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene.internal.builder.predicate;

import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.hibernate.hql.ast.spi.predicate.ConjunctionPredicate;
import org.hibernate.hql.ast.spi.predicate.DisjunctionPredicate;
import org.hibernate.hql.ast.spi.predicate.InPredicate;
import org.hibernate.hql.ast.spi.predicate.IsNullPredicate;
import org.hibernate.hql.ast.spi.predicate.LikePredicate;
import org.hibernate.hql.ast.spi.predicate.NegationPredicate;
import org.hibernate.hql.ast.spi.predicate.PredicateFactory;
import org.hibernate.hql.ast.spi.predicate.RangePredicate;
import org.hibernate.hql.ast.spi.predicate.RootPredicate;
import org.hibernate.hql.internal.util.Strings;
import org.hibernate.hql.lucene.internal.builder.predicate.LuceneComparisonPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.LuceneConjunctionPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.LuceneDisjunctionPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.LuceneInPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.LuceneIsNullPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.LuceneLikePredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.LuceneNegationPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.LuceneRangePredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.LuceneRootPredicate;
import org.hibernate.hql.lucene.spi.FieldBridgeProvider;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.QueryContextBuilder;

public class LucenePredicateFactory
implements PredicateFactory<Query> {
    private final QueryContextBuilder queryContextBuilder;
    private final EntityNamesResolver entityNames;
    private final FieldBridgeProvider fieldBridgeProvider;
    private QueryBuilder queryBuilder;

    public LucenePredicateFactory(QueryContextBuilder queryContextBuilder, EntityNamesResolver entityNames) {
        this(queryContextBuilder, entityNames, null);
    }

    public LucenePredicateFactory(QueryContextBuilder queryContextBuilder, EntityNamesResolver entityNames, FieldBridgeProvider fieldBridgeProvider) {
        this.queryContextBuilder = queryContextBuilder;
        this.entityNames = entityNames;
        this.fieldBridgeProvider = fieldBridgeProvider;
    }

    @Override
    public RootPredicate<Query> getRootPredicate(String entityType) {
        Class<?> targetedType = this.entityNames.getClassFromName(entityType);
        if (targetedType == null) {
            throw new IllegalStateException("Unknown entity name " + entityType);
        }
        this.queryBuilder = this.queryContextBuilder.forEntity(targetedType).get();
        return new LuceneRootPredicate(this.queryBuilder);
    }

    @Override
    public ComparisonPredicate<Query> getComparisonPredicate(String entityType, ComparisonPredicate.Type comparisonType, List<String> propertyPath, Object value) {
        String pathAsString = this.getPathAsString(propertyPath);
        FieldBridge fieldBridge = this.getFieldBridge(entityType, pathAsString);
        return new LuceneComparisonPredicate(this.queryBuilder, fieldBridge, pathAsString, comparisonType, value);
    }

    @Override
    public InPredicate<Query> getInPredicate(String entityType, List<String> propertyPath, List<Object> values) {
        String pathAsString = this.getPathAsString(propertyPath);
        FieldBridge fieldBridge = this.getFieldBridge(entityType, pathAsString);
        return new LuceneInPredicate(this.queryBuilder, fieldBridge, pathAsString, values);
    }

    @Override
    public RangePredicate<Query> getRangePredicate(String entityType, List<String> propertyPath, Object lowerValue, Object upperValue) {
        String pathAsString = this.getPathAsString(propertyPath);
        FieldBridge fieldBridge = this.getFieldBridge(entityType, pathAsString);
        return new LuceneRangePredicate(this.queryBuilder, fieldBridge, pathAsString, lowerValue, upperValue);
    }

    @Override
    public NegationPredicate<Query> getNegationPredicate() {
        return new LuceneNegationPredicate(this.queryBuilder);
    }

    @Override
    public DisjunctionPredicate<Query> getDisjunctionPredicate() {
        return new LuceneDisjunctionPredicate(this.queryBuilder);
    }

    @Override
    public ConjunctionPredicate<Query> getConjunctionPredicate() {
        return new LuceneConjunctionPredicate(this.queryBuilder);
    }

    @Override
    public LikePredicate<Query> getLikePredicate(String entityType, List<String> propertyPath, String patternValue, Character escapeCharacter) {
        String pathAsString = this.getPathAsString(propertyPath);
        FieldBridge fieldBridge = this.getFieldBridge(entityType, pathAsString);
        return new LuceneLikePredicate(this.queryBuilder, fieldBridge, pathAsString, patternValue);
    }

    @Override
    public IsNullPredicate<Query> getIsNullPredicate(String entityType, List<String> propertyPath) {
        String pathAsString = this.getPathAsString(propertyPath);
        FieldBridge fieldBridge = this.getFieldBridge(entityType, pathAsString);
        return new LuceneIsNullPredicate(this.queryBuilder, fieldBridge, pathAsString);
    }

    private String getPathAsString(List<String> propertyPath) {
        return Strings.join(propertyPath, ".");
    }

    private FieldBridge getFieldBridge(String entityType, String pathAsString) {
        return this.fieldBridgeProvider != null ? this.fieldBridgeProvider.getFieldBridge(entityType, pathAsString) : null;
    }
}

