/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import java.io.Serializable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.works.DeleteWorkDelegate;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.store.Workspace;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class ByTermDeleteWorkDelegate
extends DeleteWorkDelegate {
    private static final Log log = LoggerFactory.make();

    ByTermDeleteWorkDelegate(Workspace workspace) {
        super(workspace);
    }

    @Override
    public void performWork(LuceneWork work, IndexWriter writer, IndexingMonitor monitor) {
        Class<?> managedType = work.getEntityClass();
        DocumentBuilderIndexedEntity builder = this.workspace.getDocumentBuilder(managedType);
        Serializable id = work.getId();
        log.tracef("Removing %s#%s by id using an IndexWriter.", (Object)managedType, (Object)id);
        try {
            if (ByTermDeleteWorkDelegate.isIdNumeric(builder)) {
                writer.deleteDocuments(NumericFieldUtils.createExactMatchQuery(builder.getIdKeywordName(), id));
            } else {
                Term idTerm = new Term(builder.getIdKeywordName(), work.getIdInString());
                writer.deleteDocuments(idTerm);
            }
            this.workspace.notifyWorkApplied(work);
        }
        catch (Exception e) {
            String message = "Unable to remove " + managedType + "#" + id + " from index.";
            throw new SearchException(message, e);
        }
    }
}

