/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.filter.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.OpenBitSet;

public class AndDocIdSet
extends DocIdSet {
    private DocIdSet docIdBitSet;
    private final List<DocIdSet> andedDocIdSets;
    private final int maxDocNumber;
    public static final DocIdSet EMPTY_DOCIDSET = new DocIdSet(){

        @Override
        public DocIdSetIterator iterator() {
            return DocIdSetIterator.empty();
        }

        @Override
        public boolean isCacheable() {
            return true;
        }

        @Override
        public Bits bits() {
            return null;
        }
    };

    public AndDocIdSet(List<DocIdSet> andedDocIdSets, int maxDocs) {
        if (andedDocIdSets == null || andedDocIdSets.size() < 2) {
            throw new IllegalArgumentException("To \"and\" some DocIdSet(s) they should be at least 2");
        }
        this.andedDocIdSets = new ArrayList<DocIdSet>(andedDocIdSets);
        this.maxDocNumber = maxDocs;
    }

    @Override
    public DocIdSetIterator iterator() throws IOException {
        return this.buildBitSet().iterator();
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    private synchronized DocIdSet buildBitSet() throws IOException {
        if (this.docIdBitSet != null) {
            return this.docIdBitSet;
        }
        int size = this.andedDocIdSets.size();
        DocIdSetIterator[] iterators = new DocIdSetIterator[size];
        for (int i = 0; i < size; ++i) {
            DocIdSet docIdSet = this.andedDocIdSets.get(i);
            if (docIdSet == null) {
                return EMPTY_DOCIDSET;
            }
            DocIdSetIterator docIdSetIterator = docIdSet.iterator();
            if (docIdSetIterator == null) {
                return EMPTY_DOCIDSET;
            }
            iterators[i] = docIdSetIterator;
        }
        this.andedDocIdSets.clear();
        this.docIdBitSet = this.makeDocIdSetOnAgreedBits(iterators);
        return this.docIdBitSet;
    }

    private DocIdSet makeDocIdSetOnAgreedBits(DocIdSetIterator[] iterators) throws IOException {
        OpenBitSet result = new OpenBitSet(this.maxDocNumber);
        int numberOfIterators = iterators.length;
        int targetPosition = this.findFirstTargetPosition(iterators, result);
        if (targetPosition == Integer.MAX_VALUE) {
            return EMPTY_DOCIDSET;
        }
        int i = 0;
        int votes = 0;
        while (true) {
            DocIdSetIterator iterator = iterators[i];
            int position = ++targetPosition;
            if (!this.iteratorAlreadyOnTargetPosition(targetPosition, iterator)) {
                position = iterator.advance(targetPosition);
            }
            if (position == Integer.MAX_VALUE) {
                return result;
            }
            if (position == targetPosition) {
                if (++votes == numberOfIterators) {
                    result.fastSet(position);
                    votes = 0;
                }
            } else {
                votes = 1;
                targetPosition = position;
            }
            ++i;
            i %= numberOfIterators;
        }
    }

    private boolean iteratorAlreadyOnTargetPosition(int targetPosition, DocIdSetIterator iterator) {
        return iterator.docID() == targetPosition;
    }

    private int findFirstTargetPosition(DocIdSetIterator[] iterators, OpenBitSet result) throws IOException {
        int targetPosition = iterators[0].nextDoc();
        if (targetPosition == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        boolean allIteratorsShareSameFirstTarget = true;
        for (int i = 1; i < iterators.length; ++i) {
            DocIdSetIterator iterator = iterators[i];
            int position = iterator.nextDoc();
            if (position == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (targetPosition == position) continue;
            targetPosition = Math.max(targetPosition, position);
            allIteratorsShareSameFirstTarget = false;
        }
        if (allIteratorsShareSameFirstTarget) {
            result.fastSet(targetPosition);
            ++targetPosition;
        }
        return targetPosition;
    }
}

