/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.avro.impl;

import java.util.Properties;
import org.hibernate.search.engine.service.spi.Startable;
import org.hibernate.search.indexes.serialization.avro.impl.AvroDeserializer;
import org.hibernate.search.indexes.serialization.avro.impl.AvroSerializer;
import org.hibernate.search.indexes.serialization.avro.impl.KnownProtocols;
import org.hibernate.search.indexes.serialization.avro.logging.impl.Log;
import org.hibernate.search.indexes.serialization.spi.Deserializer;
import org.hibernate.search.indexes.serialization.spi.SerializationProvider;
import org.hibernate.search.indexes.serialization.spi.Serializer;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class AvroSerializationProvider
implements SerializationProvider,
Startable {
    private static final Log log = LoggerFactory.make(Log.class);
    private final KnownProtocols protocols;

    public static int getMajorVersion() {
        return 1;
    }

    public static int getMinorVersion() {
        return 1;
    }

    public AvroSerializationProvider() {
        log.serializationProtocol(AvroSerializationProvider.getMajorVersion(), AvroSerializationProvider.getMinorVersion());
        this.protocols = new KnownProtocols();
    }

    @Override
    public void start(Properties properties, BuildContext context) {
    }

    @Override
    public Serializer getSerializer() {
        return new AvroSerializer(this.protocols.getLatestProtocol());
    }

    @Override
    public Deserializer getDeserializer() {
        return new AvroDeserializer(this.protocols);
    }

    public String toString() {
        return "Avro SerializationProvider v" + AvroSerializationProvider.getMajorVersion() + "." + AvroSerializationProvider.getMinorVersion();
    }
}

