/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.infinispan.spi;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.infinispan.impl.AsyncDeleteExecutorService;
import org.hibernate.search.infinispan.logging.impl.Log;
import org.hibernate.search.infinispan.spi.CacheManagerService;
import org.hibernate.search.infinispan.spi.InfinispanIntegration;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.impl.DirectoryProviderHelper;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.infinispan.Cache;
import org.infinispan.lucene.directory.BuildContext;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.manager.EmbeddedCacheManager;

public class InfinispanDirectoryProvider
implements DirectoryProvider<Directory> {
    private static final Log log = LoggerFactory.make(Log.class);
    private ServiceManager serviceManager;
    private String directoryProviderName;
    private String metadataCacheName;
    private String dataCacheName;
    private String lockingCacheName;
    private Integer chunkSize;
    private Directory directory;
    private EmbeddedCacheManager cacheManager;
    private AsyncDeleteExecutorService deletesExecutor;
    private boolean writeFileListAsync;
    private LockFactory indexWriterLockFactory;

    @Override
    public void initialize(String directoryProviderName, Properties properties, org.hibernate.search.spi.BuildContext context) {
        this.directoryProviderName = directoryProviderName;
        this.serviceManager = context.getServiceManager();
        this.cacheManager = this.serviceManager.requestService(CacheManagerService.class).getEmbeddedCacheManager();
        this.metadataCacheName = InfinispanIntegration.getMetadataCacheName(properties);
        this.dataCacheName = InfinispanIntegration.getDataCacheName(properties);
        this.lockingCacheName = InfinispanIntegration.getLockingCacheName(properties);
        this.chunkSize = ConfigurationParseHelper.getIntValue(properties, "chunk_size");
        this.writeFileListAsync = ConfigurationParseHelper.getBooleanValue(properties, "write_metadata_async", false);
        if (DirectoryProviderHelper.configurationExplicitlySetsLockFactory(properties)) {
            File verifiedIndexDir = null;
            if (DirectoryProviderHelper.isNativeLockingStrategy(properties)) {
                verifiedIndexDir = DirectoryProviderHelper.getVerifiedIndexDir(directoryProviderName, properties, true);
            }
            this.indexWriterLockFactory = DirectoryProviderHelper.createLockFactory(verifiedIndexDir, properties, this.serviceManager);
        }
    }

    @Override
    public void start(DirectoryBasedIndexManager indexManager) {
        log.debug("Starting InfinispanDirectory");
        this.deletesExecutor = this.getDeleteOperationsExecutor();
        this.cacheManager.startCaches(new String[]{this.metadataCacheName, this.dataCacheName, this.lockingCacheName});
        Cache metadataCache = this.cacheManager.getCache(this.metadataCacheName);
        Cache dataCache = this.cacheManager.getCache(this.dataCacheName);
        Cache lockingCache = this.cacheManager.getCache(this.lockingCacheName);
        BuildContext directoryBuildContext = DirectoryBuilder.newDirectoryInstance(metadataCache, dataCache, lockingCache, this.directoryProviderName).writeFileListAsynchronously(this.writeFileListAsync).deleteOperationsExecutor(this.deletesExecutor.getExecutor());
        if (this.chunkSize != null) {
            directoryBuildContext.chunkSize(this.chunkSize);
        }
        if (this.indexWriterLockFactory != null) {
            directoryBuildContext.overrideWriteLocker(this.indexWriterLockFactory);
        }
        this.directory = directoryBuildContext.create();
        DirectoryProviderHelper.initializeIndexIfNeeded(this.directory);
        log.debugf("Initialized Infinispan index: '%s'", (Object)this.directoryProviderName);
    }

    private AsyncDeleteExecutorService getDeleteOperationsExecutor() {
        return this.serviceManager.requestService(AsyncDeleteExecutorService.class);
    }

    @Override
    public void stop() {
        this.deletesExecutor.closeAndFlush();
        this.serviceManager.releaseService(AsyncDeleteExecutorService.class);
        try {
            this.directory.close();
        }
        catch (IOException e) {
            log.unableToCloseLuceneDirectory(this.directory, e);
        }
        this.serviceManager.releaseService(CacheManagerService.class);
        log.debug("Stopped InfinispanDirectory");
    }

    @Override
    public Directory getDirectory() {
        return this.directory;
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }
}

