/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.collector.impl;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Collector;
import org.hibernate.search.query.collector.impl.FieldCacheCollector;
import org.hibernate.search.query.fieldcache.impl.FieldLoadingStrategy;

final class BigArrayFieldCacheCollectorImpl
extends FieldCacheCollector {
    private final Object[] valuePerDocumentId;
    private int currentDocBase;
    private final FieldLoadingStrategy cacheLoadingStrategy;

    public BigArrayFieldCacheCollectorImpl(Collector delegate, FieldLoadingStrategy cacheLoadingStrategy, Object[] valueContainer) {
        super(delegate);
        this.cacheLoadingStrategy = cacheLoadingStrategy;
        this.valuePerDocumentId = valueContainer;
    }

    @Override
    public void collect(int doc) throws IOException {
        this.delegate.collect(doc);
        this.valuePerDocumentId[this.currentDocBase + doc] = this.cacheLoadingStrategy.collect(doc);
    }

    @Override
    public void setNextReader(AtomicReaderContext context) throws IOException {
        this.currentDocBase = context.docBase;
        this.cacheLoadingStrategy.loadNewCacheValues(context);
        this.delegate.setNextReader(context);
    }

    @Override
    public Object getValue(int docId) {
        return this.valuePerDocumentId[docId];
    }
}

