/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.engine.impl;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;

public final class ReusableDocumentStoredFieldVisitor
extends StoredFieldVisitor {
    private static final FieldAcceptor NOT_ACCEPT = new DenyingFieldAcceptor();
    private final FieldAcceptor rootAcceptor;
    private final int totalFields;
    private Document doc = null;
    private int missingFields;

    public ReusableDocumentStoredFieldVisitor(Set<String> fieldsToLoad) {
        FieldAcceptor previous = NOT_ACCEPT;
        for (String fieldName : fieldsToLoad) {
            previous = new ChainedFieldAcceptor(previous, fieldName);
        }
        this.rootAcceptor = previous;
        this.missingFields = this.totalFields = fieldsToLoad.size();
    }

    @Override
    public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
        this.getDocument().add(new StoredField(fieldInfo.name, value));
    }

    @Override
    public void stringField(FieldInfo fieldInfo, String value) throws IOException {
        FieldType ft = new FieldType(TextField.TYPE_STORED);
        ft.setStoreTermVectors(fieldInfo.hasVectors());
        ft.setIndexed(fieldInfo.isIndexed());
        ft.setOmitNorms(fieldInfo.omitsNorms());
        ft.setIndexOptions(fieldInfo.getIndexOptions());
        this.getDocument().add(new Field(fieldInfo.name, value, ft));
    }

    @Override
    public void intField(FieldInfo fieldInfo, int value) {
        this.getDocument().add(new StoredField(fieldInfo.name, value));
    }

    @Override
    public void longField(FieldInfo fieldInfo, long value) {
        this.getDocument().add(new StoredField(fieldInfo.name, value));
    }

    @Override
    public void floatField(FieldInfo fieldInfo, float value) {
        this.getDocument().add(new StoredField(fieldInfo.name, value));
    }

    @Override
    public void doubleField(FieldInfo fieldInfo, double value) {
        this.getDocument().add(new StoredField(fieldInfo.name, value));
    }

    @Override
    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
        if (this.missingFields == 0) {
            return StoredFieldVisitor.Status.STOP;
        }
        StoredFieldVisitor.Status s = this.rootAcceptor.acceptField(fieldInfo.name);
        if (s == StoredFieldVisitor.Status.YES) {
            --this.missingFields;
        }
        return s;
    }

    public int countAcceptedFields() {
        FieldAcceptor acceptor = this.rootAcceptor;
        int count = 0;
        while (acceptor != NOT_ACCEPT) {
            ChainedFieldAcceptor positiveAcceptor = (ChainedFieldAcceptor)acceptor;
            acceptor = positiveAcceptor.next;
            ++count;
        }
        return count;
    }

    public Document getDocumentAndReset() {
        Document localDoc = this.doc;
        if (localDoc == null) {
            return new Document();
        }
        this.doc = null;
        this.missingFields = this.totalFields;
        return localDoc;
    }

    private Document getDocument() {
        Document localDoc = this.doc;
        if (localDoc == null) {
            this.doc = localDoc = new Document();
        }
        return localDoc;
    }

    private static final class ChainedFieldAcceptor
    implements FieldAcceptor {
        final FieldAcceptor next;
        final String acceptedFieldName;

        ChainedFieldAcceptor(FieldAcceptor next, String acceptedFieldName) {
            this.next = next;
            this.acceptedFieldName = acceptedFieldName;
        }

        @Override
        public StoredFieldVisitor.Status acceptField(String fieldName) {
            if (this.acceptedFieldName.equals(fieldName)) {
                return StoredFieldVisitor.Status.YES;
            }
            return this.next.acceptField(fieldName);
        }
    }

    private static final class DenyingFieldAcceptor
    implements FieldAcceptor {
        private DenyingFieldAcceptor() {
        }

        @Override
        public StoredFieldVisitor.Status acceptField(String fieldName) {
            return StoredFieldVisitor.Status.NO;
        }
    }

    private static interface FieldAcceptor {
        public StoredFieldVisitor.Status acceptField(String var1);
    }
}

