/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredDocIdSet;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.util.Bits;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.spatial.impl.SpatialHelper;

public final class DistanceFilter
extends Filter {
    private Filter previousFilter;
    private Point center;
    private double radius;
    private String coordinatesField;
    private String latitudeField;
    private String longitudeField;

    public DistanceFilter(Filter previousFilter, Coordinates centerCoordinates, double radius, String coordinatesField) {
        this.previousFilter = previousFilter != null ? previousFilter : new QueryWrapperFilter(new MatchAllDocsQuery());
        this.center = Point.fromCoordinates(centerCoordinates);
        this.radius = radius;
        this.coordinatesField = coordinatesField;
    }

    public DistanceFilter(Filter previousFilter, Coordinates centerCoordinates, double radius, String latitudeField, String longitudeField) {
        this.previousFilter = previousFilter != null ? previousFilter : new QueryWrapperFilter(new MatchAllDocsQuery());
        this.center = Point.fromCoordinates(centerCoordinates);
        this.radius = radius;
        this.coordinatesField = null;
        this.latitudeField = latitudeField;
        this.longitudeField = longitudeField;
    }

    @Override
    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        AtomicReader atomicReader = context.reader();
        final FieldCache.Doubles latitudeValues = FieldCache.DEFAULT.getDoubles(atomicReader, this.getLatitudeField(), false);
        final FieldCache.Doubles longitudeValues = FieldCache.DEFAULT.getDoubles(atomicReader, this.getLongitudeField(), false);
        DocIdSet docs = this.previousFilter.getDocIdSet(context, acceptDocs);
        if (docs == null || docs.iterator() == null) {
            return null;
        }
        return new FilteredDocIdSet(docs){

            @Override
            protected boolean match(int documentIndex) {
                return DistanceFilter.this.center.getDistanceTo(latitudeValues.get(documentIndex), longitudeValues.get(documentIndex)) <= DistanceFilter.this.radius;
            }
        };
    }

    private String getLatitudeField() {
        if (this.latitudeField != null) {
            return this.latitudeField;
        }
        return SpatialHelper.formatLatitude(this.coordinatesField);
    }

    private String getLongitudeField() {
        if (this.longitudeField != null) {
            return this.longitudeField;
        }
        return SpatialHelper.formatLongitude(this.coordinatesField);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DistanceFilter");
        sb.append("{previousFilter=").append(this.previousFilter);
        sb.append(", center=").append(this.center);
        sb.append(", radius=").append(this.radius);
        if (this.coordinatesField != null) {
            sb.append(", coordinatesField='").append(this.coordinatesField).append('\'');
        } else {
            sb.append(", latitudeField=").append(this.latitudeField);
            sb.append(", longitudeField=").append(this.longitudeField).append('\'');
        }
        sb.append('}');
        return sb.toString();
    }
}

