/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.OpenBitSet;

public final class SpatialHashFilter
extends Filter {
    private final List<String> spatialHashCellsIds;
    private final String fieldName;

    public SpatialHashFilter(List<String> spatialHashCellsIds, String fieldName) {
        this.spatialHashCellsIds = spatialHashCellsIds;
        this.fieldName = fieldName;
    }

    @Override
    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        if (this.spatialHashCellsIds.size() == 0) {
            return null;
        }
        AtomicReader atomicReader = context.reader();
        OpenBitSet matchedDocumentsIds = new OpenBitSet(atomicReader.maxDoc());
        Boolean found = false;
        for (int i = 0; i < this.spatialHashCellsIds.size(); ++i) {
            int docId;
            Term spatialHashCellTerm = new Term(this.fieldName, this.spatialHashCellsIds.get(i));
            DocsEnum spatialHashCellsDocs = atomicReader.termDocsEnum(spatialHashCellTerm);
            if (spatialHashCellsDocs == null) continue;
            while ((docId = spatialHashCellsDocs.nextDoc()) != Integer.MAX_VALUE) {
                if (acceptDocs != null && !acceptDocs.get(docId)) continue;
                matchedDocumentsIds.fastSet(docId);
                found = true;
            }
        }
        if (found.booleanValue()) {
            return matchedDocumentsIds;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SpatialHashFilter");
        sb.append("{spatialHashCellsIds=").append(this.spatialHashCellsIds);
        sb.append(", fieldName='").append(this.fieldName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

