/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store.impl;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.impl.DirectoryProviderHelper;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.impl.FileHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class FSSlaveDirectoryProvider
implements DirectoryProvider<Directory> {
    private static final Log log = LoggerFactory.make();
    private final Timer timer = new Timer(true);
    private volatile boolean initialized = false;
    private volatile boolean started = false;
    private volatile int current;
    private volatile Directory dummyDirectory;
    private FSDirectory directory1;
    private FSDirectory directory2;
    private String indexName;
    private long copyChunkSize;
    private File sourceIndexDir;
    private File indexDir;
    private String directoryProviderName;
    private Properties properties;
    private UpdateTask updateTask;
    private ServiceManager serviceManager;

    @Override
    public void initialize(String directoryProviderName, Properties properties, BuildContext context) {
        this.properties = properties;
        this.directoryProviderName = directoryProviderName;
        this.serviceManager = context.getServiceManager();
        this.sourceIndexDir = DirectoryProviderHelper.getSourceDirectory(directoryProviderName, properties, false);
        log.debugf("Source directory: %s", (Object)this.sourceIndexDir.getPath());
        this.indexDir = DirectoryProviderHelper.getVerifiedIndexDir(directoryProviderName, properties, true);
        log.debugf("Index directory: %s", (Object)this.indexDir.getPath());
        try {
            this.indexName = this.indexDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new SearchException("Unable to initialize index: " + directoryProviderName, e);
        }
        this.copyChunkSize = DirectoryProviderHelper.getCopyBufferSize(directoryProviderName, properties);
        this.current = 0;
    }

    private boolean currentMarkerIsInSource() {
        int retry = ConfigurationParseHelper.getIntValue(this.properties, "retry_marker_lookup", 0);
        if (retry < 0) {
            throw new SearchException("retry_marker_lookup option must be a positive integer, but was \"" + retry + "\"");
        }
        boolean currentMarkerInSource = false;
        for (int tried = 0; tried <= retry; ++tried) {
            if (tried > 0) {
                try {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            boolean bl = currentMarkerInSource = new File(this.sourceIndexDir, "current1").exists() || new File(this.sourceIndexDir, "current2").exists();
            if (currentMarkerInSource) break;
        }
        return currentMarkerInSource;
    }

    @Override
    public void start(DirectoryBasedIndexManager indexManager) {
        if (!this.attemptInitializeAndStart()) {
            long period = DirectoryProviderHelper.getRetryInitializePeriod(this.properties, this.directoryProviderName);
            if (period != 0L) {
                this.scheduleTask(new InitTask(), period);
            } else {
                throw new SearchException("Failed to initialize DirectoryProvider \"" + this.directoryProviderName + "\": could not find marker file in index source");
            }
        }
    }

    private void startIt() {
        int readCurrentState = this.current;
        int currentToBe = 0;
        try {
            this.directory1 = DirectoryProviderHelper.createFSIndex(new File(this.indexDir, "1"), this.properties, this.serviceManager);
            this.directory2 = DirectoryProviderHelper.createFSIndex(new File(this.indexDir, "2"), this.properties, this.serviceManager);
            File currentMarker = new File(this.indexDir, "current1");
            File current2Marker = new File(this.indexDir, "current2");
            if (currentMarker.exists()) {
                currentToBe = 1;
                if (current2Marker.exists()) {
                    current2Marker.delete();
                }
            } else if (current2Marker.exists()) {
                currentToBe = 2;
            } else {
                int sourceCurrent;
                log.debug("Setting directory 1 as current");
                currentToBe = 1;
                File destinationFile = new File(this.indexDir, Integer.valueOf(currentToBe).toString());
                if (new File(this.sourceIndexDir, "current1").exists()) {
                    sourceCurrent = 1;
                } else if (new File(this.sourceIndexDir, "current2").exists()) {
                    sourceCurrent = 2;
                } else {
                    throw new SearchException("No current file marker found in source directory: " + this.sourceIndexDir.getPath());
                }
                try {
                    FileHelper.synchronize(new File(this.sourceIndexDir, String.valueOf(sourceCurrent)), destinationFile, true, this.copyChunkSize);
                }
                catch (IOException e) {
                    throw new SearchException("Unable to synchronize directory: " + this.indexName, e);
                }
                if (!currentMarker.createNewFile()) {
                    throw new SearchException("Unable to create the directory marker file: " + this.indexName);
                }
            }
            log.debugf("Current directory: %d", (Object)currentToBe);
        }
        catch (IOException e) {
            throw new SearchException("Unable to initialize index: " + this.directoryProviderName, e);
        }
        this.updateTask = new UpdateTask(this.sourceIndexDir, this.indexDir);
        long period = DirectoryProviderHelper.getRefreshPeriod(this.properties, this.directoryProviderName);
        this.scheduleTask(this.updateTask, period);
        this.current = currentToBe;
        this.started = true;
    }

    @Override
    public Directory getDirectory() {
        if (!this.started) {
            if (this.dummyDirectory == null) {
                RAMDirectory directory = new RAMDirectory();
                DirectoryProviderHelper.initializeIndexIfNeeded(directory);
                this.dummyDirectory = directory;
            }
            return this.dummyDirectory;
        }
        int readState = this.current;
        if (readState == 1) {
            return this.directory1;
        }
        if (readState == 2) {
            return this.directory2;
        }
        throw new AssertionFailure("Illegal current directory: " + readState);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof FSSlaveDirectoryProvider)) {
            return false;
        }
        FSSlaveDirectoryProvider other = (FSSlaveDirectoryProvider)obj;
        int readCurrentState = this.current;
        readCurrentState = other.current;
        return this.indexName.equals(other.indexName);
    }

    public int hashCode() {
        int readCurrentState = this.current;
        int hash = 11;
        return 37 * hash + this.indexName.hashCode();
    }

    protected synchronized boolean attemptInitializeAndStart() {
        if (!this.initialized) {
            if (this.currentMarkerIsInSource()) {
                this.initialized = true;
                log.foundCurrentMarker();
            } else {
                log.noCurrentMarkerInSourceDirectory();
            }
        }
        if (this.initialized) {
            this.startIt();
        }
        return this.started;
    }

    @Override
    public void stop() {
        int readCurrentState = this.current;
        this.timer.cancel();
        if (this.updateTask != null) {
            this.updateTask.stop();
        }
        this.closeDirectory(this.directory1);
        this.closeDirectory(this.directory2);
    }

    private void closeDirectory(Directory directory) {
        if (directory != null) {
            try {
                directory.close();
            }
            catch (Exception e) {
                log.unableToCloseLuceneDirectory(directory, e);
            }
        }
    }

    protected void scheduleTask(TimerTask task, long period) {
        this.timer.schedule(task, period, period);
    }

    class CopyDirectory
    implements Runnable {
        private final File source;
        private final File destination;
        private final AtomicBoolean inProgress = new AtomicBoolean(false);

        public CopyDirectory(File sourceIndexDir, File destination) {
            this.source = sourceIndexDir;
            this.destination = destination;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long start = System.nanoTime();
            try {
                File sourceFile = this.determineCurrentSourceFile();
                if (sourceFile == null) {
                    log.unableToDetermineCurrentInSourceDirectory();
                    return;
                }
                File currentDestinationFile = new File(this.destination, Integer.valueOf(FSSlaveDirectoryProvider.this.current).toString());
                try {
                    if (FileHelper.areInSync(sourceFile, currentDestinationFile)) {
                        if (log.isTraceEnabled()) {
                            log.trace("Source and destination directory are in sync. No copying required.");
                        }
                        return;
                    }
                }
                catch (IOException ioe) {
                    log.unableToCompareSourceWithDestinationDirectory(sourceFile.getName(), currentDestinationFile.getName());
                }
                int oldIndex = FSSlaveDirectoryProvider.this.current;
                int index = oldIndex == 1 ? 2 : 1;
                File destinationFile = new File(this.destination, Integer.valueOf(index).toString());
                try {
                    log.tracef("Copying %s into %s", (Object)sourceFile, (Object)destinationFile);
                    FileHelper.synchronize(sourceFile, destinationFile, true, FSSlaveDirectoryProvider.this.copyChunkSize);
                    FSSlaveDirectoryProvider.this.current = index;
                    log.tracef("Copy for %s took %d ms", (Object)FSSlaveDirectoryProvider.this.indexName, (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
                }
                catch (IOException e) {
                    log.unableToSynchronizeSource(FSSlaveDirectoryProvider.this.indexName, e);
                    this.inProgress.set(false);
                    return;
                }
                if (!new File(FSSlaveDirectoryProvider.this.indexName, "current" + oldIndex).delete()) {
                    log.unableToRemovePreviousMarket(FSSlaveDirectoryProvider.this.indexName);
                }
                try {
                    new File(FSSlaveDirectoryProvider.this.indexName, "current" + index).createNewFile();
                }
                catch (IOException e) {
                    log.unableToCreateCurrentMarker(FSSlaveDirectoryProvider.this.indexName, e);
                }
            }
            finally {
                this.inProgress.set(false);
            }
        }

        private File determineCurrentSourceFile() {
            File sourceFile = null;
            if (new File(this.source, "current1").exists()) {
                sourceFile = new File(this.source, "1");
            } else if (new File(this.source, "current2").exists()) {
                sourceFile = new File(this.source, "2");
            }
            return sourceFile;
        }
    }

    class UpdateTask
    extends TimerTask {
        private final ExecutorService executor = Executors.newSingleThreadExecutor();
        private final CopyDirectory copyTask;

        public UpdateTask(File sourceIndexDir, File destination) {
            this.copyTask = new CopyDirectory(sourceIndexDir, destination);
        }

        @Override
        public void run() {
            if (this.copyTask.inProgress.compareAndSet(false, true)) {
                this.executor.execute(this.copyTask);
            } else if (log.isTraceEnabled()) {
                int unneeded = FSSlaveDirectoryProvider.this.current;
                log.tracef("Skipping directory synchronization, previous work still in progress: %s", (Object)FSSlaveDirectoryProvider.this.indexName);
            }
        }

        public void stop() {
            this.executor.shutdownNow();
        }
    }

    class InitTask
    extends TimerTask {
        InitTask() {
        }

        @Override
        public void run() {
            try {
                if (FSSlaveDirectoryProvider.this.attemptInitializeAndStart()) {
                    this.cancel();
                }
            }
            catch (RuntimeException re) {
                log.failedSlaveDirectoryProviderInitialization(FSSlaveDirectoryProvider.this.indexName, re);
            }
        }
    }
}

