/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.Executor;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.infinispan.Cache;
import org.infinispan.lucene.impl.DirectoryExtensions;
import org.infinispan.lucene.impl.DirectoryImplementor;
import org.infinispan.lucene.impl.IndexInputContext;
import org.infinispan.lucene.impl.InfinispanIndexInput;
import org.infinispan.lucene.impl.SingleChunkIndexInput;
import org.infinispan.lucene.readlocks.SegmentReadLocker;

class DirectoryLuceneV4
extends Directory
implements DirectoryExtensions {
    private final DirectoryImplementor impl;
    private final String indexName;
    private final Executor deleteExecutor;
    private volatile LockFactory lockFactory;

    public DirectoryLuceneV4(Cache<?, ?> metadataCache, Cache<?, ?> chunksCache, String indexName, LockFactory lf, int chunkSize, SegmentReadLocker readLocker, boolean fileListUpdatedAsync, Executor deleteExecutor) {
        this.deleteExecutor = deleteExecutor;
        this.impl = new DirectoryImplementor(metadataCache, chunksCache, indexName, chunkSize, readLocker, fileListUpdatedAsync);
        this.indexName = indexName;
        this.lockFactory = lf;
        this.lockFactory.setLockPrefix(this.getLockID());
    }

    @Override
    public boolean fileExists(String name) {
        this.ensureOpen();
        return this.impl.fileExists(name);
    }

    @Override
    public void deleteFile(String name) {
        this.ensureOpen();
        this.deleteExecutor.execute(new DeleteTask(name));
    }

    @Override
    public void renameFile(String from, String to) {
        this.impl.renameFile(from, to);
    }

    @Override
    public long fileLength(String name) {
        this.ensureOpen();
        return this.impl.fileLength(name);
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        return this.impl.createOutput(name);
    }

    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        IndexInputContext indexInputContext = this.impl.openInput(name);
        if (indexInputContext.readLocks == null) {
            return new SingleChunkIndexInput(indexInputContext);
        }
        return new InfinispanIndexInput(indexInputContext);
    }

    @Override
    public void close() {
    }

    @Override
    public String toString() {
        return "InfinispanDirectory{indexName='" + this.indexName + "'}";
    }

    @Override
    public String[] listAll() {
        return this.impl.list();
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public void sync(Collection<String> names) throws IOException {
    }

    @Override
    public void clearLock(String lockName) throws IOException {
        this.lockFactory.clearLock(lockName);
    }

    @Override
    public LockFactory getLockFactory() {
        return this.lockFactory;
    }

    @Override
    public Lock makeLock(String lockName) {
        return this.lockFactory.makeLock(lockName);
    }

    @Override
    public void setLockFactory(LockFactory lockFactory) throws IOException {
        this.lockFactory = lockFactory;
    }

    @Override
    public int getChunkSize() {
        return this.impl.getChunkSize();
    }

    @Override
    public Cache getMetadataCache() {
        return this.impl.getMetadataCache();
    }

    @Override
    public Cache getDataCache() {
        return this.impl.getDataCache();
    }

    final class DeleteTask
    implements Runnable {
        private final String fileName;

        private DeleteTask(String fileName) {
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }

        @Override
        public void run() {
            DirectoryLuceneV4.this.impl.deleteFile(this.fileName);
        }
    }
}

