/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.util.CloseableIterable;
import org.infinispan.filter.Converter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.objectfilter.Matcher;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.embedded.impl.FilterAndConverter;

public final class EmbeddedQuery
implements Query {
    private static final int INITIAL_CAPACITY = 1000;
    private final AdvancedCache<?, ?> cache;
    private final FilterAndConverter filter;
    private List results;
    private int resultSize;
    private final String[] projection;
    private final int startOffset;
    private final int maxResults;

    public EmbeddedQuery(AdvancedCache<?, ?> cache, String jpaQuery, long startOffset, int maxResults, Class<? extends Matcher> matcherImplClass) {
        this.cache = cache;
        this.startOffset = startOffset < 0L ? 0 : (int)startOffset;
        this.maxResults = maxResults;
        this.filter = new FilterAndConverter(jpaQuery, matcherImplClass);
        this.filter.injectDependencies((Cache)cache);
        this.projection = this.filter.getObjectFilter().getProjection();
    }

    public String[] getProjection() {
        return this.projection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> list() {
        if (this.results == null) {
            CloseableIterable iterable = this.cache.filterEntries((KeyValueFilter)this.filter).converter((Converter)this.filter);
            Comparator<Comparable[]> comparator = this.filter.getObjectFilter().getComparator();
            if (comparator == null) {
                this.results = new ArrayList(1000);
                try {
                    for (Map.Entry entry : iterable) {
                        ++this.resultSize;
                        if (this.resultSize <= this.startOffset || this.maxResults != -1 && this.results.size() >= this.maxResults) continue;
                        ObjectFilter.FilterResult r = (ObjectFilter.FilterResult)entry.getValue();
                        this.results.add(this.projection != null ? r.getProjection() : r.getInstance());
                    }
                }
                finally {
                    try {
                        iterable.close();
                    }
                    catch (Exception e) {}
                }
            }
            PriorityQueue<ObjectFilter.FilterResult> filterResults = new PriorityQueue<ObjectFilter.FilterResult>(1000, new ReverseFilterResultComparator(comparator));
            try {
                for (Map.Entry entry : iterable) {
                    ++this.resultSize;
                    filterResults.add((ObjectFilter.FilterResult)entry.getValue());
                    if (this.maxResults == -1 || filterResults.size() <= this.startOffset + this.maxResults) continue;
                    filterResults.remove();
                }
            }
            finally {
                try {
                    iterable.close();
                }
                catch (Exception e) {}
            }
            if (filterResults.size() > this.startOffset) {
                Object[] res = new Object[filterResults.size() - this.startOffset];
                int i = filterResults.size();
                while (i-- > this.startOffset) {
                    ObjectFilter.FilterResult r = (ObjectFilter.FilterResult)filterResults.remove();
                    res[i - this.startOffset] = this.projection != null ? r.getProjection() : r.getInstance();
                }
                this.results = Arrays.asList(res);
            } else {
                this.results = Collections.emptyList();
            }
        }
        return this.results;
    }

    @Override
    public int getResultSize() {
        this.list();
        return this.resultSize;
    }

    private static class ReverseFilterResultComparator
    implements Comparator<ObjectFilter.FilterResult> {
        private final Comparator<Comparable[]> comparator;

        private ReverseFilterResultComparator(Comparator<Comparable[]> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(ObjectFilter.FilterResult o1, ObjectFilter.FilterResult o2) {
            return -this.comparator.compare(o1.getSortProjection(), o2.getSortProjection());
        }
    }
}

