/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.Map;
import java.util.Set;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.commons.util.concurrent.jdk8backported.LongAdder;
import org.infinispan.query.impl.InfinispanQueryStatisticsInfoMBean;

public class InfinispanQueryStatisticsInfo
implements InfinispanQueryStatisticsInfoMBean {
    private final SearchIntegrator sf;
    private final LongAdder searchQueryExecutionCount = new LongAdder();
    private final LongAdder searchQueryTotalTime = new LongAdder();
    private volatile long searchQueryExecutionMaxTime = 0L;
    private volatile String searchQueryExecutionMaxTimeQueryString = null;
    private final LongAdder objectLoadingTotalTime = new LongAdder();
    private volatile long objectLoadingExecutionMaxTime = 0L;
    private final LongAdder objectLoadedCount = new LongAdder();

    public InfinispanQueryStatisticsInfo(SearchIntegrator sf) {
        this.sf = sf;
    }

    @Override
    public void clear() {
        this.searchQueryExecutionCount.reset();
        this.searchQueryTotalTime.reset();
        this.searchQueryExecutionMaxTime = 0L;
        this.searchQueryExecutionMaxTimeQueryString = null;
        this.objectLoadingTotalTime.reset();
        this.objectLoadingExecutionMaxTime = 0L;
        this.objectLoadedCount.reset();
        this.sf.getStatistics().clear();
    }

    @Override
    public long getSearchQueryExecutionCount() {
        this.searchQueryExecutionCount.add(this.sf.getStatistics().getSearchQueryExecutionCount());
        return this.searchQueryExecutionCount.sum();
    }

    @Override
    public long getSearchQueryTotalTime() {
        this.searchQueryTotalTime.add(this.sf.getStatistics().getSearchQueryTotalTime());
        return this.searchQueryTotalTime.sum();
    }

    @Override
    public long getSearchQueryExecutionMaxTime() {
        long temp = this.sf.getStatistics().getSearchQueryExecutionMaxTime();
        if (this.searchQueryExecutionMaxTime < temp) {
            this.searchQueryExecutionMaxTime = temp;
        }
        return this.searchQueryExecutionMaxTime;
    }

    @Override
    public long getSearchQueryExecutionAvgTime() {
        long count = this.getSearchQueryExecutionCount();
        if (count == 0L) {
            return 0L;
        }
        return this.getSearchQueryTotalTime() / count;
    }

    @Override
    public String getSearchQueryExecutionMaxTimeQueryString() {
        String temp = this.sf.getStatistics().getSearchQueryExecutionMaxTimeQueryString();
        if (temp != null) {
            this.searchQueryExecutionMaxTimeQueryString = temp;
        }
        return this.searchQueryExecutionMaxTimeQueryString;
    }

    @Override
    public long getObjectLoadingTotalTime() {
        this.objectLoadingTotalTime.add(this.sf.getStatistics().getObjectLoadingTotalTime());
        return this.objectLoadingTotalTime.sum();
    }

    @Override
    public long getObjectLoadingExecutionMaxTime() {
        long temp = this.sf.getStatistics().getObjectLoadingExecutionMaxTime();
        if (this.objectLoadingExecutionMaxTime < temp) {
            this.objectLoadingExecutionMaxTime = temp;
        }
        return this.objectLoadingExecutionMaxTime;
    }

    @Override
    public long getObjectLoadingExecutionAvgTime() {
        long count = this.getObjectsLoadedCount();
        if (count == 0L) {
            return 0L;
        }
        return this.getObjectLoadingTotalTime() / count;
    }

    @Override
    public long getObjectsLoadedCount() {
        this.objectLoadedCount.add(this.sf.getStatistics().getObjectsLoadedCount());
        return this.objectLoadedCount.sum();
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.sf.getStatistics().isStatisticsEnabled();
    }

    @Override
    public void setStatisticsEnabled(boolean isStatisticsEnabled) {
        this.sf.getStatistics().setStatisticsEnabled(isStatisticsEnabled);
    }

    @Override
    public String getSearchVersion() {
        return this.sf.getStatistics().getSearchVersion();
    }

    @Override
    public Set<String> getIndexedClassNames() {
        return this.sf.getStatistics().getIndexedClassNames();
    }

    @Override
    public int getNumberOfIndexedEntities(String entity) {
        return this.sf.getStatistics().getNumberOfIndexedEntities(entity);
    }

    @Override
    public Map<String, Integer> indexedEntitiesCount() {
        return this.sf.getStatistics().indexedEntitiesCount();
    }
}

