/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.massindex;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.infinispan.query.logging.Log;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.LogFactory;

public class DefaultMassIndexerProgressMonitor
implements MassIndexerProgressMonitor {
    private static final Log log = (Log)LogFactory.getLog(DefaultMassIndexerProgressMonitor.class, Log.class);
    private final AtomicLong documentsDoneCounter = new AtomicLong();
    private volatile long startTime;
    private final int logAfterNumberOfDocuments;
    private final TimeService timeService;

    public DefaultMassIndexerProgressMonitor(TimeService timeService) {
        this(50, timeService);
    }

    public DefaultMassIndexerProgressMonitor(int logAfterNumberOfDocuments, TimeService timeService) {
        this.logAfterNumberOfDocuments = logAfterNumberOfDocuments;
        this.timeService = timeService;
    }

    @Override
    public void entitiesLoaded(int size) {
    }

    @Override
    public void documentsAdded(long increment) {
        long current = this.documentsDoneCounter.addAndGet(increment);
        if (current == increment) {
            this.startTime = this.timeService.time();
        }
        if (current % (long)this.getStatusMessagePeriod() == 0L) {
            this.printStatusMessage(this.startTime, current);
        }
    }

    @Override
    public void documentsBuilt(int number) {
    }

    @Override
    public void addToTotalCount(long count) {
    }

    @Override
    public void indexingCompleted() {
        log.indexingEntitiesCompleted(this.documentsDoneCounter.get());
    }

    protected int getStatusMessagePeriod() {
        return this.logAfterNumberOfDocuments;
    }

    protected void printStatusMessage(long startTime, long doneCount) {
        log.indexingDocumentsCompleted(doneCount, this.timeService.timeDuration(startTime, TimeUnit.MILLISECONDS));
    }
}

