/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexmanager;

import java.io.Serializable;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.FlushLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.backend.impl.WorkVisitor;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.indexmanager.LuceneWorkIdTransformer;

public class LuceneWorkTransformationVisitor
implements WorkVisitor<LuceneWorkIdTransformer> {
    static final LuceneWorkTransformationVisitor INSTANCE = new LuceneWorkTransformationVisitor();
    private static final LuceneWorkIdTransformer<AddLuceneWork> addDuplicator = new AddWorkDuplicator();
    private static final LuceneWorkIdTransformer<DeleteLuceneWork> deleteDuplicator = new DeleteWorkDuplicator();
    private static final LuceneWorkIdTransformer<UpdateLuceneWork> updateDuplicator = new UpdateWorkDuplicator();
    private static final LuceneWorkIdTransformer<LuceneWork> returnSameDuplicator = new NotReallyDuplicator();

    private LuceneWorkTransformationVisitor() {
    }

    @Override
    public LuceneWorkIdTransformer getDelegate(AddLuceneWork addLuceneWork) {
        return addDuplicator;
    }

    @Override
    public LuceneWorkIdTransformer getDelegate(DeleteLuceneWork deleteLuceneWork) {
        return deleteDuplicator;
    }

    @Override
    public LuceneWorkIdTransformer getDelegate(UpdateLuceneWork updateLuceneWork) {
        return updateDuplicator;
    }

    @Override
    public LuceneWorkIdTransformer getDelegate(OptimizeLuceneWork optimizeLuceneWork) {
        return returnSameDuplicator;
    }

    @Override
    public LuceneWorkIdTransformer getDelegate(FlushLuceneWork flushLuceneWork) {
        return returnSameDuplicator;
    }

    @Override
    public LuceneWorkIdTransformer getDelegate(PurgeAllLuceneWork purgeAllLuceneWork) {
        return returnSameDuplicator;
    }

    private static class NotReallyDuplicator
    implements LuceneWorkIdTransformer<LuceneWork> {
        private NotReallyDuplicator() {
        }

        @Override
        public LuceneWork cloneOverridingIdString(LuceneWork lw, KeyTransformationHandler keyTransformationHandler) {
            return lw;
        }
    }

    private static class DeleteWorkDuplicator
    implements LuceneWorkIdTransformer<DeleteLuceneWork> {
        private DeleteWorkDuplicator() {
        }

        @Override
        public DeleteLuceneWork cloneOverridingIdString(DeleteLuceneWork lw, KeyTransformationHandler keyTransformationHandler) {
            Serializable id = lw.getId();
            if (id == null) {
                String idInString = lw.getIdInString();
                return new DeleteLuceneWork((Serializable)((Object)idInString), idInString, lw.getEntityClass());
            }
            return lw;
        }
    }

    private static class UpdateWorkDuplicator
    implements LuceneWorkIdTransformer<UpdateLuceneWork> {
        private UpdateWorkDuplicator() {
        }

        @Override
        public UpdateLuceneWork cloneOverridingIdString(UpdateLuceneWork lw, KeyTransformationHandler keyTransformationHandler) {
            Serializable id = lw.getId();
            if (id == null) {
                String idInString = lw.getIdInString();
                return new UpdateLuceneWork((Serializable)((Object)idInString), idInString, lw.getEntityClass(), lw.getDocument(), lw.getFieldToAnalyzerMap());
            }
            return lw;
        }
    }

    private static class AddWorkDuplicator
    implements LuceneWorkIdTransformer<AddLuceneWork> {
        private AddWorkDuplicator() {
        }

        @Override
        public AddLuceneWork cloneOverridingIdString(AddLuceneWork lw, KeyTransformationHandler keyTransformationHandler) {
            Serializable id = lw.getId();
            if (id == null) {
                String idInString = lw.getIdInString();
                return new AddLuceneWork((Serializable)((Object)idInString), idInString, lw.getEntityClass(), lw.getDocument(), lw.getFieldToAnalyzerMap());
            }
            return lw;
        }
    }
}

