/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.logging;

import infinispan.org.jboss.logging.Logger;
import infinispan.org.jboss.logging.annotations.Cause;
import infinispan.org.jboss.logging.annotations.LogMessage;
import infinispan.org.jboss.logging.annotations.Message;
import infinispan.org.jboss.logging.annotations.MessageLogger;
import java.io.IOException;
import java.util.List;
import org.hibernate.search.backend.LuceneWork;
import org.infinispan.commons.CacheException;
import org.infinispan.remoting.transport.Address;

@MessageLogger(projectCode="ISPN")
public interface Log
extends org.infinispan.util.logging.Log {
    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Could not locate key class %s", id=14001)
    public void keyClassNotFound(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Cannot instantiate an instance of Transformer class %s", id=14002)
    public void couldNotInstantiaterTransformerClass(Class<?> var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Registering Query interceptor", id=14003)
    public void registeringQueryInterceptor();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Custom commands backend initialized backing index %s", id=14004)
    public void commandsBackendInitialized(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Sent list of LuceneWork %s to node %s", id=14005)
    public void workListRemotedTo(Object var1, Address var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Apply list of LuceneWork %s delegating to local indexing engine", id=14006)
    public void applyingChangeListLocally(List<LuceneWork> var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Going to ship list of LuceneWork %s to a remote master indexer", id=14007)
    public void applyingChangeListRemotely(List<LuceneWork> var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Index named '%1$s' is ignoring configuration option 'directory_provider' set '%2$s': overriden to use the Infinispan Directory", id=14008)
    public void ignoreDirectoryProviderProperty(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Indexed type '%1$s' is using a default Transformer. This is slow! Register a custom implementation using @Transformable", id=14009)
    public void typeIsUsingDefaultTransformer(Class<?> var1);

    @Message(value="An IOException happened where none where expected", id=14010)
    public CacheException unexpectedIOException(@Cause IOException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Some indexing work was lost because of an InterruptedException", id=14011)
    public void interruptedWhileBufferingWork(@Cause InterruptedException var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Waiting for index lock was successfull: '%1$s'", id=14012)
    public void waitingForLockAcquired(boolean var1);

    @Message(value="Cache named '%1$s' is being shut down. No longer accepting remote commands.", id=14013)
    public CacheException cacheIsStoppingNoCommandAllowed(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Reindexed %1$d entities", id=14014)
    public void indexingEntitiesCompleted(long var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="%1$d documents indexed in %2$d ms", id=14015)
    public void indexingDocumentsCompleted(long var1, long var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Purging instances of '%s' from the index", id=14016)
    public void purgingIndex(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Flushing index '%s'", id=14017)
    public void flushingIndex(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error executing MassIndexer", id=14018)
    public void errorExecutingMassIndexer(@Cause Throwable var1);
}

