// $ANTLR 3.4 org/hibernate/hql/ast/render/OrderByRenderer.g 2015-08-25 17:34:01

/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * Copyright (c) 2008-2012, Red Hat Inc. or third-party contributors as
 * indicated by the @author tags or express copyright attribution
 * statements applied by the authors.  All third-party contributions are
 * distributed under license by Red Hat Inc.
 *
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this distribution; if not, write to:
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301  USA
 *
 * Portions of SQL grammar parsing copyright (C) 2003 by Lubos Vnuk.  All rights
 * reserved.  These portions are distributed under license by Red Hat Inc. and
 * are covered by the above LGPL notice.  If you redistribute this material,
 * with or without modification, you must preserve this copyright notice in its
 * entirety.
 */
package org.hibernate.hql.ast.render;

import org.antlr.stringtemplate.StringTemplate;


import org.antlr.runtime.*;
import org.antlr.runtime.tree.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

import org.antlr.stringtemplate.*;
import org.antlr.stringtemplate.language.*;
import java.util.HashMap;
@SuppressWarnings({"all", "warnings", "unchecked"})
public class OrderByRenderer extends TreeParser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "ABS", "ALIAS_NAME", "ALIAS_REF", "ALL", "AMPERSAND", "AND", "ANY", "ARROW", "AS", "ASTERISK", "AVG", "BETWEEN", "BETWEEN_LIST", "BIT_LENGTH", "BOTH", "CAST", "CHARACTER_LENGTH", "CHARACTER_LITERAL", "CLASS", "COALESCE", "COLLATE", "COLLECTION_EXPRESSION", "COLON", "COLUMN", "COLUMN_LIST", "COMMA", "CONCAT", "CONST_STRING_VALUE", "COUNT", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "DAY", "DECIMAL_LITERAL", "DELETE", "DISTINCT", "DOT", "DOT_CLASS", "DOUBLE_PIPE", "DYNAMIC_INSTANTIATION", "DYNAMIC_INSTANTIATION_ARG", "ELEMENTS", "ELSE", "END", "ENTITY_NAME", "ENTITY_PERSISTER_REF", "EOL", "EQUALS", "ESCAPE", "ESCAPE_SEQUENCE", "EXCEPT", "EXISTS", "EXPONENT", "EXTRACT", "FALSE", "FETCH", "FILTER", "FLOATING_POINT_LITERAL", "FLOAT_TYPE_SUFFIX", "FROM", "FULL", "FUNCTION", "GREATER", "GREATER_EQUAL", "GROUPING_VALUE", "GROUP_BY", "HAVING", "HEX_DIGIT", "HEX_LITERAL", "HOUR", "IDENTIFIER", "IN", "INDEX", "INDICES", "INNER", "INSERT", "INSERTABILITY_SPEC", "INTEGER_LITERAL", "INTEGER_TYPE_SUFFIX", "INTERSECT", "INTO", "IN_LIST", "IS", "IS_EMPTY", "IS_NOT_EMPTY", "IS_NOT_NULL", "IS_NULL", "JAVA_CONSTANT", "JOIN", "JPA_PARAM", "LEADING", "LEFT", "LEFT_PAREN", "LEFT_SQUARE", "LENGTH", "LESS", "LESS_EQUAL", "LIKE", "LOCATE", "LOWER", "MAX", "MAXELEMENT", "MAXINDEX", "MEMBER_OF", "MIN", "MINELEMENT", "MININDEX", "MINUS", "MINUTE", "MOD", "MONTH", "NAMED_PARAM", "NEW", "NOT", "NOT_BETWEEN", "NOT_EQUAL", "NOT_IN", "NOT_LIKE", "NOT_MEMBER_OF", "NULL", "NULLIF", "OCTAL_ESCAPE", "OCTAL_LITERAL", "OCTET_LENGTH", "ON", "OR", "ORDER_BY", "ORDER_SPEC", "OUTER", "PARAM", "PATH", "PERCENT", "PERSISTER_JOIN", "PERSISTER_SPACE", "PIPE", "PLUS", "POSITION", "PROPERTIES", "PROPERTY_JOIN", "PROPERTY_REFERENCE", "PROP_FETCH", "QUALIFIED_JOIN", "QUERY", "QUERY_SPEC", "QUOTED_IDENTIFIER", "RIGHT", "RIGHT_PAREN", "RIGHT_SQUARE", "SEARCHED_CASE", "SECOND", "SELECT", "SELECT_FROM", "SELECT_ITEM", "SELECT_LIST", "SEMICOLON", "SET", "SIMPLE_CASE", "SIZE", "SOLIDUS", "SOME", "SORT_SPEC", "SQRT", "STRING_LITERAL", "SUBSTRING", "SUB_QUERY", "SUM", "TABLE", "THEN", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TRAILING", "TRIM", "TRUE", "UNARY_MINUS", "UNARY_PLUS", "UNICODE_ESCAPE", "UNION", "UPDATE", "UPPER", "VECTOR_EXPR", "VERSIONED", "VERSIONED_VALUE", "WHEN", "WHERE", "WITH", "WS", "YEAR"
    };

    public static final int EOF=-1;
    public static final int ABS=4;
    public static final int ALIAS_NAME=5;
    public static final int ALIAS_REF=6;
    public static final int ALL=7;
    public static final int AMPERSAND=8;
    public static final int AND=9;
    public static final int ANY=10;
    public static final int ARROW=11;
    public static final int AS=12;
    public static final int ASTERISK=13;
    public static final int AVG=14;
    public static final int BETWEEN=15;
    public static final int BETWEEN_LIST=16;
    public static final int BIT_LENGTH=17;
    public static final int BOTH=18;
    public static final int CAST=19;
    public static final int CHARACTER_LENGTH=20;
    public static final int CHARACTER_LITERAL=21;
    public static final int CLASS=22;
    public static final int COALESCE=23;
    public static final int COLLATE=24;
    public static final int COLLECTION_EXPRESSION=25;
    public static final int COLON=26;
    public static final int COLUMN=27;
    public static final int COLUMN_LIST=28;
    public static final int COMMA=29;
    public static final int CONCAT=30;
    public static final int CONST_STRING_VALUE=31;
    public static final int COUNT=32;
    public static final int CROSS=33;
    public static final int CURRENT_DATE=34;
    public static final int CURRENT_TIME=35;
    public static final int CURRENT_TIMESTAMP=36;
    public static final int DAY=37;
    public static final int DECIMAL_LITERAL=38;
    public static final int DELETE=39;
    public static final int DISTINCT=40;
    public static final int DOT=41;
    public static final int DOT_CLASS=42;
    public static final int DOUBLE_PIPE=43;
    public static final int DYNAMIC_INSTANTIATION=44;
    public static final int DYNAMIC_INSTANTIATION_ARG=45;
    public static final int ELEMENTS=46;
    public static final int ELSE=47;
    public static final int END=48;
    public static final int ENTITY_NAME=49;
    public static final int ENTITY_PERSISTER_REF=50;
    public static final int EOL=51;
    public static final int EQUALS=52;
    public static final int ESCAPE=53;
    public static final int ESCAPE_SEQUENCE=54;
    public static final int EXCEPT=55;
    public static final int EXISTS=56;
    public static final int EXPONENT=57;
    public static final int EXTRACT=58;
    public static final int FALSE=59;
    public static final int FETCH=60;
    public static final int FILTER=61;
    public static final int FLOATING_POINT_LITERAL=62;
    public static final int FLOAT_TYPE_SUFFIX=63;
    public static final int FROM=64;
    public static final int FULL=65;
    public static final int FUNCTION=66;
    public static final int GREATER=67;
    public static final int GREATER_EQUAL=68;
    public static final int GROUPING_VALUE=69;
    public static final int GROUP_BY=70;
    public static final int HAVING=71;
    public static final int HEX_DIGIT=72;
    public static final int HEX_LITERAL=73;
    public static final int HOUR=74;
    public static final int IDENTIFIER=75;
    public static final int IN=76;
    public static final int INDEX=77;
    public static final int INDICES=78;
    public static final int INNER=79;
    public static final int INSERT=80;
    public static final int INSERTABILITY_SPEC=81;
    public static final int INTEGER_LITERAL=82;
    public static final int INTEGER_TYPE_SUFFIX=83;
    public static final int INTERSECT=84;
    public static final int INTO=85;
    public static final int IN_LIST=86;
    public static final int IS=87;
    public static final int IS_EMPTY=88;
    public static final int IS_NOT_EMPTY=89;
    public static final int IS_NOT_NULL=90;
    public static final int IS_NULL=91;
    public static final int JAVA_CONSTANT=92;
    public static final int JOIN=93;
    public static final int JPA_PARAM=94;
    public static final int LEADING=95;
    public static final int LEFT=96;
    public static final int LEFT_PAREN=97;
    public static final int LEFT_SQUARE=98;
    public static final int LENGTH=99;
    public static final int LESS=100;
    public static final int LESS_EQUAL=101;
    public static final int LIKE=102;
    public static final int LOCATE=103;
    public static final int LOWER=104;
    public static final int MAX=105;
    public static final int MAXELEMENT=106;
    public static final int MAXINDEX=107;
    public static final int MEMBER_OF=108;
    public static final int MIN=109;
    public static final int MINELEMENT=110;
    public static final int MININDEX=111;
    public static final int MINUS=112;
    public static final int MINUTE=113;
    public static final int MOD=114;
    public static final int MONTH=115;
    public static final int NAMED_PARAM=116;
    public static final int NEW=117;
    public static final int NOT=118;
    public static final int NOT_BETWEEN=119;
    public static final int NOT_EQUAL=120;
    public static final int NOT_IN=121;
    public static final int NOT_LIKE=122;
    public static final int NOT_MEMBER_OF=123;
    public static final int NULL=124;
    public static final int NULLIF=125;
    public static final int OCTAL_ESCAPE=126;
    public static final int OCTAL_LITERAL=127;
    public static final int OCTET_LENGTH=128;
    public static final int ON=129;
    public static final int OR=130;
    public static final int ORDER_BY=131;
    public static final int ORDER_SPEC=132;
    public static final int OUTER=133;
    public static final int PARAM=134;
    public static final int PATH=135;
    public static final int PERCENT=136;
    public static final int PERSISTER_JOIN=137;
    public static final int PERSISTER_SPACE=138;
    public static final int PIPE=139;
    public static final int PLUS=140;
    public static final int POSITION=141;
    public static final int PROPERTIES=142;
    public static final int PROPERTY_JOIN=143;
    public static final int PROPERTY_REFERENCE=144;
    public static final int PROP_FETCH=145;
    public static final int QUALIFIED_JOIN=146;
    public static final int QUERY=147;
    public static final int QUERY_SPEC=148;
    public static final int QUOTED_IDENTIFIER=149;
    public static final int RIGHT=150;
    public static final int RIGHT_PAREN=151;
    public static final int RIGHT_SQUARE=152;
    public static final int SEARCHED_CASE=153;
    public static final int SECOND=154;
    public static final int SELECT=155;
    public static final int SELECT_FROM=156;
    public static final int SELECT_ITEM=157;
    public static final int SELECT_LIST=158;
    public static final int SEMICOLON=159;
    public static final int SET=160;
    public static final int SIMPLE_CASE=161;
    public static final int SIZE=162;
    public static final int SOLIDUS=163;
    public static final int SOME=164;
    public static final int SORT_SPEC=165;
    public static final int SQRT=166;
    public static final int STRING_LITERAL=167;
    public static final int SUBSTRING=168;
    public static final int SUB_QUERY=169;
    public static final int SUM=170;
    public static final int TABLE=171;
    public static final int THEN=172;
    public static final int TIMEZONE_HOUR=173;
    public static final int TIMEZONE_MINUTE=174;
    public static final int TRAILING=175;
    public static final int TRIM=176;
    public static final int TRUE=177;
    public static final int UNARY_MINUS=178;
    public static final int UNARY_PLUS=179;
    public static final int UNICODE_ESCAPE=180;
    public static final int UNION=181;
    public static final int UPDATE=182;
    public static final int UPPER=183;
    public static final int VECTOR_EXPR=184;
    public static final int VERSIONED=185;
    public static final int VERSIONED_VALUE=186;
    public static final int WHEN=187;
    public static final int WHERE=188;
    public static final int WITH=189;
    public static final int WS=190;
    public static final int YEAR=191;

    // delegates
    public TreeParser[] getDelegates() {
        return new TreeParser[] {};
    }

    // delegators


    public OrderByRenderer(TreeNodeStream input) {
        this(input, new RecognizerSharedState());
    }
    public OrderByRenderer(TreeNodeStream input, RecognizerSharedState state) {
        super(input, state);
    }

protected StringTemplateGroup templateLib =
  new StringTemplateGroup("OrderByRendererTemplates", AngleBracketTemplateLexer.class);

public void setTemplateLib(StringTemplateGroup templateLib) {
  this.templateLib = templateLib;
}
public StringTemplateGroup getTemplateLib() {
  return templateLib;
}
/** allows convenient multi-value initialization:
 *  "new STAttrMap().put(...).put(...)"
 */
public static class STAttrMap extends HashMap {
  public STAttrMap put(String attrName, Object value) {
    super.put(attrName, value);
    return this;
  }
  public STAttrMap put(String attrName, int value) {
    super.put(attrName, new Integer(value));
    return this;
  }
}
    public String[] getTokenNames() { return OrderByRenderer.tokenNames; }
    public String getGrammarFileName() { return "org/hibernate/hql/ast/render/OrderByRenderer.g"; }


        protected StringTemplate quotedIdentifier(CommonToken recognizedIdentifierToken) {
            return new StringTemplate( getTemplateLib(), recognizedIdentifierToken.getText() );
        }

        protected StringTemplate basicFunctionTemplate(String functionName, List arguments) {
            return new StringTemplate(
                    getTemplateLib(),
                    "<name>(<arguments; separator=\", \">)",
                    new STAttrMap().put( "name", functionName ).put( "arguments", arguments )
            );
        }

        protected StringTemplate castFunctionTemplate(StringTemplate expression, String  datatype) {
            return new StringTemplate(
                    getTemplateLib(),
                    "cast(<expression> as <datatype>)",
                    new STAttrMap().put( "expression", expression )
                            .put( "datatype", datatype )
            );
        }

        protected StringTemplate trimFunctionTemplate(StringTemplate trimSpec, StringTemplate trimCharacter, StringTemplate trimSource) {
            return new StringTemplate(
                    getTemplateLib(),
                    "trim(<trimSpec> <trimCharacter> from <trimSource>)",
                    new STAttrMap().put( "trimSpec", trimSpec )
                            .put( "trimCharacter", trimCharacter )
                            .put( "trimSource", trimSource )
            );
        }

        protected StringTemplate extractFunctionTemplate(StringTemplate extractField, StringTemplate expression) {
            return new StringTemplate(
                    getTemplateLib(),
                    "extract(<extractField> from <expression>)",
                    new STAttrMap().put( "extractField", extractField )
                            .put( "expression", expression )
            );
        }

        protected StringTemplate positionFunctionTemplate(StringTemplate searchString, StringTemplate sourceString) {
            return new StringTemplate(
                    getTemplateLib(),
                    "position(<searchString> in <sourceString>)",
                    new STAttrMap().put( "searchString", searchString )
                            .put( "sourceString", sourceString )
            );
        }


    public static class orderByFragment_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "orderByFragment"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:99:1: orderByFragment : ^( ORDER_BY (sortSpecs+= sortSpecification )+ ) -> orderByFragment(sortSpecifications=$sortSpecs);
    public final OrderByRenderer.orderByFragment_return orderByFragment() throws RecognitionException {
        OrderByRenderer.orderByFragment_return retval = new OrderByRenderer.orderByFragment_return();
        retval.start = input.LT(1);


        List list_sortSpecs=null;
        RuleReturnScope sortSpecs = null;
        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:100:5: ( ^( ORDER_BY (sortSpecs+= sortSpecification )+ ) -> orderByFragment(sortSpecifications=$sortSpecs))
            // org/hibernate/hql/ast/render/OrderByRenderer.g:100:7: ^( ORDER_BY (sortSpecs+= sortSpecification )+ )
            {
            match(input,ORDER_BY,FOLLOW_ORDER_BY_in_orderByFragment62); 

            match(input, Token.DOWN, null); 
            // org/hibernate/hql/ast/render/OrderByRenderer.g:100:28: (sortSpecs+= sortSpecification )+
            int cnt1=0;
            loop1:
            do {
                int alt1=2;
                int LA1_0 = input.LA(1);

                if ( (LA1_0==SORT_SPEC) ) {
                    alt1=1;
                }


                switch (alt1) {
            	case 1 :
            	    // org/hibernate/hql/ast/render/OrderByRenderer.g:100:28: sortSpecs+= sortSpecification
            	    {
            	    pushFollow(FOLLOW_sortSpecification_in_orderByFragment66);
            	    sortSpecs=sortSpecification();

            	    state._fsp--;

            	    if (list_sortSpecs==null) list_sortSpecs=new ArrayList();
            	    list_sortSpecs.add(sortSpecs.getTemplate());


            	    }
            	    break;

            	default :
            	    if ( cnt1 >= 1 ) break loop1;
                        EarlyExitException eee =
                            new EarlyExitException(1, input);
                        throw eee;
                }
                cnt1++;
            } while (true);


            match(input, Token.UP, null); 


            // TEMPLATE REWRITE
            // 101:9: -> orderByFragment(sortSpecifications=$sortSpecs)
            {
                retval.st = templateLib.getInstanceOf("orderByFragment",new STAttrMap().put("sortSpecifications", list_sortSpecs));
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "orderByFragment"


    public static class sortSpecification_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "sortSpecification"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:104:1: sortSpecification : ^( SORT_SPEC sortKey ( collationSpecification )? ( ORDER_SPEC )? ) -> sortSpecification(sortKey=$sortKey.stcollationSpecification=$collationSpecification.storderingSpecification=$ORDER_SPEC.text);
    public final OrderByRenderer.sortSpecification_return sortSpecification() throws RecognitionException {
        OrderByRenderer.sortSpecification_return retval = new OrderByRenderer.sortSpecification_return();
        retval.start = input.LT(1);


        CommonTree ORDER_SPEC3=null;
        OrderByRenderer.sortKey_return sortKey1 =null;

        OrderByRenderer.collationSpecification_return collationSpecification2 =null;


        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:105:5: ( ^( SORT_SPEC sortKey ( collationSpecification )? ( ORDER_SPEC )? ) -> sortSpecification(sortKey=$sortKey.stcollationSpecification=$collationSpecification.storderingSpecification=$ORDER_SPEC.text))
            // org/hibernate/hql/ast/render/OrderByRenderer.g:105:7: ^( SORT_SPEC sortKey ( collationSpecification )? ( ORDER_SPEC )? )
            {
            match(input,SORT_SPEC,FOLLOW_SORT_SPEC_in_sortSpecification108); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_sortKey_in_sortSpecification110);
            sortKey1=sortKey();

            state._fsp--;


            // org/hibernate/hql/ast/render/OrderByRenderer.g:105:28: ( collationSpecification )?
            int alt2=2;
            int LA2_0 = input.LA(1);

            if ( (LA2_0==COLLATE) ) {
                alt2=1;
            }
            switch (alt2) {
                case 1 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:105:28: collationSpecification
                    {
                    pushFollow(FOLLOW_collationSpecification_in_sortSpecification112);
                    collationSpecification2=collationSpecification();

                    state._fsp--;


                    }
                    break;

            }


            // org/hibernate/hql/ast/render/OrderByRenderer.g:105:52: ( ORDER_SPEC )?
            int alt3=2;
            int LA3_0 = input.LA(1);

            if ( (LA3_0==ORDER_SPEC) ) {
                alt3=1;
            }
            switch (alt3) {
                case 1 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:105:52: ORDER_SPEC
                    {
                    ORDER_SPEC3=(CommonTree)match(input,ORDER_SPEC,FOLLOW_ORDER_SPEC_in_sortSpecification115); 

                    }
                    break;

            }


            match(input, Token.UP, null); 


            // TEMPLATE REWRITE
            // 106:9: -> sortSpecification(sortKey=$sortKey.stcollationSpecification=$collationSpecification.storderingSpecification=$ORDER_SPEC.text)
            {
                retval.st = templateLib.getInstanceOf("sortSpecification",new STAttrMap().put("sortKey", (sortKey1!=null?sortKey1.st:null)).put("collationSpecification", (collationSpecification2!=null?collationSpecification2.st:null)).put("orderingSpecification", (ORDER_SPEC3!=null?ORDER_SPEC3.getText():null)));
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "sortSpecification"


    public static class collationSpecification_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "collationSpecification"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:113:1: collationSpecification : COLLATE -> {%{\"collate \" + $COLLATE.text}};
    public final OrderByRenderer.collationSpecification_return collationSpecification() throws RecognitionException {
        OrderByRenderer.collationSpecification_return retval = new OrderByRenderer.collationSpecification_return();
        retval.start = input.LT(1);


        CommonTree COLLATE4=null;

        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:114:5: ( COLLATE -> {%{\"collate \" + $COLLATE.text}})
            // org/hibernate/hql/ast/render/OrderByRenderer.g:114:7: COLLATE
            {
            COLLATE4=(CommonTree)match(input,COLLATE,FOLLOW_COLLATE_in_collationSpecification237); 

            // TEMPLATE REWRITE
            // 114:15: -> {%{\"collate \" + $COLLATE.text}}
            {
                retval.st = new StringTemplate(templateLib,"collate " + (COLLATE4!=null?COLLATE4.getText():null));
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "collationSpecification"


    public static class sortKey_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "sortKey"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:117:1: sortKey : expression -> {$expression.st};
    public final OrderByRenderer.sortKey_return sortKey() throws RecognitionException {
        OrderByRenderer.sortKey_return retval = new OrderByRenderer.sortKey_return();
        retval.start = input.LT(1);


        OrderByRenderer.expression_return expression5 =null;


        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:118:5: ( expression -> {$expression.st})
            // org/hibernate/hql/ast/render/OrderByRenderer.g:118:7: expression
            {
            pushFollow(FOLLOW_expression_in_sortKey258);
            expression5=expression();

            state._fsp--;


            // TEMPLATE REWRITE
            // 118:18: -> {$expression.st}
            {
                retval.st = (expression5!=null?expression5.st:null);
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "sortKey"


    public static class expression_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "expression"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:121:1: expression : valueExpression -> {$valueExpression.st};
    public final OrderByRenderer.expression_return expression() throws RecognitionException {
        OrderByRenderer.expression_return retval = new OrderByRenderer.expression_return();
        retval.start = input.LT(1);


        OrderByRenderer.valueExpression_return valueExpression6 =null;


        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:122:5: ( valueExpression -> {$valueExpression.st})
            // org/hibernate/hql/ast/render/OrderByRenderer.g:122:7: valueExpression
            {
            pushFollow(FOLLOW_valueExpression_in_expression279);
            valueExpression6=valueExpression();

            state._fsp--;


            // TEMPLATE REWRITE
            // 122:23: -> {$valueExpression.st}
            {
                retval.st = (valueExpression6!=null?valueExpression6.st:null);
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "expression"


    public static class valueExpression_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "valueExpression"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:125:1: valueExpression : ( column -> {$column.st}| function -> {$function.st}| literal -> {$literal.st}| rowValueConstructor -> {$rowValueConstructor.st});
    public final OrderByRenderer.valueExpression_return valueExpression() throws RecognitionException {
        OrderByRenderer.valueExpression_return retval = new OrderByRenderer.valueExpression_return();
        retval.start = input.LT(1);


        OrderByRenderer.column_return column7 =null;

        OrderByRenderer.function_return function8 =null;

        OrderByRenderer.literal_return literal9 =null;

        OrderByRenderer.rowValueConstructor_return rowValueConstructor10 =null;


        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:126:5: ( column -> {$column.st}| function -> {$function.st}| literal -> {$literal.st}| rowValueConstructor -> {$rowValueConstructor.st})
            int alt4=4;
            switch ( input.LA(1) ) {
            case COLUMN:
                {
                alt4=1;
                }
                break;
            case ABS:
            case BIT_LENGTH:
            case CAST:
            case CHARACTER_LENGTH:
            case CONCAT:
            case CURRENT_DATE:
            case CURRENT_TIME:
            case CURRENT_TIMESTAMP:
            case EXTRACT:
            case FUNCTION:
            case LENGTH:
            case LOCATE:
            case LOWER:
            case MOD:
            case OCTET_LENGTH:
            case POSITION:
            case SQRT:
            case SUBSTRING:
            case TRIM:
            case UPPER:
                {
                alt4=2;
                }
                break;
            case CHARACTER_LITERAL:
            case DECIMAL_LITERAL:
            case FLOATING_POINT_LITERAL:
            case HEX_LITERAL:
            case INTEGER_LITERAL:
            case OCTAL_LITERAL:
            case STRING_LITERAL:
                {
                alt4=3;
                }
                break;
            case VECTOR_EXPR:
                {
                alt4=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 4, 0, input);

                throw nvae;

            }

            switch (alt4) {
                case 1 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:126:7: column
                    {
                    pushFollow(FOLLOW_column_in_valueExpression300);
                    column7=column();

                    state._fsp--;


                    // TEMPLATE REWRITE
                    // 126:14: -> {$column.st}
                    {
                        retval.st = (column7!=null?column7.st:null);
                    }



                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:127:7: function
                    {
                    pushFollow(FOLLOW_function_in_valueExpression312);
                    function8=function();

                    state._fsp--;


                    // TEMPLATE REWRITE
                    // 127:16: -> {$function.st}
                    {
                        retval.st = (function8!=null?function8.st:null);
                    }



                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:128:7: literal
                    {
                    pushFollow(FOLLOW_literal_in_valueExpression324);
                    literal9=literal();

                    state._fsp--;


                    // TEMPLATE REWRITE
                    // 128:15: -> {$literal.st}
                    {
                        retval.st = (literal9!=null?literal9.st:null);
                    }



                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:129:7: rowValueConstructor
                    {
                    pushFollow(FOLLOW_rowValueConstructor_in_valueExpression336);
                    rowValueConstructor10=rowValueConstructor();

                    state._fsp--;


                    // TEMPLATE REWRITE
                    // 129:27: -> {$rowValueConstructor.st}
                    {
                        retval.st = (rowValueConstructor10!=null?rowValueConstructor10.st:null);
                    }



                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "valueExpression"


    public static class characterValueExpression_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "characterValueExpression"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:132:1: characterValueExpression : valueExpression -> {$valueExpression.st};
    public final OrderByRenderer.characterValueExpression_return characterValueExpression() throws RecognitionException {
        OrderByRenderer.characterValueExpression_return retval = new OrderByRenderer.characterValueExpression_return();
        retval.start = input.LT(1);


        OrderByRenderer.valueExpression_return valueExpression11 =null;


        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:133:5: ( valueExpression -> {$valueExpression.st})
            // org/hibernate/hql/ast/render/OrderByRenderer.g:133:7: valueExpression
            {
            pushFollow(FOLLOW_valueExpression_in_characterValueExpression357);
            valueExpression11=valueExpression();

            state._fsp--;


            // TEMPLATE REWRITE
            // 133:23: -> {$valueExpression.st}
            {
                retval.st = (valueExpression11!=null?valueExpression11.st:null);
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "characterValueExpression"


    public static class numericValueExpression_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "numericValueExpression"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:136:1: numericValueExpression : valueExpression -> {$valueExpression.st};
    public final OrderByRenderer.numericValueExpression_return numericValueExpression() throws RecognitionException {
        OrderByRenderer.numericValueExpression_return retval = new OrderByRenderer.numericValueExpression_return();
        retval.start = input.LT(1);


        OrderByRenderer.valueExpression_return valueExpression12 =null;


        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:137:5: ( valueExpression -> {$valueExpression.st})
            // org/hibernate/hql/ast/render/OrderByRenderer.g:137:7: valueExpression
            {
            pushFollow(FOLLOW_valueExpression_in_numericValueExpression378);
            valueExpression12=valueExpression();

            state._fsp--;


            // TEMPLATE REWRITE
            // 137:23: -> {$valueExpression.st}
            {
                retval.st = (valueExpression12!=null?valueExpression12.st:null);
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "numericValueExpression"


    public static class column_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "column"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:140:1: column : ^( COLUMN ALIAS_REF identifier ) -> column(qualifier=$ALIAS_REF.textname=$identifier.st);
    public final OrderByRenderer.column_return column() throws RecognitionException {
        OrderByRenderer.column_return retval = new OrderByRenderer.column_return();
        retval.start = input.LT(1);


        CommonTree ALIAS_REF13=null;
        OrderByRenderer.identifier_return identifier14 =null;


        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:141:5: ( ^( COLUMN ALIAS_REF identifier ) -> column(qualifier=$ALIAS_REF.textname=$identifier.st))
            // org/hibernate/hql/ast/render/OrderByRenderer.g:141:7: ^( COLUMN ALIAS_REF identifier )
            {
            match(input,COLUMN,FOLLOW_COLUMN_in_column401); 

            match(input, Token.DOWN, null); 
            ALIAS_REF13=(CommonTree)match(input,ALIAS_REF,FOLLOW_ALIAS_REF_in_column403); 

            pushFollow(FOLLOW_identifier_in_column405);
            identifier14=identifier();

            state._fsp--;


            match(input, Token.UP, null); 


            // TEMPLATE REWRITE
            // 142:9: -> column(qualifier=$ALIAS_REF.textname=$identifier.st)
            {
                retval.st = templateLib.getInstanceOf("column",new STAttrMap().put("qualifier", (ALIAS_REF13!=null?ALIAS_REF13.getText():null)).put("name", (identifier14!=null?identifier14.st:null)));
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "column"


    public static class identifier_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "identifier"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:145:1: identifier : ( IDENTIFIER -> {%{$IDENTIFIER.text}}| QUOTED_IDENTIFIER -> { quotedIdentifier( (CommonToken) $QUOTED_IDENTIFIER.getToken() ) });
    public final OrderByRenderer.identifier_return identifier() throws RecognitionException {
        OrderByRenderer.identifier_return retval = new OrderByRenderer.identifier_return();
        retval.start = input.LT(1);


        CommonTree IDENTIFIER15=null;
        CommonTree QUOTED_IDENTIFIER16=null;

        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:146:5: ( IDENTIFIER -> {%{$IDENTIFIER.text}}| QUOTED_IDENTIFIER -> { quotedIdentifier( (CommonToken) $QUOTED_IDENTIFIER.getToken() ) })
            int alt5=2;
            int LA5_0 = input.LA(1);

            if ( (LA5_0==IDENTIFIER) ) {
                alt5=1;
            }
            else if ( (LA5_0==QUOTED_IDENTIFIER) ) {
                alt5=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 5, 0, input);

                throw nvae;

            }
            switch (alt5) {
                case 1 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:146:7: IDENTIFIER
                    {
                    IDENTIFIER15=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_identifier448); 

                    // TEMPLATE REWRITE
                    // 146:18: -> {%{$IDENTIFIER.text}}
                    {
                        retval.st = new StringTemplate(templateLib,(IDENTIFIER15!=null?IDENTIFIER15.getText():null));
                    }



                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:147:7: QUOTED_IDENTIFIER
                    {
                    QUOTED_IDENTIFIER16=(CommonTree)match(input,QUOTED_IDENTIFIER,FOLLOW_QUOTED_IDENTIFIER_in_identifier460); 

                    // TEMPLATE REWRITE
                    // 147:25: -> { quotedIdentifier( (CommonToken) $QUOTED_IDENTIFIER.getToken() ) }
                    {
                        retval.st =  quotedIdentifier( (CommonToken) QUOTED_IDENTIFIER16.getToken() ) ;
                    }



                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "identifier"


    public static class rowValueConstructor_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "rowValueConstructor"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:150:1: rowValueConstructor : ^( VECTOR_EXPR (expressions+= expression )+ ) -> template(expressions=$expressions) \"(<expressions; separator=\", \">)\";
    public final OrderByRenderer.rowValueConstructor_return rowValueConstructor() throws RecognitionException {
        OrderByRenderer.rowValueConstructor_return retval = new OrderByRenderer.rowValueConstructor_return();
        retval.start = input.LT(1);


        List list_expressions=null;
        RuleReturnScope expressions = null;
        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:151:5: ( ^( VECTOR_EXPR (expressions+= expression )+ ) -> template(expressions=$expressions) \"(<expressions; separator=\", \">)\")
            // org/hibernate/hql/ast/render/OrderByRenderer.g:151:7: ^( VECTOR_EXPR (expressions+= expression )+ )
            {
            match(input,VECTOR_EXPR,FOLLOW_VECTOR_EXPR_in_rowValueConstructor483); 

            match(input, Token.DOWN, null); 
            // org/hibernate/hql/ast/render/OrderByRenderer.g:151:33: (expressions+= expression )+
            int cnt6=0;
            loop6:
            do {
                int alt6=2;
                int LA6_0 = input.LA(1);

                if ( (LA6_0==ABS||LA6_0==BIT_LENGTH||(LA6_0 >= CAST && LA6_0 <= CHARACTER_LITERAL)||LA6_0==COLUMN||LA6_0==CONCAT||(LA6_0 >= CURRENT_DATE && LA6_0 <= CURRENT_TIMESTAMP)||LA6_0==DECIMAL_LITERAL||LA6_0==EXTRACT||LA6_0==FLOATING_POINT_LITERAL||LA6_0==FUNCTION||LA6_0==HEX_LITERAL||LA6_0==INTEGER_LITERAL||LA6_0==LENGTH||(LA6_0 >= LOCATE && LA6_0 <= LOWER)||LA6_0==MOD||(LA6_0 >= OCTAL_LITERAL && LA6_0 <= OCTET_LENGTH)||LA6_0==POSITION||(LA6_0 >= SQRT && LA6_0 <= SUBSTRING)||LA6_0==TRIM||(LA6_0 >= UPPER && LA6_0 <= VECTOR_EXPR)) ) {
                    alt6=1;
                }


                switch (alt6) {
            	case 1 :
            	    // org/hibernate/hql/ast/render/OrderByRenderer.g:151:33: expressions+= expression
            	    {
            	    pushFollow(FOLLOW_expression_in_rowValueConstructor487);
            	    expressions=expression();

            	    state._fsp--;

            	    if (list_expressions==null) list_expressions=new ArrayList();
            	    list_expressions.add(expressions.getTemplate());


            	    }
            	    break;

            	default :
            	    if ( cnt6 >= 1 ) break loop6;
                        EarlyExitException eee =
                            new EarlyExitException(6, input);
                        throw eee;
                }
                cnt6++;
            } while (true);


            match(input, Token.UP, null); 


            // TEMPLATE REWRITE
            // 152:9: -> template(expressions=$expressions) \"(<expressions; separator=\", \">)\"
            {
                retval.st = new StringTemplate(templateLib, "(<expressions; separator=\", \">)",new STAttrMap().put("expressions", list_expressions));
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "rowValueConstructor"


    public static class function_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "function"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:155:1: function : ( functionFunction -> {$functionFunction.st}| castFunction -> {$castFunction.st}| concatFunction -> {$concatFunction.st}| substringFunction -> {$substringFunction.st}| trimFunction -> {$trimFunction.st}| upperFunction -> {$upperFunction.st}| lowerFunction -> {$lowerFunction.st}| lengthFunction -> {$lengthFunction.st}| locateFunction -> {$locateFunction.st}| absFunction -> {$absFunction.st}| sqrtFunction -> {$sqrtFunction.st}| modFunction -> {$modFunction.st}| currentDateFunction -> {$currentDateFunction.st}| currentTimeFunction -> {$currentTimeFunction.st}| currentTimestampFunction -> {$currentTimestampFunction.st}| extractFunction -> {$extractFunction.st}| positionFunction -> {$positionFunction.st}| charLengthFunction -> {$charLengthFunction.st}| octetLengthFunction -> {$octetLengthFunction.st}| bitLengthFunction -> {$bitLengthFunction.st});
    public final OrderByRenderer.function_return function() throws RecognitionException {
        OrderByRenderer.function_return retval = new OrderByRenderer.function_return();
        retval.start = input.LT(1);


        OrderByRenderer.functionFunction_return functionFunction17 =null;

        OrderByRenderer.castFunction_return castFunction18 =null;

        OrderByRenderer.concatFunction_return concatFunction19 =null;

        OrderByRenderer.substringFunction_return substringFunction20 =null;

        OrderByRenderer.trimFunction_return trimFunction21 =null;

        OrderByRenderer.upperFunction_return upperFunction22 =null;

        OrderByRenderer.lowerFunction_return lowerFunction23 =null;

        OrderByRenderer.lengthFunction_return lengthFunction24 =null;

        OrderByRenderer.locateFunction_return locateFunction25 =null;

        OrderByRenderer.absFunction_return absFunction26 =null;

        OrderByRenderer.sqrtFunction_return sqrtFunction27 =null;

        OrderByRenderer.modFunction_return modFunction28 =null;

        OrderByRenderer.currentDateFunction_return currentDateFunction29 =null;

        OrderByRenderer.currentTimeFunction_return currentTimeFunction30 =null;

        OrderByRenderer.currentTimestampFunction_return currentTimestampFunction31 =null;

        OrderByRenderer.extractFunction_return extractFunction32 =null;

        OrderByRenderer.positionFunction_return positionFunction33 =null;

        OrderByRenderer.charLengthFunction_return charLengthFunction34 =null;

        OrderByRenderer.octetLengthFunction_return octetLengthFunction35 =null;

        OrderByRenderer.bitLengthFunction_return bitLengthFunction36 =null;


        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:156:5: ( functionFunction -> {$functionFunction.st}| castFunction -> {$castFunction.st}| concatFunction -> {$concatFunction.st}| substringFunction -> {$substringFunction.st}| trimFunction -> {$trimFunction.st}| upperFunction -> {$upperFunction.st}| lowerFunction -> {$lowerFunction.st}| lengthFunction -> {$lengthFunction.st}| locateFunction -> {$locateFunction.st}| absFunction -> {$absFunction.st}| sqrtFunction -> {$sqrtFunction.st}| modFunction -> {$modFunction.st}| currentDateFunction -> {$currentDateFunction.st}| currentTimeFunction -> {$currentTimeFunction.st}| currentTimestampFunction -> {$currentTimestampFunction.st}| extractFunction -> {$extractFunction.st}| positionFunction -> {$positionFunction.st}| charLengthFunction -> {$charLengthFunction.st}| octetLengthFunction -> {$octetLengthFunction.st}| bitLengthFunction -> {$bitLengthFunction.st})
            int alt7=20;
            switch ( input.LA(1) ) {
            case FUNCTION:
                {
                alt7=1;
                }
                break;
            case CAST:
                {
                alt7=2;
                }
                break;
            case CONCAT:
                {
                alt7=3;
                }
                break;
            case SUBSTRING:
                {
                alt7=4;
                }
                break;
            case TRIM:
                {
                alt7=5;
                }
                break;
            case UPPER:
                {
                alt7=6;
                }
                break;
            case LOWER:
                {
                alt7=7;
                }
                break;
            case LENGTH:
                {
                alt7=8;
                }
                break;
            case LOCATE:
                {
                alt7=9;
                }
                break;
            case ABS:
                {
                alt7=10;
                }
                break;
            case SQRT:
                {
                alt7=11;
                }
                break;
            case MOD:
                {
                alt7=12;
                }
                break;
            case CURRENT_DATE:
                {
                alt7=13;
                }
                break;
            case CURRENT_TIME:
                {
                alt7=14;
                }
                break;
            case CURRENT_TIMESTAMP:
                {
                alt7=15;
                }
                break;
            case EXTRACT:
                {
                alt7=16;
                }
                break;
            case POSITION:
                {
                alt7=17;
                }
                break;
            case CHARACTER_LENGTH:
                {
                alt7=18;
                }
                break;
            case OCTET_LENGTH:
                {
                alt7=19;
                }
                break;
            case BIT_LENGTH:
                {
                alt7=20;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 7, 0, input);

                throw nvae;

            }

            switch (alt7) {
                case 1 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:156:7: functionFunction
                    {
                    pushFollow(FOLLOW_functionFunction_in_function528);
                    functionFunction17=functionFunction();

                    state._fsp--;


                    // TEMPLATE REWRITE
                    // 156:24: -> {$functionFunction.st}
                    {
                        retval.st = (functionFunction17!=null?functionFunction17.st:null);
                    }



                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:157:4: castFunction
                    {
                    pushFollow(FOLLOW_castFunction_in_function537);
                    castFunction18=castFunction();

                    state._fsp--;


                    // TEMPLATE REWRITE
                    // 157:17: -> {$castFunction.st}
                    {
                        retval.st = (castFunction18!=null?castFunction18.st:null);
                    }



                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:158:4: concatFunction
                    {
                    pushFollow(FOLLOW_concatFunction_in_function546);
                    concatFunction19=concatFunction();

                    state._fsp--;


                    // TEMPLATE REWRITE
                    // 158:19: -> {$concatFunction.st}
                    {
                        retval.st = (concatFunction19!=null?concatFunction19.st:null);
                    }



                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:159:4: substringFunction
                    {
                    pushFollow(FOLLOW_substringFunction_in_function555);
                    substringFunction20=substringFunction();

                    state._fsp--;


                    // TEMPLATE REWRITE
                    // 159:22: -> {$substringFunction.st}
                    {
                        retval.st = (substringFunction20!=null?substringFunction20.st:null);
                    }



                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:160:4: trimFunction
                    {
                    pushFollow(FOLLOW_trimFunction_in_function564);
                    trimFunction21=trimFunction();

                    state._fsp--;


                    // TEMPLATE REWRITE
                    // 160:17: -> {$trimFunction.st}
                    {
                        retval.st = (trimFunction21!=null?trimFunction21.st:null);
                    }



                    }
                    break;
                case 6 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:161:4: upperFunction
                    {
                    pushFollow(FOLLOW_upperFunction_in_function573);
                    upperFunction22=upperFunction();

                    state._fsp--;


                    // TEMPLATE REWRITE
                    // 161:18: -> {$upperFunction.st}
                    {
                        retval.st = (upperFunction22!=null?upperFunction22.st:null);
                    }



                    }
                    break;
                case 7 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:162:4: lowerFunction
                    {
                    pushFollow(FOLLOW_lowerFunction_in_function582);
                    lowerFunction23=lowerFunction();

                    state._fsp--;


                    // TEMPLATE REWRITE
                    // 162:18: -> {$lowerFunction.st}
                    {
                        retval.st = (lowerFunction23!=null?lowerFunction23.st:null);
                    }



                    }
                    break;
                case 8 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:163:4: lengthFunction
                    {
                    pushFollow(FOLLOW_lengthFunction_in_function591);
                    lengthFunction24=lengthFunction();

                    state._fsp--;


                    // TEMPLATE REWRITE
                    // 163:19: -> {$lengthFunction.st}
                    {
                        retval.st = (lengthFunction24!=null?lengthFunction24.st:null);
                    }



                    }
                    break;
                case 9 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:164:4: locateFunction
                    {
                    pushFollow(FOLLOW_locateFunction_in_function600);
                    locateFunction25=locateFunction();

                    state._fsp--;


                    // TEMPLATE REWRITE
                    // 164:19: -> {$locateFunction.st}
                    {
                        retval.st = (locateFunction25!=null?locateFunction25.st:null);
                    }



                    }
                    break;
                case 10 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:165:4: absFunction
                    {
                    pushFollow(FOLLOW_absFunction_in_function609);
                    absFunction26=absFunction();

                    state._fsp--;


                    // TEMPLATE REWRITE
                    // 165:16: -> {$absFunction.st}
                    {
                        retval.st = (absFunction26!=null?absFunction26.st:null);
                    }



                    }
                    break;
                case 11 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:166:4: sqrtFunction
                    {
                    pushFollow(FOLLOW_sqrtFunction_in_function618);
                    sqrtFunction27=sqrtFunction();

                    state._fsp--;


                    // TEMPLATE REWRITE
                    // 166:17: -> {$sqrtFunction.st}
                    {
                        retval.st = (sqrtFunction27!=null?sqrtFunction27.st:null);
                    }



                    }
                    break;
                case 12 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:167:4: modFunction
                    {
                    pushFollow(FOLLOW_modFunction_in_function627);
                    modFunction28=modFunction();

                    state._fsp--;


                    // TEMPLATE REWRITE
                    // 167:16: -> {$modFunction.st}
                    {
                        retval.st = (modFunction28!=null?modFunction28.st:null);
                    }



                    }
                    break;
                case 13 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:168:4: currentDateFunction
                    {
                    pushFollow(FOLLOW_currentDateFunction_in_function636);
                    currentDateFunction29=currentDateFunction();

                    state._fsp--;


                    // TEMPLATE REWRITE
                    // 168:24: -> {$currentDateFunction.st}
                    {
                        retval.st = (currentDateFunction29!=null?currentDateFunction29.st:null);
                    }



                    }
                    break;
                case 14 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:169:4: currentTimeFunction
                    {
                    pushFollow(FOLLOW_currentTimeFunction_in_function645);
                    currentTimeFunction30=currentTimeFunction();

                    state._fsp--;


                    // TEMPLATE REWRITE
                    // 169:24: -> {$currentTimeFunction.st}
                    {
                        retval.st = (currentTimeFunction30!=null?currentTimeFunction30.st:null);
                    }



                    }
                    break;
                case 15 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:170:4: currentTimestampFunction
                    {
                    pushFollow(FOLLOW_currentTimestampFunction_in_function654);
                    currentTimestampFunction31=currentTimestampFunction();

                    state._fsp--;


                    // TEMPLATE REWRITE
                    // 170:29: -> {$currentTimestampFunction.st}
                    {
                        retval.st = (currentTimestampFunction31!=null?currentTimestampFunction31.st:null);
                    }



                    }
                    break;
                case 16 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:171:4: extractFunction
                    {
                    pushFollow(FOLLOW_extractFunction_in_function663);
                    extractFunction32=extractFunction();

                    state._fsp--;


                    // TEMPLATE REWRITE
                    // 171:20: -> {$extractFunction.st}
                    {
                        retval.st = (extractFunction32!=null?extractFunction32.st:null);
                    }



                    }
                    break;
                case 17 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:172:4: positionFunction
                    {
                    pushFollow(FOLLOW_positionFunction_in_function672);
                    positionFunction33=positionFunction();

                    state._fsp--;


                    // TEMPLATE REWRITE
                    // 172:21: -> {$positionFunction.st}
                    {
                        retval.st = (positionFunction33!=null?positionFunction33.st:null);
                    }



                    }
                    break;
                case 18 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:173:4: charLengthFunction
                    {
                    pushFollow(FOLLOW_charLengthFunction_in_function681);
                    charLengthFunction34=charLengthFunction();

                    state._fsp--;


                    // TEMPLATE REWRITE
                    // 173:23: -> {$charLengthFunction.st}
                    {
                        retval.st = (charLengthFunction34!=null?charLengthFunction34.st:null);
                    }



                    }
                    break;
                case 19 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:174:4: octetLengthFunction
                    {
                    pushFollow(FOLLOW_octetLengthFunction_in_function690);
                    octetLengthFunction35=octetLengthFunction();

                    state._fsp--;


                    // TEMPLATE REWRITE
                    // 174:24: -> {$octetLengthFunction.st}
                    {
                        retval.st = (octetLengthFunction35!=null?octetLengthFunction35.st:null);
                    }



                    }
                    break;
                case 20 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:175:4: bitLengthFunction
                    {
                    pushFollow(FOLLOW_bitLengthFunction_in_function699);
                    bitLengthFunction36=bitLengthFunction();

                    state._fsp--;


                    // TEMPLATE REWRITE
                    // 175:22: -> {$bitLengthFunction.st}
                    {
                        retval.st = (bitLengthFunction36!=null?bitLengthFunction36.st:null);
                    }



                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "function"


    public static class functionFunction_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "functionFunction"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:178:1: functionFunction : ^( FUNCTION (args+= functionArgument )* ) -> { basicFunctionTemplate( $FUNCTION.text, $args ) };
    public final OrderByRenderer.functionFunction_return functionFunction() throws RecognitionException {
        OrderByRenderer.functionFunction_return retval = new OrderByRenderer.functionFunction_return();
        retval.start = input.LT(1);


        CommonTree FUNCTION37=null;
        List list_args=null;
        RuleReturnScope args = null;
        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:179:5: ( ^( FUNCTION (args+= functionArgument )* ) -> { basicFunctionTemplate( $FUNCTION.text, $args ) })
            // org/hibernate/hql/ast/render/OrderByRenderer.g:179:7: ^( FUNCTION (args+= functionArgument )* )
            {
            FUNCTION37=(CommonTree)match(input,FUNCTION,FOLLOW_FUNCTION_in_functionFunction722); 

            if ( input.LA(1)==Token.DOWN ) {
                match(input, Token.DOWN, null); 
                // org/hibernate/hql/ast/render/OrderByRenderer.g:179:23: (args+= functionArgument )*
                loop8:
                do {
                    int alt8=2;
                    int LA8_0 = input.LA(1);

                    if ( (LA8_0==ABS||LA8_0==BIT_LENGTH||(LA8_0 >= CAST && LA8_0 <= CHARACTER_LITERAL)||LA8_0==COLUMN||LA8_0==CONCAT||(LA8_0 >= CURRENT_DATE && LA8_0 <= CURRENT_TIMESTAMP)||LA8_0==DECIMAL_LITERAL||LA8_0==EXTRACT||LA8_0==FLOATING_POINT_LITERAL||LA8_0==FUNCTION||LA8_0==HEX_LITERAL||LA8_0==INTEGER_LITERAL||LA8_0==LENGTH||(LA8_0 >= LOCATE && LA8_0 <= LOWER)||LA8_0==MOD||(LA8_0 >= OCTAL_LITERAL && LA8_0 <= OCTET_LENGTH)||LA8_0==POSITION||(LA8_0 >= SQRT && LA8_0 <= SUBSTRING)||LA8_0==TRIM||(LA8_0 >= UPPER && LA8_0 <= VECTOR_EXPR)) ) {
                        alt8=1;
                    }


                    switch (alt8) {
                	case 1 :
                	    // org/hibernate/hql/ast/render/OrderByRenderer.g:179:23: args+= functionArgument
                	    {
                	    pushFollow(FOLLOW_functionArgument_in_functionFunction726);
                	    args=functionArgument();

                	    state._fsp--;

                	    if (list_args==null) list_args=new ArrayList();
                	    list_args.add(args.getTemplate());


                	    }
                	    break;

                	default :
                	    break loop8;
                    }
                } while (true);


                match(input, Token.UP, null); 
            }


            // TEMPLATE REWRITE
            // 180:9: -> { basicFunctionTemplate( $FUNCTION.text, $args ) }
            {
                retval.st =  basicFunctionTemplate( (FUNCTION37!=null?FUNCTION37.getText():null), list_args ) ;
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "functionFunction"


    public static class functionArgument_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "functionArgument"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:183:1: functionArgument : expression -> {$expression.st};
    public final OrderByRenderer.functionArgument_return functionArgument() throws RecognitionException {
        OrderByRenderer.functionArgument_return retval = new OrderByRenderer.functionArgument_return();
        retval.start = input.LT(1);


        OrderByRenderer.expression_return expression38 =null;


        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:184:5: ( expression -> {$expression.st})
            // org/hibernate/hql/ast/render/OrderByRenderer.g:184:7: expression
            {
            pushFollow(FOLLOW_expression_in_functionArgument758);
            expression38=expression();

            state._fsp--;


            // TEMPLATE REWRITE
            // 184:18: -> {$expression.st}
            {
                retval.st = (expression38!=null?expression38.st:null);
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "functionArgument"


    public static class castFunction_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "castFunction"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:187:1: castFunction : ^( CAST valueExpression IDENTIFIER ) -> { castFunctionTemplate( $valueExpression.st, $IDENTIFIER.text ) };
    public final OrderByRenderer.castFunction_return castFunction() throws RecognitionException {
        OrderByRenderer.castFunction_return retval = new OrderByRenderer.castFunction_return();
        retval.start = input.LT(1);


        CommonTree IDENTIFIER40=null;
        OrderByRenderer.valueExpression_return valueExpression39 =null;


        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:188:5: ( ^( CAST valueExpression IDENTIFIER ) -> { castFunctionTemplate( $valueExpression.st, $IDENTIFIER.text ) })
            // org/hibernate/hql/ast/render/OrderByRenderer.g:188:7: ^( CAST valueExpression IDENTIFIER )
            {
            match(input,CAST,FOLLOW_CAST_in_castFunction777); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_valueExpression_in_castFunction779);
            valueExpression39=valueExpression();

            state._fsp--;


            IDENTIFIER40=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_castFunction781); 

            match(input, Token.UP, null); 


            // TEMPLATE REWRITE
            // 189:9: -> { castFunctionTemplate( $valueExpression.st, $IDENTIFIER.text ) }
            {
                retval.st =  castFunctionTemplate( (valueExpression39!=null?valueExpression39.st:null), (IDENTIFIER40!=null?IDENTIFIER40.getText():null) ) ;
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "castFunction"


    public static class concatFunction_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "concatFunction"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:192:1: concatFunction : ^( CONCAT (args+= valueExpression )+ ) -> { basicFunctionTemplate( $CONCAT.text, $args ) };
    public final OrderByRenderer.concatFunction_return concatFunction() throws RecognitionException {
        OrderByRenderer.concatFunction_return retval = new OrderByRenderer.concatFunction_return();
        retval.start = input.LT(1);


        CommonTree CONCAT41=null;
        List list_args=null;
        RuleReturnScope args = null;
        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:193:2: ( ^( CONCAT (args+= valueExpression )+ ) -> { basicFunctionTemplate( $CONCAT.text, $args ) })
            // org/hibernate/hql/ast/render/OrderByRenderer.g:193:4: ^( CONCAT (args+= valueExpression )+ )
            {
            CONCAT41=(CommonTree)match(input,CONCAT,FOLLOW_CONCAT_in_concatFunction811); 

            match(input, Token.DOWN, null); 
            // org/hibernate/hql/ast/render/OrderByRenderer.g:193:18: (args+= valueExpression )+
            int cnt9=0;
            loop9:
            do {
                int alt9=2;
                int LA9_0 = input.LA(1);

                if ( (LA9_0==ABS||LA9_0==BIT_LENGTH||(LA9_0 >= CAST && LA9_0 <= CHARACTER_LITERAL)||LA9_0==COLUMN||LA9_0==CONCAT||(LA9_0 >= CURRENT_DATE && LA9_0 <= CURRENT_TIMESTAMP)||LA9_0==DECIMAL_LITERAL||LA9_0==EXTRACT||LA9_0==FLOATING_POINT_LITERAL||LA9_0==FUNCTION||LA9_0==HEX_LITERAL||LA9_0==INTEGER_LITERAL||LA9_0==LENGTH||(LA9_0 >= LOCATE && LA9_0 <= LOWER)||LA9_0==MOD||(LA9_0 >= OCTAL_LITERAL && LA9_0 <= OCTET_LENGTH)||LA9_0==POSITION||(LA9_0 >= SQRT && LA9_0 <= SUBSTRING)||LA9_0==TRIM||(LA9_0 >= UPPER && LA9_0 <= VECTOR_EXPR)) ) {
                    alt9=1;
                }


                switch (alt9) {
            	case 1 :
            	    // org/hibernate/hql/ast/render/OrderByRenderer.g:193:18: args+= valueExpression
            	    {
            	    pushFollow(FOLLOW_valueExpression_in_concatFunction815);
            	    args=valueExpression();

            	    state._fsp--;

            	    if (list_args==null) list_args=new ArrayList();
            	    list_args.add(args.getTemplate());


            	    }
            	    break;

            	default :
            	    if ( cnt9 >= 1 ) break loop9;
                        EarlyExitException eee =
                            new EarlyExitException(9, input);
                        throw eee;
                }
                cnt9++;
            } while (true);


            match(input, Token.UP, null); 


            // TEMPLATE REWRITE
            // 194:9: -> { basicFunctionTemplate( $CONCAT.text, $args ) }
            {
                retval.st =  basicFunctionTemplate( (CONCAT41!=null?CONCAT41.getText():null), list_args ) ;
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "concatFunction"


    public static class substringFunction_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "substringFunction"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:197:1: substringFunction : ^( SUBSTRING args+= characterValueExpression args+= numericValueExpression (args+= numericValueExpression )? ) -> { basicFunctionTemplate( $SUBSTRING.text, $args ) };
    public final OrderByRenderer.substringFunction_return substringFunction() throws RecognitionException {
        OrderByRenderer.substringFunction_return retval = new OrderByRenderer.substringFunction_return();
        retval.start = input.LT(1);


        CommonTree SUBSTRING42=null;
        List list_args=null;
        RuleReturnScope args = null;
        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:198:5: ( ^( SUBSTRING args+= characterValueExpression args+= numericValueExpression (args+= numericValueExpression )? ) -> { basicFunctionTemplate( $SUBSTRING.text, $args ) })
            // org/hibernate/hql/ast/render/OrderByRenderer.g:198:7: ^( SUBSTRING args+= characterValueExpression args+= numericValueExpression (args+= numericValueExpression )? )
            {
            SUBSTRING42=(CommonTree)match(input,SUBSTRING,FOLLOW_SUBSTRING_in_substringFunction846); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_characterValueExpression_in_substringFunction850);
            args=characterValueExpression();

            state._fsp--;

            if (list_args==null) list_args=new ArrayList();
            list_args.add(args.getTemplate());


            pushFollow(FOLLOW_numericValueExpression_in_substringFunction854);
            args=numericValueExpression();

            state._fsp--;

            if (list_args==null) list_args=new ArrayList();
            list_args.add(args.getTemplate());


            // org/hibernate/hql/ast/render/OrderByRenderer.g:198:84: (args+= numericValueExpression )?
            int alt10=2;
            int LA10_0 = input.LA(1);

            if ( (LA10_0==ABS||LA10_0==BIT_LENGTH||(LA10_0 >= CAST && LA10_0 <= CHARACTER_LITERAL)||LA10_0==COLUMN||LA10_0==CONCAT||(LA10_0 >= CURRENT_DATE && LA10_0 <= CURRENT_TIMESTAMP)||LA10_0==DECIMAL_LITERAL||LA10_0==EXTRACT||LA10_0==FLOATING_POINT_LITERAL||LA10_0==FUNCTION||LA10_0==HEX_LITERAL||LA10_0==INTEGER_LITERAL||LA10_0==LENGTH||(LA10_0 >= LOCATE && LA10_0 <= LOWER)||LA10_0==MOD||(LA10_0 >= OCTAL_LITERAL && LA10_0 <= OCTET_LENGTH)||LA10_0==POSITION||(LA10_0 >= SQRT && LA10_0 <= SUBSTRING)||LA10_0==TRIM||(LA10_0 >= UPPER && LA10_0 <= VECTOR_EXPR)) ) {
                alt10=1;
            }
            switch (alt10) {
                case 1 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:198:84: args+= numericValueExpression
                    {
                    pushFollow(FOLLOW_numericValueExpression_in_substringFunction858);
                    args=numericValueExpression();

                    state._fsp--;

                    if (list_args==null) list_args=new ArrayList();
                    list_args.add(args.getTemplate());


                    }
                    break;

            }


            match(input, Token.UP, null); 


            // TEMPLATE REWRITE
            // 199:9: -> { basicFunctionTemplate( $SUBSTRING.text, $args ) }
            {
                retval.st =  basicFunctionTemplate( (SUBSTRING42!=null?SUBSTRING42.getText():null), list_args ) ;
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "substringFunction"


    public static class trimFunction_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "trimFunction"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:202:1: trimFunction : ^( TRIM ^( trimSpec trimChar trimSource ) ) -> { trimFunctionTemplate( $trimSpec.st, $trimChar.st, $trimSource.st ) };
    public final OrderByRenderer.trimFunction_return trimFunction() throws RecognitionException {
        OrderByRenderer.trimFunction_return retval = new OrderByRenderer.trimFunction_return();
        retval.start = input.LT(1);


        OrderByRenderer.trimSpec_return trimSpec43 =null;

        OrderByRenderer.trimChar_return trimChar44 =null;

        OrderByRenderer.trimSource_return trimSource45 =null;


        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:203:5: ( ^( TRIM ^( trimSpec trimChar trimSource ) ) -> { trimFunctionTemplate( $trimSpec.st, $trimChar.st, $trimSource.st ) })
            // org/hibernate/hql/ast/render/OrderByRenderer.g:203:7: ^( TRIM ^( trimSpec trimChar trimSource ) )
            {
            match(input,TRIM,FOLLOW_TRIM_in_trimFunction892); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_trimSpec_in_trimFunction896);
            trimSpec43=trimSpec();

            state._fsp--;


            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_trimChar_in_trimFunction898);
            trimChar44=trimChar();

            state._fsp--;


            pushFollow(FOLLOW_trimSource_in_trimFunction900);
            trimSource45=trimSource();

            state._fsp--;


            match(input, Token.UP, null); 


            match(input, Token.UP, null); 


            // TEMPLATE REWRITE
            // 204:9: -> { trimFunctionTemplate( $trimSpec.st, $trimChar.st, $trimSource.st ) }
            {
                retval.st =  trimFunctionTemplate( (trimSpec43!=null?trimSpec43.st:null), (trimChar44!=null?trimChar44.st:null), (trimSource45!=null?trimSource45.st:null) ) ;
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "trimFunction"


    public static class trimSpec_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "trimSpec"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:207:1: trimSpec : ( LEADING -> {%{\"leading\"}}| TRAILING -> {%{\"trailing\"}}| BOTH -> {%{\"both\"}});
    public final OrderByRenderer.trimSpec_return trimSpec() throws RecognitionException {
        OrderByRenderer.trimSpec_return retval = new OrderByRenderer.trimSpec_return();
        retval.start = input.LT(1);


        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:208:5: ( LEADING -> {%{\"leading\"}}| TRAILING -> {%{\"trailing\"}}| BOTH -> {%{\"both\"}})
            int alt11=3;
            switch ( input.LA(1) ) {
            case LEADING:
                {
                alt11=1;
                }
                break;
            case TRAILING:
                {
                alt11=2;
                }
                break;
            case BOTH:
                {
                alt11=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 11, 0, input);

                throw nvae;

            }

            switch (alt11) {
                case 1 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:208:7: LEADING
                    {
                    match(input,LEADING,FOLLOW_LEADING_in_trimSpec933); 

                    // TEMPLATE REWRITE
                    // 208:17: -> {%{\"leading\"}}
                    {
                        retval.st = new StringTemplate(templateLib,"leading");
                    }



                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:209:7: TRAILING
                    {
                    match(input,TRAILING,FOLLOW_TRAILING_in_trimSpec947); 

                    // TEMPLATE REWRITE
                    // 209:17: -> {%{\"trailing\"}}
                    {
                        retval.st = new StringTemplate(templateLib,"trailing");
                    }



                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:210:7: BOTH
                    {
                    match(input,BOTH,FOLLOW_BOTH_in_trimSpec960); 

                    // TEMPLATE REWRITE
                    // 210:17: -> {%{\"both\"}}
                    {
                        retval.st = new StringTemplate(templateLib,"both");
                    }



                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "trimSpec"


    public static class trimChar_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "trimChar"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:213:1: trimChar : characterValueExpression -> { $characterValueExpression.st };
    public final OrderByRenderer.trimChar_return trimChar() throws RecognitionException {
        OrderByRenderer.trimChar_return retval = new OrderByRenderer.trimChar_return();
        retval.start = input.LT(1);


        OrderByRenderer.characterValueExpression_return characterValueExpression46 =null;


        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:214:5: ( characterValueExpression -> { $characterValueExpression.st })
            // org/hibernate/hql/ast/render/OrderByRenderer.g:214:7: characterValueExpression
            {
            pushFollow(FOLLOW_characterValueExpression_in_trimChar986);
            characterValueExpression46=characterValueExpression();

            state._fsp--;


            // TEMPLATE REWRITE
            // 214:32: -> { $characterValueExpression.st }
            {
                retval.st =  (characterValueExpression46!=null?characterValueExpression46.st:null) ;
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "trimChar"


    public static class trimSource_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "trimSource"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:217:1: trimSource : characterValueExpression -> { $characterValueExpression.st };
    public final OrderByRenderer.trimSource_return trimSource() throws RecognitionException {
        OrderByRenderer.trimSource_return retval = new OrderByRenderer.trimSource_return();
        retval.start = input.LT(1);


        OrderByRenderer.characterValueExpression_return characterValueExpression47 =null;


        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:218:5: ( characterValueExpression -> { $characterValueExpression.st })
            // org/hibernate/hql/ast/render/OrderByRenderer.g:218:7: characterValueExpression
            {
            pushFollow(FOLLOW_characterValueExpression_in_trimSource1007);
            characterValueExpression47=characterValueExpression();

            state._fsp--;


            // TEMPLATE REWRITE
            // 218:32: -> { $characterValueExpression.st }
            {
                retval.st =  (characterValueExpression47!=null?characterValueExpression47.st:null) ;
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "trimSource"


    public static class upperFunction_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "upperFunction"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:221:1: upperFunction : ^( UPPER args+= characterValueExpression ) -> { basicFunctionTemplate( $UPPER.text, $args ) };
    public final OrderByRenderer.upperFunction_return upperFunction() throws RecognitionException {
        OrderByRenderer.upperFunction_return retval = new OrderByRenderer.upperFunction_return();
        retval.start = input.LT(1);


        CommonTree UPPER48=null;
        List list_args=null;
        RuleReturnScope args = null;
        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:222:5: ( ^( UPPER args+= characterValueExpression ) -> { basicFunctionTemplate( $UPPER.text, $args ) })
            // org/hibernate/hql/ast/render/OrderByRenderer.g:222:7: ^( UPPER args+= characterValueExpression )
            {
            UPPER48=(CommonTree)match(input,UPPER,FOLLOW_UPPER_in_upperFunction1030); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_characterValueExpression_in_upperFunction1034);
            args=characterValueExpression();

            state._fsp--;

            if (list_args==null) list_args=new ArrayList();
            list_args.add(args.getTemplate());


            match(input, Token.UP, null); 


            // TEMPLATE REWRITE
            // 223:9: -> { basicFunctionTemplate( $UPPER.text, $args ) }
            {
                retval.st =  basicFunctionTemplate( (UPPER48!=null?UPPER48.getText():null), list_args ) ;
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "upperFunction"


    public static class lowerFunction_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "lowerFunction"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:226:1: lowerFunction : ^( LOWER args+= characterValueExpression ) -> { basicFunctionTemplate( $LOWER.text, $args ) };
    public final OrderByRenderer.lowerFunction_return lowerFunction() throws RecognitionException {
        OrderByRenderer.lowerFunction_return retval = new OrderByRenderer.lowerFunction_return();
        retval.start = input.LT(1);


        CommonTree LOWER49=null;
        List list_args=null;
        RuleReturnScope args = null;
        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:227:5: ( ^( LOWER args+= characterValueExpression ) -> { basicFunctionTemplate( $LOWER.text, $args ) })
            // org/hibernate/hql/ast/render/OrderByRenderer.g:227:7: ^( LOWER args+= characterValueExpression )
            {
            LOWER49=(CommonTree)match(input,LOWER,FOLLOW_LOWER_in_lowerFunction1067); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_characterValueExpression_in_lowerFunction1071);
            args=characterValueExpression();

            state._fsp--;

            if (list_args==null) list_args=new ArrayList();
            list_args.add(args.getTemplate());


            match(input, Token.UP, null); 


            // TEMPLATE REWRITE
            // 228:9: -> { basicFunctionTemplate( $LOWER.text, $args ) }
            {
                retval.st =  basicFunctionTemplate( (LOWER49!=null?LOWER49.getText():null), list_args ) ;
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "lowerFunction"


    public static class lengthFunction_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "lengthFunction"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:231:1: lengthFunction : ^( LENGTH args+= characterValueExpression ) -> { basicFunctionTemplate( $LENGTH.text, $args ) };
    public final OrderByRenderer.lengthFunction_return lengthFunction() throws RecognitionException {
        OrderByRenderer.lengthFunction_return retval = new OrderByRenderer.lengthFunction_return();
        retval.start = input.LT(1);


        CommonTree LENGTH50=null;
        List list_args=null;
        RuleReturnScope args = null;
        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:232:5: ( ^( LENGTH args+= characterValueExpression ) -> { basicFunctionTemplate( $LENGTH.text, $args ) })
            // org/hibernate/hql/ast/render/OrderByRenderer.g:232:7: ^( LENGTH args+= characterValueExpression )
            {
            LENGTH50=(CommonTree)match(input,LENGTH,FOLLOW_LENGTH_in_lengthFunction1104); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_characterValueExpression_in_lengthFunction1108);
            args=characterValueExpression();

            state._fsp--;

            if (list_args==null) list_args=new ArrayList();
            list_args.add(args.getTemplate());


            match(input, Token.UP, null); 


            // TEMPLATE REWRITE
            // 233:9: -> { basicFunctionTemplate( $LENGTH.text, $args ) }
            {
                retval.st =  basicFunctionTemplate( (LENGTH50!=null?LENGTH50.getText():null), list_args ) ;
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "lengthFunction"


    public static class locateFunction_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "locateFunction"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:236:1: locateFunction : ^( LOCATE args+= characterValueExpression args+= characterValueExpression (args+= numericValueExpression )? ) -> { basicFunctionTemplate( $LOCATE.text, $args ) };
    public final OrderByRenderer.locateFunction_return locateFunction() throws RecognitionException {
        OrderByRenderer.locateFunction_return retval = new OrderByRenderer.locateFunction_return();
        retval.start = input.LT(1);


        CommonTree LOCATE51=null;
        List list_args=null;
        RuleReturnScope args = null;
        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:237:5: ( ^( LOCATE args+= characterValueExpression args+= characterValueExpression (args+= numericValueExpression )? ) -> { basicFunctionTemplate( $LOCATE.text, $args ) })
            // org/hibernate/hql/ast/render/OrderByRenderer.g:237:7: ^( LOCATE args+= characterValueExpression args+= characterValueExpression (args+= numericValueExpression )? )
            {
            LOCATE51=(CommonTree)match(input,LOCATE,FOLLOW_LOCATE_in_locateFunction1141); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_characterValueExpression_in_locateFunction1145);
            args=characterValueExpression();

            state._fsp--;

            if (list_args==null) list_args=new ArrayList();
            list_args.add(args.getTemplate());


            pushFollow(FOLLOW_characterValueExpression_in_locateFunction1149);
            args=characterValueExpression();

            state._fsp--;

            if (list_args==null) list_args=new ArrayList();
            list_args.add(args.getTemplate());


            // org/hibernate/hql/ast/render/OrderByRenderer.g:237:83: (args+= numericValueExpression )?
            int alt12=2;
            int LA12_0 = input.LA(1);

            if ( (LA12_0==ABS||LA12_0==BIT_LENGTH||(LA12_0 >= CAST && LA12_0 <= CHARACTER_LITERAL)||LA12_0==COLUMN||LA12_0==CONCAT||(LA12_0 >= CURRENT_DATE && LA12_0 <= CURRENT_TIMESTAMP)||LA12_0==DECIMAL_LITERAL||LA12_0==EXTRACT||LA12_0==FLOATING_POINT_LITERAL||LA12_0==FUNCTION||LA12_0==HEX_LITERAL||LA12_0==INTEGER_LITERAL||LA12_0==LENGTH||(LA12_0 >= LOCATE && LA12_0 <= LOWER)||LA12_0==MOD||(LA12_0 >= OCTAL_LITERAL && LA12_0 <= OCTET_LENGTH)||LA12_0==POSITION||(LA12_0 >= SQRT && LA12_0 <= SUBSTRING)||LA12_0==TRIM||(LA12_0 >= UPPER && LA12_0 <= VECTOR_EXPR)) ) {
                alt12=1;
            }
            switch (alt12) {
                case 1 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:237:83: args+= numericValueExpression
                    {
                    pushFollow(FOLLOW_numericValueExpression_in_locateFunction1153);
                    args=numericValueExpression();

                    state._fsp--;

                    if (list_args==null) list_args=new ArrayList();
                    list_args.add(args.getTemplate());


                    }
                    break;

            }


            match(input, Token.UP, null); 


            // TEMPLATE REWRITE
            // 238:9: -> { basicFunctionTemplate( $LOCATE.text, $args ) }
            {
                retval.st =  basicFunctionTemplate( (LOCATE51!=null?LOCATE51.getText():null), list_args ) ;
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "locateFunction"


    public static class absFunction_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "absFunction"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:241:1: absFunction : ^( ABS args+= expression ) -> { basicFunctionTemplate( $ABS.text, $args ) };
    public final OrderByRenderer.absFunction_return absFunction() throws RecognitionException {
        OrderByRenderer.absFunction_return retval = new OrderByRenderer.absFunction_return();
        retval.start = input.LT(1);


        CommonTree ABS52=null;
        List list_args=null;
        RuleReturnScope args = null;
        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:242:5: ( ^( ABS args+= expression ) -> { basicFunctionTemplate( $ABS.text, $args ) })
            // org/hibernate/hql/ast/render/OrderByRenderer.g:242:7: ^( ABS args+= expression )
            {
            ABS52=(CommonTree)match(input,ABS,FOLLOW_ABS_in_absFunction1187); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_expression_in_absFunction1191);
            args=expression();

            state._fsp--;

            if (list_args==null) list_args=new ArrayList();
            list_args.add(args.getTemplate());


            match(input, Token.UP, null); 


            // TEMPLATE REWRITE
            // 243:9: -> { basicFunctionTemplate( $ABS.text, $args ) }
            {
                retval.st =  basicFunctionTemplate( (ABS52!=null?ABS52.getText():null), list_args ) ;
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "absFunction"


    public static class sqrtFunction_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "sqrtFunction"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:246:1: sqrtFunction : ^( SQRT args+= expression ) -> { basicFunctionTemplate( $SQRT.text, $args ) };
    public final OrderByRenderer.sqrtFunction_return sqrtFunction() throws RecognitionException {
        OrderByRenderer.sqrtFunction_return retval = new OrderByRenderer.sqrtFunction_return();
        retval.start = input.LT(1);


        CommonTree SQRT53=null;
        List list_args=null;
        RuleReturnScope args = null;
        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:247:5: ( ^( SQRT args+= expression ) -> { basicFunctionTemplate( $SQRT.text, $args ) })
            // org/hibernate/hql/ast/render/OrderByRenderer.g:247:7: ^( SQRT args+= expression )
            {
            SQRT53=(CommonTree)match(input,SQRT,FOLLOW_SQRT_in_sqrtFunction1224); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_expression_in_sqrtFunction1228);
            args=expression();

            state._fsp--;

            if (list_args==null) list_args=new ArrayList();
            list_args.add(args.getTemplate());


            match(input, Token.UP, null); 


            // TEMPLATE REWRITE
            // 248:9: -> { basicFunctionTemplate( $SQRT.text, $args ) }
            {
                retval.st =  basicFunctionTemplate( (SQRT53!=null?SQRT53.getText():null), list_args ) ;
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "sqrtFunction"


    public static class modFunction_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "modFunction"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:251:1: modFunction : ^( MOD args+= expression args+= expression ) -> { basicFunctionTemplate( $MOD.text, $args ) };
    public final OrderByRenderer.modFunction_return modFunction() throws RecognitionException {
        OrderByRenderer.modFunction_return retval = new OrderByRenderer.modFunction_return();
        retval.start = input.LT(1);


        CommonTree MOD54=null;
        List list_args=null;
        RuleReturnScope args = null;
        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:252:5: ( ^( MOD args+= expression args+= expression ) -> { basicFunctionTemplate( $MOD.text, $args ) })
            // org/hibernate/hql/ast/render/OrderByRenderer.g:252:7: ^( MOD args+= expression args+= expression )
            {
            MOD54=(CommonTree)match(input,MOD,FOLLOW_MOD_in_modFunction1261); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_expression_in_modFunction1265);
            args=expression();

            state._fsp--;

            if (list_args==null) list_args=new ArrayList();
            list_args.add(args.getTemplate());


            pushFollow(FOLLOW_expression_in_modFunction1269);
            args=expression();

            state._fsp--;

            if (list_args==null) list_args=new ArrayList();
            list_args.add(args.getTemplate());


            match(input, Token.UP, null); 


            // TEMPLATE REWRITE
            // 253:9: -> { basicFunctionTemplate( $MOD.text, $args ) }
            {
                retval.st =  basicFunctionTemplate( (MOD54!=null?MOD54.getText():null), list_args ) ;
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "modFunction"


    public static class currentDateFunction_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "currentDateFunction"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:256:1: currentDateFunction : CURRENT_DATE -> { basicFunctionTemplate( $CURRENT_DATE.text, null ) };
    public final OrderByRenderer.currentDateFunction_return currentDateFunction() throws RecognitionException {
        OrderByRenderer.currentDateFunction_return retval = new OrderByRenderer.currentDateFunction_return();
        retval.start = input.LT(1);


        CommonTree CURRENT_DATE55=null;

        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:257:5: ( CURRENT_DATE -> { basicFunctionTemplate( $CURRENT_DATE.text, null ) })
            // org/hibernate/hql/ast/render/OrderByRenderer.g:257:7: CURRENT_DATE
            {
            CURRENT_DATE55=(CommonTree)match(input,CURRENT_DATE,FOLLOW_CURRENT_DATE_in_currentDateFunction1300); 

            // TEMPLATE REWRITE
            // 257:20: -> { basicFunctionTemplate( $CURRENT_DATE.text, null ) }
            {
                retval.st =  basicFunctionTemplate( (CURRENT_DATE55!=null?CURRENT_DATE55.getText():null), null ) ;
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "currentDateFunction"


    public static class currentTimeFunction_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "currentTimeFunction"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:260:1: currentTimeFunction : CURRENT_TIME -> { basicFunctionTemplate( $CURRENT_TIME.text, null ) };
    public final OrderByRenderer.currentTimeFunction_return currentTimeFunction() throws RecognitionException {
        OrderByRenderer.currentTimeFunction_return retval = new OrderByRenderer.currentTimeFunction_return();
        retval.start = input.LT(1);


        CommonTree CURRENT_TIME56=null;

        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:261:5: ( CURRENT_TIME -> { basicFunctionTemplate( $CURRENT_TIME.text, null ) })
            // org/hibernate/hql/ast/render/OrderByRenderer.g:261:7: CURRENT_TIME
            {
            CURRENT_TIME56=(CommonTree)match(input,CURRENT_TIME,FOLLOW_CURRENT_TIME_in_currentTimeFunction1321); 

            // TEMPLATE REWRITE
            // 261:20: -> { basicFunctionTemplate( $CURRENT_TIME.text, null ) }
            {
                retval.st =  basicFunctionTemplate( (CURRENT_TIME56!=null?CURRENT_TIME56.getText():null), null ) ;
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "currentTimeFunction"


    public static class currentTimestampFunction_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "currentTimestampFunction"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:264:1: currentTimestampFunction : CURRENT_TIMESTAMP -> { basicFunctionTemplate( $CURRENT_TIMESTAMP.text, null ) };
    public final OrderByRenderer.currentTimestampFunction_return currentTimestampFunction() throws RecognitionException {
        OrderByRenderer.currentTimestampFunction_return retval = new OrderByRenderer.currentTimestampFunction_return();
        retval.start = input.LT(1);


        CommonTree CURRENT_TIMESTAMP57=null;

        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:265:5: ( CURRENT_TIMESTAMP -> { basicFunctionTemplate( $CURRENT_TIMESTAMP.text, null ) })
            // org/hibernate/hql/ast/render/OrderByRenderer.g:265:7: CURRENT_TIMESTAMP
            {
            CURRENT_TIMESTAMP57=(CommonTree)match(input,CURRENT_TIMESTAMP,FOLLOW_CURRENT_TIMESTAMP_in_currentTimestampFunction1342); 

            // TEMPLATE REWRITE
            // 265:25: -> { basicFunctionTemplate( $CURRENT_TIMESTAMP.text, null ) }
            {
                retval.st =  basicFunctionTemplate( (CURRENT_TIMESTAMP57!=null?CURRENT_TIMESTAMP57.getText():null), null ) ;
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "currentTimestampFunction"


    public static class extractFunction_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "extractFunction"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:268:1: extractFunction : ^( EXTRACT extractField expression ) -> { extractFunctionTemplate( $extractField.st, $expression.st ) };
    public final OrderByRenderer.extractFunction_return extractFunction() throws RecognitionException {
        OrderByRenderer.extractFunction_return retval = new OrderByRenderer.extractFunction_return();
        retval.start = input.LT(1);


        OrderByRenderer.extractField_return extractField58 =null;

        OrderByRenderer.expression_return expression59 =null;


        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:269:5: ( ^( EXTRACT extractField expression ) -> { extractFunctionTemplate( $extractField.st, $expression.st ) })
            // org/hibernate/hql/ast/render/OrderByRenderer.g:269:7: ^( EXTRACT extractField expression )
            {
            match(input,EXTRACT,FOLLOW_EXTRACT_in_extractFunction1365); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_extractField_in_extractFunction1367);
            extractField58=extractField();

            state._fsp--;


            pushFollow(FOLLOW_expression_in_extractFunction1369);
            expression59=expression();

            state._fsp--;


            match(input, Token.UP, null); 


            // TEMPLATE REWRITE
            // 270:9: -> { extractFunctionTemplate( $extractField.st, $expression.st ) }
            {
                retval.st =  extractFunctionTemplate( (extractField58!=null?extractField58.st:null), (expression59!=null?expression59.st:null) ) ;
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "extractFunction"


    public static class extractField_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "extractField"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:273:1: extractField : ( datetimeField | timeZoneField );
    public final OrderByRenderer.extractField_return extractField() throws RecognitionException {
        OrderByRenderer.extractField_return retval = new OrderByRenderer.extractField_return();
        retval.start = input.LT(1);


        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:274:2: ( datetimeField | timeZoneField )
            int alt13=2;
            int LA13_0 = input.LA(1);

            if ( (LA13_0==DAY||LA13_0==HOUR||LA13_0==MINUTE||LA13_0==MONTH||LA13_0==SECOND||LA13_0==YEAR) ) {
                alt13=1;
            }
            else if ( ((LA13_0 >= TIMEZONE_HOUR && LA13_0 <= TIMEZONE_MINUTE)) ) {
                alt13=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 13, 0, input);

                throw nvae;

            }
            switch (alt13) {
                case 1 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:274:4: datetimeField
                    {
                    pushFollow(FOLLOW_datetimeField_in_extractField1397);
                    datetimeField();

                    state._fsp--;


                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:275:4: timeZoneField
                    {
                    pushFollow(FOLLOW_timeZoneField_in_extractField1402);
                    timeZoneField();

                    state._fsp--;


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "extractField"


    public static class datetimeField_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "datetimeField"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:278:1: datetimeField : ( YEAR -> {%{\"year\"}}| MONTH -> {%{\"month\"}}| DAY -> {%{\"day\"}}| HOUR -> {%{\"hour\"}}| MINUTE -> {%{\"minute\"}}| SECOND -> {%{\"second\"}});
    public final OrderByRenderer.datetimeField_return datetimeField() throws RecognitionException {
        OrderByRenderer.datetimeField_return retval = new OrderByRenderer.datetimeField_return();
        retval.start = input.LT(1);


        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:279:2: ( YEAR -> {%{\"year\"}}| MONTH -> {%{\"month\"}}| DAY -> {%{\"day\"}}| HOUR -> {%{\"hour\"}}| MINUTE -> {%{\"minute\"}}| SECOND -> {%{\"second\"}})
            int alt14=6;
            switch ( input.LA(1) ) {
            case YEAR:
                {
                alt14=1;
                }
                break;
            case MONTH:
                {
                alt14=2;
                }
                break;
            case DAY:
                {
                alt14=3;
                }
                break;
            case HOUR:
                {
                alt14=4;
                }
                break;
            case MINUTE:
                {
                alt14=5;
                }
                break;
            case SECOND:
                {
                alt14=6;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 14, 0, input);

                throw nvae;

            }

            switch (alt14) {
                case 1 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:279:4: YEAR
                    {
                    match(input,YEAR,FOLLOW_YEAR_in_datetimeField1413); 

                    // TEMPLATE REWRITE
                    // 279:12: -> {%{\"year\"}}
                    {
                        retval.st = new StringTemplate(templateLib,"year");
                    }



                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:280:4: MONTH
                    {
                    match(input,MONTH,FOLLOW_MONTH_in_datetimeField1425); 

                    // TEMPLATE REWRITE
                    // 280:12: -> {%{\"month\"}}
                    {
                        retval.st = new StringTemplate(templateLib,"month");
                    }



                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:281:4: DAY
                    {
                    match(input,DAY,FOLLOW_DAY_in_datetimeField1436); 

                    // TEMPLATE REWRITE
                    // 281:12: -> {%{\"day\"}}
                    {
                        retval.st = new StringTemplate(templateLib,"day");
                    }



                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:282:4: HOUR
                    {
                    match(input,HOUR,FOLLOW_HOUR_in_datetimeField1449); 

                    // TEMPLATE REWRITE
                    // 282:12: -> {%{\"hour\"}}
                    {
                        retval.st = new StringTemplate(templateLib,"hour");
                    }



                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:283:4: MINUTE
                    {
                    match(input,MINUTE,FOLLOW_MINUTE_in_datetimeField1461); 

                    // TEMPLATE REWRITE
                    // 283:12: -> {%{\"minute\"}}
                    {
                        retval.st = new StringTemplate(templateLib,"minute");
                    }



                    }
                    break;
                case 6 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:284:4: SECOND
                    {
                    match(input,SECOND,FOLLOW_SECOND_in_datetimeField1471); 

                    // TEMPLATE REWRITE
                    // 284:12: -> {%{\"second\"}}
                    {
                        retval.st = new StringTemplate(templateLib,"second");
                    }



                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "datetimeField"


    public static class timeZoneField_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "timeZoneField"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:287:1: timeZoneField : ( TIMEZONE_HOUR -> {%{\"timezone_hour\"}}| TIMEZONE_MINUTE -> {%{\"timezone_minute\"}});
    public final OrderByRenderer.timeZoneField_return timeZoneField() throws RecognitionException {
        OrderByRenderer.timeZoneField_return retval = new OrderByRenderer.timeZoneField_return();
        retval.start = input.LT(1);


        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:288:2: ( TIMEZONE_HOUR -> {%{\"timezone_hour\"}}| TIMEZONE_MINUTE -> {%{\"timezone_minute\"}})
            int alt15=2;
            int LA15_0 = input.LA(1);

            if ( (LA15_0==TIMEZONE_HOUR) ) {
                alt15=1;
            }
            else if ( (LA15_0==TIMEZONE_MINUTE) ) {
                alt15=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 15, 0, input);

                throw nvae;

            }
            switch (alt15) {
                case 1 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:288:4: TIMEZONE_HOUR
                    {
                    match(input,TIMEZONE_HOUR,FOLLOW_TIMEZONE_HOUR_in_timeZoneField1487); 

                    // TEMPLATE REWRITE
                    // 288:20: -> {%{\"timezone_hour\"}}
                    {
                        retval.st = new StringTemplate(templateLib,"timezone_hour");
                    }



                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:289:4: TIMEZONE_MINUTE
                    {
                    match(input,TIMEZONE_MINUTE,FOLLOW_TIMEZONE_MINUTE_in_timeZoneField1498); 

                    // TEMPLATE REWRITE
                    // 289:20: -> {%{\"timezone_minute\"}}
                    {
                        retval.st = new StringTemplate(templateLib,"timezone_minute");
                    }



                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "timeZoneField"


    public static class positionFunction_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "positionFunction"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:292:1: positionFunction : ^( POSITION s1= expression s2= expression ) -> { positionFunctionTemplate( $s1.st, $s2.st ) };
    public final OrderByRenderer.positionFunction_return positionFunction() throws RecognitionException {
        OrderByRenderer.positionFunction_return retval = new OrderByRenderer.positionFunction_return();
        retval.start = input.LT(1);


        OrderByRenderer.expression_return s1 =null;

        OrderByRenderer.expression_return s2 =null;


        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:293:5: ( ^( POSITION s1= expression s2= expression ) -> { positionFunctionTemplate( $s1.st, $s2.st ) })
            // org/hibernate/hql/ast/render/OrderByRenderer.g:293:7: ^( POSITION s1= expression s2= expression )
            {
            match(input,POSITION,FOLLOW_POSITION_in_positionFunction1518); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_expression_in_positionFunction1522);
            s1=expression();

            state._fsp--;


            pushFollow(FOLLOW_expression_in_positionFunction1526);
            s2=expression();

            state._fsp--;


            match(input, Token.UP, null); 


            // TEMPLATE REWRITE
            // 294:9: -> { positionFunctionTemplate( $s1.st, $s2.st ) }
            {
                retval.st =  positionFunctionTemplate( (s1!=null?s1.st:null), (s2!=null?s2.st:null) ) ;
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "positionFunction"


    public static class charLengthFunction_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "charLengthFunction"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:297:1: charLengthFunction : ^( CHARACTER_LENGTH args+= expression ) -> { basicFunctionTemplate( $CHARACTER_LENGTH.text, $args ) };
    public final OrderByRenderer.charLengthFunction_return charLengthFunction() throws RecognitionException {
        OrderByRenderer.charLengthFunction_return retval = new OrderByRenderer.charLengthFunction_return();
        retval.start = input.LT(1);


        CommonTree CHARACTER_LENGTH60=null;
        List list_args=null;
        RuleReturnScope args = null;
        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:298:5: ( ^( CHARACTER_LENGTH args+= expression ) -> { basicFunctionTemplate( $CHARACTER_LENGTH.text, $args ) })
            // org/hibernate/hql/ast/render/OrderByRenderer.g:298:7: ^( CHARACTER_LENGTH args+= expression )
            {
            CHARACTER_LENGTH60=(CommonTree)match(input,CHARACTER_LENGTH,FOLLOW_CHARACTER_LENGTH_in_charLengthFunction1559); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_expression_in_charLengthFunction1563);
            args=expression();

            state._fsp--;

            if (list_args==null) list_args=new ArrayList();
            list_args.add(args.getTemplate());


            match(input, Token.UP, null); 


            // TEMPLATE REWRITE
            // 299:10: -> { basicFunctionTemplate( $CHARACTER_LENGTH.text, $args ) }
            {
                retval.st =  basicFunctionTemplate( (CHARACTER_LENGTH60!=null?CHARACTER_LENGTH60.getText():null), list_args ) ;
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "charLengthFunction"


    public static class octetLengthFunction_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "octetLengthFunction"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:302:1: octetLengthFunction : ^( OCTET_LENGTH args+= expression ) -> { basicFunctionTemplate( $OCTET_LENGTH.text, $args ) };
    public final OrderByRenderer.octetLengthFunction_return octetLengthFunction() throws RecognitionException {
        OrderByRenderer.octetLengthFunction_return retval = new OrderByRenderer.octetLengthFunction_return();
        retval.start = input.LT(1);


        CommonTree OCTET_LENGTH61=null;
        List list_args=null;
        RuleReturnScope args = null;
        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:303:5: ( ^( OCTET_LENGTH args+= expression ) -> { basicFunctionTemplate( $OCTET_LENGTH.text, $args ) })
            // org/hibernate/hql/ast/render/OrderByRenderer.g:303:7: ^( OCTET_LENGTH args+= expression )
            {
            OCTET_LENGTH61=(CommonTree)match(input,OCTET_LENGTH,FOLLOW_OCTET_LENGTH_in_octetLengthFunction1597); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_expression_in_octetLengthFunction1601);
            args=expression();

            state._fsp--;

            if (list_args==null) list_args=new ArrayList();
            list_args.add(args.getTemplate());


            match(input, Token.UP, null); 


            // TEMPLATE REWRITE
            // 304:10: -> { basicFunctionTemplate( $OCTET_LENGTH.text, $args ) }
            {
                retval.st =  basicFunctionTemplate( (OCTET_LENGTH61!=null?OCTET_LENGTH61.getText():null), list_args ) ;
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "octetLengthFunction"


    public static class bitLengthFunction_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "bitLengthFunction"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:307:1: bitLengthFunction : ^( BIT_LENGTH args+= expression ) -> { basicFunctionTemplate( $BIT_LENGTH.text, $args ) };
    public final OrderByRenderer.bitLengthFunction_return bitLengthFunction() throws RecognitionException {
        OrderByRenderer.bitLengthFunction_return retval = new OrderByRenderer.bitLengthFunction_return();
        retval.start = input.LT(1);


        CommonTree BIT_LENGTH62=null;
        List list_args=null;
        RuleReturnScope args = null;
        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:308:5: ( ^( BIT_LENGTH args+= expression ) -> { basicFunctionTemplate( $BIT_LENGTH.text, $args ) })
            // org/hibernate/hql/ast/render/OrderByRenderer.g:308:7: ^( BIT_LENGTH args+= expression )
            {
            BIT_LENGTH62=(CommonTree)match(input,BIT_LENGTH,FOLLOW_BIT_LENGTH_in_bitLengthFunction1635); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_expression_in_bitLengthFunction1639);
            args=expression();

            state._fsp--;

            if (list_args==null) list_args=new ArrayList();
            list_args.add(args.getTemplate());


            match(input, Token.UP, null); 


            // TEMPLATE REWRITE
            // 309:10: -> { basicFunctionTemplate( $BIT_LENGTH.text, $args ) }
            {
                retval.st =  basicFunctionTemplate( (BIT_LENGTH62!=null?BIT_LENGTH62.getText():null), list_args ) ;
            }



            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "bitLengthFunction"


    public static class literal_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "literal"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:312:1: literal : ( numeric_literal -> {$numeric_literal.st}| HEX_LITERAL -> {%{$HEX_LITERAL.text}}| OCTAL_LITERAL -> {%{$OCTAL_LITERAL.text}}| CHARACTER_LITERAL -> {%{$CHARACTER_LITERAL.text}}| STRING_LITERAL -> {%{$STRING_LITERAL.text}});
    public final OrderByRenderer.literal_return literal() throws RecognitionException {
        OrderByRenderer.literal_return retval = new OrderByRenderer.literal_return();
        retval.start = input.LT(1);


        CommonTree HEX_LITERAL64=null;
        CommonTree OCTAL_LITERAL65=null;
        CommonTree CHARACTER_LITERAL66=null;
        CommonTree STRING_LITERAL67=null;
        OrderByRenderer.numeric_literal_return numeric_literal63 =null;


        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:313:2: ( numeric_literal -> {$numeric_literal.st}| HEX_LITERAL -> {%{$HEX_LITERAL.text}}| OCTAL_LITERAL -> {%{$OCTAL_LITERAL.text}}| CHARACTER_LITERAL -> {%{$CHARACTER_LITERAL.text}}| STRING_LITERAL -> {%{$STRING_LITERAL.text}})
            int alt16=5;
            switch ( input.LA(1) ) {
            case DECIMAL_LITERAL:
            case FLOATING_POINT_LITERAL:
            case INTEGER_LITERAL:
                {
                alt16=1;
                }
                break;
            case HEX_LITERAL:
                {
                alt16=2;
                }
                break;
            case OCTAL_LITERAL:
                {
                alt16=3;
                }
                break;
            case CHARACTER_LITERAL:
                {
                alt16=4;
                }
                break;
            case STRING_LITERAL:
                {
                alt16=5;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 16, 0, input);

                throw nvae;

            }

            switch (alt16) {
                case 1 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:313:4: numeric_literal
                    {
                    pushFollow(FOLLOW_numeric_literal_in_literal1668);
                    numeric_literal63=numeric_literal();

                    state._fsp--;


                    // TEMPLATE REWRITE
                    // 313:20: -> {$numeric_literal.st}
                    {
                        retval.st = (numeric_literal63!=null?numeric_literal63.st:null);
                    }



                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:314:4: HEX_LITERAL
                    {
                    HEX_LITERAL64=(CommonTree)match(input,HEX_LITERAL,FOLLOW_HEX_LITERAL_in_literal1677); 

                    // TEMPLATE REWRITE
                    // 314:16: -> {%{$HEX_LITERAL.text}}
                    {
                        retval.st = new StringTemplate(templateLib,(HEX_LITERAL64!=null?HEX_LITERAL64.getText():null));
                    }



                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:315:4: OCTAL_LITERAL
                    {
                    OCTAL_LITERAL65=(CommonTree)match(input,OCTAL_LITERAL,FOLLOW_OCTAL_LITERAL_in_literal1686); 

                    // TEMPLATE REWRITE
                    // 315:18: -> {%{$OCTAL_LITERAL.text}}
                    {
                        retval.st = new StringTemplate(templateLib,(OCTAL_LITERAL65!=null?OCTAL_LITERAL65.getText():null));
                    }



                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:316:4: CHARACTER_LITERAL
                    {
                    CHARACTER_LITERAL66=(CommonTree)match(input,CHARACTER_LITERAL,FOLLOW_CHARACTER_LITERAL_in_literal1695); 

                    // TEMPLATE REWRITE
                    // 316:22: -> {%{$CHARACTER_LITERAL.text}}
                    {
                        retval.st = new StringTemplate(templateLib,(CHARACTER_LITERAL66!=null?CHARACTER_LITERAL66.getText():null));
                    }



                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:317:4: STRING_LITERAL
                    {
                    STRING_LITERAL67=(CommonTree)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_literal1704); 

                    // TEMPLATE REWRITE
                    // 317:19: -> {%{$STRING_LITERAL.text}}
                    {
                        retval.st = new StringTemplate(templateLib,(STRING_LITERAL67!=null?STRING_LITERAL67.getText():null));
                    }



                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "literal"


    public static class numeric_literal_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };


    // $ANTLR start "numeric_literal"
    // org/hibernate/hql/ast/render/OrderByRenderer.g:320:1: numeric_literal : ( INTEGER_LITERAL -> {%{$INTEGER_LITERAL.text}}| DECIMAL_LITERAL -> {%{$DECIMAL_LITERAL.text}}| FLOATING_POINT_LITERAL -> {%{$FLOATING_POINT_LITERAL.text}});
    public final OrderByRenderer.numeric_literal_return numeric_literal() throws RecognitionException {
        OrderByRenderer.numeric_literal_return retval = new OrderByRenderer.numeric_literal_return();
        retval.start = input.LT(1);


        CommonTree INTEGER_LITERAL68=null;
        CommonTree DECIMAL_LITERAL69=null;
        CommonTree FLOATING_POINT_LITERAL70=null;

        try {
            // org/hibernate/hql/ast/render/OrderByRenderer.g:321:2: ( INTEGER_LITERAL -> {%{$INTEGER_LITERAL.text}}| DECIMAL_LITERAL -> {%{$DECIMAL_LITERAL.text}}| FLOATING_POINT_LITERAL -> {%{$FLOATING_POINT_LITERAL.text}})
            int alt17=3;
            switch ( input.LA(1) ) {
            case INTEGER_LITERAL:
                {
                alt17=1;
                }
                break;
            case DECIMAL_LITERAL:
                {
                alt17=2;
                }
                break;
            case FLOATING_POINT_LITERAL:
                {
                alt17=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 17, 0, input);

                throw nvae;

            }

            switch (alt17) {
                case 1 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:321:4: INTEGER_LITERAL
                    {
                    INTEGER_LITERAL68=(CommonTree)match(input,INTEGER_LITERAL,FOLLOW_INTEGER_LITERAL_in_numeric_literal1719); 

                    // TEMPLATE REWRITE
                    // 321:20: -> {%{$INTEGER_LITERAL.text}}
                    {
                        retval.st = new StringTemplate(templateLib,(INTEGER_LITERAL68!=null?INTEGER_LITERAL68.getText():null));
                    }



                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:322:4: DECIMAL_LITERAL
                    {
                    DECIMAL_LITERAL69=(CommonTree)match(input,DECIMAL_LITERAL,FOLLOW_DECIMAL_LITERAL_in_numeric_literal1728); 

                    // TEMPLATE REWRITE
                    // 322:20: -> {%{$DECIMAL_LITERAL.text}}
                    {
                        retval.st = new StringTemplate(templateLib,(DECIMAL_LITERAL69!=null?DECIMAL_LITERAL69.getText():null));
                    }



                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/render/OrderByRenderer.g:323:4: FLOATING_POINT_LITERAL
                    {
                    FLOATING_POINT_LITERAL70=(CommonTree)match(input,FLOATING_POINT_LITERAL,FOLLOW_FLOATING_POINT_LITERAL_in_numeric_literal1737); 

                    // TEMPLATE REWRITE
                    // 323:27: -> {%{$FLOATING_POINT_LITERAL.text}}
                    {
                        retval.st = new StringTemplate(templateLib,(FLOATING_POINT_LITERAL70!=null?FLOATING_POINT_LITERAL70.getText():null));
                    }



                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "numeric_literal"

    // Delegated rules


 

    public static final BitSet FOLLOW_ORDER_BY_in_orderByFragment62 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_sortSpecification_in_orderByFragment66 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000002000000000L});
    public static final BitSet FOLLOW_SORT_SPEC_in_sortSpecification108 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_sortKey_in_sortSpecification110 = new BitSet(new long[]{0x0000000001000008L,0x0000000000000000L,0x0000000000000010L});
    public static final BitSet FOLLOW_collationSpecification_in_sortSpecification112 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000010L});
    public static final BitSet FOLLOW_ORDER_SPEC_in_sortSpecification115 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_COLLATE_in_collationSpecification237 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_expression_in_sortKey258 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_valueExpression_in_expression279 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_column_in_valueExpression300 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_function_in_valueExpression312 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_literal_in_valueExpression324 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rowValueConstructor_in_valueExpression336 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_valueExpression_in_characterValueExpression357 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_valueExpression_in_numericValueExpression378 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_COLUMN_in_column401 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ALIAS_REF_in_column403 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L,0x0000000000200000L});
    public static final BitSet FOLLOW_identifier_in_column405 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IDENTIFIER_in_identifier448 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QUOTED_IDENTIFIER_in_identifier460 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_VECTOR_EXPR_in_rowValueConstructor483 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_rowValueConstructor487 = new BitSet(new long[]{0x4400005C483A0018L,0x8004018800040204L,0x018101C000002001L});
    public static final BitSet FOLLOW_functionFunction_in_function528 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_castFunction_in_function537 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_concatFunction_in_function546 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_substringFunction_in_function555 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_trimFunction_in_function564 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_upperFunction_in_function573 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_lowerFunction_in_function582 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_lengthFunction_in_function591 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_locateFunction_in_function600 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_absFunction_in_function609 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_sqrtFunction_in_function618 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_modFunction_in_function627 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_currentDateFunction_in_function636 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_currentTimeFunction_in_function645 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_currentTimestampFunction_in_function654 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_extractFunction_in_function663 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_positionFunction_in_function672 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_charLengthFunction_in_function681 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_octetLengthFunction_in_function690 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_bitLengthFunction_in_function699 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FUNCTION_in_functionFunction722 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_functionArgument_in_functionFunction726 = new BitSet(new long[]{0x4400005C483A0018L,0x8004018800040204L,0x018101C000002001L});
    public static final BitSet FOLLOW_expression_in_functionArgument758 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CAST_in_castFunction777 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_castFunction779 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_IDENTIFIER_in_castFunction781 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_CONCAT_in_concatFunction811 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_concatFunction815 = new BitSet(new long[]{0x4400005C483A0018L,0x8004018800040204L,0x018101C000002001L});
    public static final BitSet FOLLOW_SUBSTRING_in_substringFunction846 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_substringFunction850 = new BitSet(new long[]{0x4400005C483A0010L,0x8004018800040204L,0x018101C000002001L});
    public static final BitSet FOLLOW_numericValueExpression_in_substringFunction854 = new BitSet(new long[]{0x4400005C483A0018L,0x8004018800040204L,0x018101C000002001L});
    public static final BitSet FOLLOW_numericValueExpression_in_substringFunction858 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_TRIM_in_trimFunction892 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_trimSpec_in_trimFunction896 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_trimChar_in_trimFunction898 = new BitSet(new long[]{0x4400005C483A0010L,0x8004018800040204L,0x018101C000002001L});
    public static final BitSet FOLLOW_trimSource_in_trimFunction900 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LEADING_in_trimSpec933 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_TRAILING_in_trimSpec947 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_BOTH_in_trimSpec960 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_characterValueExpression_in_trimChar986 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_characterValueExpression_in_trimSource1007 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_UPPER_in_upperFunction1030 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_upperFunction1034 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LOWER_in_lowerFunction1067 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_lowerFunction1071 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LENGTH_in_lengthFunction1104 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_lengthFunction1108 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LOCATE_in_locateFunction1141 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_locateFunction1145 = new BitSet(new long[]{0x4400005C483A0010L,0x8004018800040204L,0x018101C000002001L});
    public static final BitSet FOLLOW_characterValueExpression_in_locateFunction1149 = new BitSet(new long[]{0x4400005C483A0018L,0x8004018800040204L,0x018101C000002001L});
    public static final BitSet FOLLOW_numericValueExpression_in_locateFunction1153 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ABS_in_absFunction1187 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_absFunction1191 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_SQRT_in_sqrtFunction1224 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_sqrtFunction1228 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_MOD_in_modFunction1261 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_modFunction1265 = new BitSet(new long[]{0x4400005C483A0010L,0x8004018800040204L,0x018101C000002001L});
    public static final BitSet FOLLOW_expression_in_modFunction1269 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_CURRENT_DATE_in_currentDateFunction1300 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CURRENT_TIME_in_currentTimeFunction1321 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CURRENT_TIMESTAMP_in_currentTimestampFunction1342 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EXTRACT_in_extractFunction1365 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_extractField_in_extractFunction1367 = new BitSet(new long[]{0x4400005C483A0010L,0x8004018800040204L,0x018101C000002001L});
    public static final BitSet FOLLOW_expression_in_extractFunction1369 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_datetimeField_in_extractField1397 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_timeZoneField_in_extractField1402 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_YEAR_in_datetimeField1413 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_MONTH_in_datetimeField1425 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DAY_in_datetimeField1436 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_HOUR_in_datetimeField1449 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_MINUTE_in_datetimeField1461 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_SECOND_in_datetimeField1471 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_TIMEZONE_HOUR_in_timeZoneField1487 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_TIMEZONE_MINUTE_in_timeZoneField1498 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_POSITION_in_positionFunction1518 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_positionFunction1522 = new BitSet(new long[]{0x4400005C483A0010L,0x8004018800040204L,0x018101C000002001L});
    public static final BitSet FOLLOW_expression_in_positionFunction1526 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_CHARACTER_LENGTH_in_charLengthFunction1559 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_charLengthFunction1563 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_OCTET_LENGTH_in_octetLengthFunction1597 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_octetLengthFunction1601 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_BIT_LENGTH_in_bitLengthFunction1635 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_bitLengthFunction1639 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_numeric_literal_in_literal1668 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_HEX_LITERAL_in_literal1677 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_OCTAL_LITERAL_in_literal1686 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CHARACTER_LITERAL_in_literal1695 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_literal1704 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INTEGER_LITERAL_in_numeric_literal1719 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DECIMAL_LITERAL_in_numeric_literal1728 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FLOATING_POINT_LITERAL_in_numeric_literal1737 = new BitSet(new long[]{0x0000000000000002L});

}